/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.ignite.configuration.annotation.Config;
import org.apache.ignite.configuration.annotation.ConfigValue;
import org.apache.ignite.configuration.annotation.ConfigurationRoot;
import org.apache.ignite.configuration.annotation.ConfigurationType;
import org.apache.ignite.configuration.annotation.InternalConfiguration;
import org.apache.ignite.configuration.annotation.NamedConfigValue;
import org.apache.ignite.configuration.annotation.PolymorphicConfig;
import org.apache.ignite.configuration.annotation.PolymorphicConfigInstance;
import org.apache.ignite.configuration.annotation.PolymorphicId;
import org.apache.ignite.configuration.annotation.Value;
import org.apache.ignite.internal.configuration.ConfigurationRegistry;
import org.apache.ignite.internal.configuration.FifthRootConfiguration;
import org.apache.ignite.internal.configuration.FirstRootConfiguration;
import org.apache.ignite.internal.configuration.Fourth0PolymorphicChange;
import org.apache.ignite.internal.configuration.FourthPolymorphicChange;
import org.apache.ignite.internal.configuration.FourthRootConfiguration;
import org.apache.ignite.internal.configuration.SecondRootConfiguration;
import org.apache.ignite.internal.configuration.SixthRootConfiguration;
import org.apache.ignite.internal.configuration.ThirdRootConfiguration;
import org.apache.ignite.internal.configuration.storage.ConfigurationStorage;
import org.apache.ignite.internal.configuration.storage.TestConfigurationStorage;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConfigurationRegistryTest {
    @Test
    void testValidationInternalConfigurationExtensions() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ConfigurationRegistry(List.of(SecondRootConfiguration.KEY), Map.of(), (ConfigurationStorage)new TestConfigurationStorage(ConfigurationType.LOCAL), List.of(ExtendedFirstRootConfigurationSchema.class), List.of()));
        ConfigurationRegistry configRegistry = new ConfigurationRegistry(List.of(FirstRootConfiguration.KEY, SecondRootConfiguration.KEY), Map.of(), (ConfigurationStorage)new TestConfigurationStorage(ConfigurationType.LOCAL), List.of(ExtendedFirstRootConfigurationSchema.class), List.of());
        configRegistry.stop();
    }

    @Test
    void testValidationPolymorphicConfigurationExtensions() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ConfigurationRegistry(List.of(ThirdRootConfiguration.KEY), Map.of(), (ConfigurationStorage)new TestConfigurationStorage(ConfigurationType.LOCAL), List.of(), List.of(Second0PolymorphicConfigurationSchema.class)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ConfigurationRegistry(List.of(ThirdRootConfiguration.KEY), Map.of(), (ConfigurationStorage)new TestConfigurationStorage(ConfigurationType.LOCAL), List.of(), List.of(First0PolymorphicConfigurationSchema.class, ErrorFirst0PolymorphicConfigurationSchema.class)));
        ConfigurationRegistry configRegistry = new ConfigurationRegistry(List.of(ThirdRootConfiguration.KEY, FourthRootConfiguration.KEY, FifthRootConfiguration.KEY), Map.of(), (ConfigurationStorage)new TestConfigurationStorage(ConfigurationType.LOCAL), List.of(), List.of(First0PolymorphicConfigurationSchema.class, First1PolymorphicConfigurationSchema.class, Second0PolymorphicConfigurationSchema.class, Third0PolymorphicConfigurationSchema.class, Third1PolymorphicConfigurationSchema.class));
        configRegistry.stop();
    }

    @Test
    void missingPolymorphicExtension() {
        IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> new ConfigurationRegistry(List.of(ThirdRootConfiguration.KEY), Map.of(), (ConfigurationStorage)new TestConfigurationStorage(ConfigurationType.LOCAL), List.of(), List.of()));
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.is((Object)"Polymorphic configuration schemas for which no extensions were found: [class org.apache.ignite.internal.configuration.ConfigurationRegistryTest$FirstPolymorphicConfigurationSchema]"));
    }

    @Test
    void testComplicatedPolymorphicConfig() throws Exception {
        ConfigurationRegistry registry = new ConfigurationRegistry(List.of(SixthRootConfiguration.KEY), Map.of(), (ConfigurationStorage)new TestConfigurationStorage(ConfigurationType.LOCAL), List.of(), List.of(Fourth0PolymorphicConfigurationSchema.class));
        registry.start();
        try {
            ((SixthRootConfiguration)registry.getConfiguration(SixthRootConfiguration.KEY)).change(c -> c.changePoly(this.toFirst0Polymorphic(0)).changePolyNamed(c0 -> c0.create("1", this.toFirst0Polymorphic(1))).changeEntity(c0 -> c0.changePoly(this.toFirst0Polymorphic(2)).changePolyNamed(c1 -> c1.create("3", this.toFirst0Polymorphic(3)))).changeEntityNamed(c0 -> c0.create("4", c1 -> c1.changePoly(this.toFirst0Polymorphic(4)).changePolyNamed(c2 -> c2.create("5", this.toFirst0Polymorphic(5)))))).get(1L, TimeUnit.SECONDS);
        }
        finally {
            registry.stop();
        }
    }

    private Consumer<FourthPolymorphicChange> toFirst0Polymorphic(int v) {
        return c -> c.convert(Fourth0PolymorphicChange.class).changeIntVal(v).changeStrVal(Integer.toString(v));
    }

    @PolymorphicConfigInstance(value="fourth0")
    public static class Fourth0PolymorphicConfigurationSchema
    extends FourthPolymorphicConfigurationSchema {
        @Value
        public int intVal;
    }

    @PolymorphicConfig
    public static class FourthPolymorphicConfigurationSchema {
        @PolymorphicId(hasDefault=true)
        public String typeId = "fourth0";
        @Value
        public String strVal;
    }

    @PolymorphicConfigInstance(value="third1")
    public static class Third1PolymorphicConfigurationSchema
    extends ThirdPolymorphicConfigurationSchema {
    }

    @PolymorphicConfigInstance(value="third0")
    public static class Third0PolymorphicConfigurationSchema
    extends ThirdPolymorphicConfigurationSchema {
    }

    @PolymorphicConfig
    public static class ThirdPolymorphicConfigurationSchema {
        @PolymorphicId(hasDefault=true)
        public String typeId = "third0";
    }

    @PolymorphicConfigInstance(value="second0")
    public static class Second0PolymorphicConfigurationSchema
    extends SecondPolymorphicConfigurationSchema {
    }

    @PolymorphicConfig
    public static class SecondPolymorphicConfigurationSchema {
        @PolymorphicId
        public String typeId;
    }

    @PolymorphicConfigInstance(value="first0")
    public static class ErrorFirst0PolymorphicConfigurationSchema
    extends FirstPolymorphicConfigurationSchema {
    }

    @PolymorphicConfigInstance(value="first1")
    public static class First1PolymorphicConfigurationSchema
    extends FirstPolymorphicConfigurationSchema {
    }

    @PolymorphicConfigInstance(value="first0")
    public static class First0PolymorphicConfigurationSchema
    extends FirstPolymorphicConfigurationSchema {
    }

    @PolymorphicConfig
    public static class FirstPolymorphicConfigurationSchema {
        @PolymorphicId
        public String typeId;
    }

    @Config
    public static class EntityConfigurationSchema {
        @ConfigValue
        public FourthPolymorphicConfigurationSchema poly;
        @NamedConfigValue
        public FourthPolymorphicConfigurationSchema polyNamed;
    }

    @ConfigurationRoot(rootName="sixth")
    public static class SixthRootConfigurationSchema {
        @ConfigValue
        public FourthPolymorphicConfigurationSchema poly;
        @NamedConfigValue
        public FourthPolymorphicConfigurationSchema polyNamed;
        @ConfigValue
        public EntityConfigurationSchema entity;
        @NamedConfigValue
        public EntityConfigurationSchema entityNamed;
    }

    @ConfigurationRoot(rootName="fifth")
    public static class FifthRootConfigurationSchema {
        @ConfigValue
        public ThirdPolymorphicConfigurationSchema polymorphicConfig;
    }

    @ConfigurationRoot(rootName="fourth")
    public static class FourthRootConfigurationSchema {
        @ConfigValue
        public SecondPolymorphicConfigurationSchema polymorphicConfig;
    }

    @ConfigurationRoot(rootName="third")
    public static class ThirdRootConfigurationSchema {
        @ConfigValue
        public FirstPolymorphicConfigurationSchema polymorphicConfig;
    }

    @InternalConfiguration
    public static class ExtendedFirstRootConfigurationSchema
    extends FirstRootConfigurationSchema {
        @Value(hasDefault=true)
        public String strEx = "str";
    }

    @ConfigurationRoot(rootName="second")
    public static class SecondRootConfigurationSchema {
        @Value(hasDefault=true)
        public String str = "str";
    }

    @ConfigurationRoot(rootName="first")
    public static class FirstRootConfigurationSchema {
        @Value(hasDefault=true)
        public String str = "str";
    }
}

