/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration;

import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.ignite.internal.configuration.ConfigurationListenerHolder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ConfigurationListenerHolderTest {
    private ConfigurationListenerHolder<? super Object> holder;

    @BeforeEach
    void beforeEach() {
        this.holder = new ConfigurationListenerHolder();
    }

    @Test
    void testAddListeners() {
        this.holder.addListener((Object)1, 0L);
        this.holder.addListener((Object)2, 0L);
        this.holder.addListener((Object)1, 0L);
        this.holder.addListener((Object)3, 0L);
        Assertions.assertEquals(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(3)), this.collect(this.holder.listeners(1L)));
    }

    @Test
    void testRemoveListeners() {
        this.holder.addListener((Object)1, 0L);
        this.holder.addListener((Object)2, 0L);
        this.holder.addListener((Object)1, 0L);
        this.holder.removeListener((Object)1);
        Assertions.assertEquals(List.of(Integer.valueOf(2), Integer.valueOf(1)), this.collect(this.holder.listeners(1L)));
    }

    @Test
    void testListeners() {
        Assertions.assertTrue((boolean)this.collect(this.holder.listeners(-1L)).isEmpty());
        Assertions.assertTrue((boolean)this.collect(this.holder.listeners(0L)).isEmpty());
        Assertions.assertTrue((boolean)this.collect(this.holder.listeners(1L)).isEmpty());
        this.holder.addListener((Object)1, 0L);
        this.holder.addListener((Object)2, 0L);
        this.holder.addListener((Object)1, 0L);
        this.holder.addListener((Object)3, 0L);
        this.holder.addListener((Object)4, 1L);
        this.holder.addListener((Object)5, 1L);
        this.holder.addListener((Object)7, 2L);
        this.holder.addListener((Object)8, 2L);
        Assertions.assertTrue((boolean)this.collect(this.holder.listeners(-1L)).isEmpty());
        Assertions.assertEquals(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(3)), this.collect(this.holder.listeners(1L)));
        Assertions.assertEquals(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5)), this.collect(this.holder.listeners(2L)));
        Assertions.assertEquals(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(7), Integer.valueOf(8)), this.collect(this.holder.listeners(3L)));
        Assertions.assertEquals(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(7), Integer.valueOf(8)), this.collect(this.holder.listeners(4L)));
    }

    @Test
    void testClear() {
        this.holder.addListener((Object)1, 0L);
        this.holder.addListener((Object)2, 0L);
        this.holder.clear();
        Assertions.assertTrue((boolean)this.collect(this.holder.listeners(1L)).isEmpty());
    }

    private List<?> collect(Iterator<?> iterator) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 0), false).collect(Collectors.toList());
    }
}

