/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.ignite.configuration.ConfigurationChangeException;
import org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.configuration.RootKey;
import org.apache.ignite.configuration.annotation.Config;
import org.apache.ignite.configuration.annotation.ConfigValue;
import org.apache.ignite.configuration.annotation.ConfigurationRoot;
import org.apache.ignite.configuration.annotation.ConfigurationType;
import org.apache.ignite.configuration.annotation.NamedConfigValue;
import org.apache.ignite.configuration.annotation.Value;
import org.apache.ignite.configuration.validation.Immutable;
import org.apache.ignite.configuration.validation.ValidationContext;
import org.apache.ignite.configuration.validation.ValidationIssue;
import org.apache.ignite.configuration.validation.Validator;
import org.apache.ignite.internal.configuration.ConfigurationChanger;
import org.apache.ignite.internal.configuration.DefaultsChildView;
import org.apache.ignite.internal.configuration.DefaultsConfiguration;
import org.apache.ignite.internal.configuration.DefaultsView;
import org.apache.ignite.internal.configuration.FirstConfiguration;
import org.apache.ignite.internal.configuration.FirstView;
import org.apache.ignite.internal.configuration.TestConfigurationChanger;
import org.apache.ignite.internal.configuration.ThirdView;
import org.apache.ignite.internal.configuration.asm.ConfigurationAsmGenerator;
import org.apache.ignite.internal.configuration.direct.KeyPathNode;
import org.apache.ignite.internal.configuration.storage.Data;
import org.apache.ignite.internal.configuration.storage.TestConfigurationStorage;
import org.apache.ignite.internal.configuration.tree.ConfigurationSource;
import org.apache.ignite.internal.configuration.tree.ConstructableTreeNode;
import org.apache.ignite.internal.testframework.matchers.CompletableFutureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConfigurationChangerTest {
    private static ConfigurationAsmGenerator cgen = new ConfigurationAsmGenerator();
    private final TestConfigurationStorage storage = new TestConfigurationStorage(ConfigurationType.LOCAL);

    @AfterAll
    public static void afterAll() {
        cgen = null;
    }

    @Test
    public void testSimpleConfigurationChange() throws Exception {
        ConfigurationChanger changer = this.createChanger(FirstConfiguration.KEY);
        changer.start();
        changer.change(ConfigurationChangerTest.source(FirstConfiguration.KEY, parent -> parent.changeChild(change -> change.changeIntCfg(1).changeStrCfg("1")).changeElements(change -> change.create("a", element -> element.changeStrCfg("1"))))).get(1L, TimeUnit.SECONDS);
        FirstView newRoot = (FirstView)changer.getRootNode(FirstConfiguration.KEY);
        Assertions.assertEquals((int)1, (int)newRoot.child().intCfg());
        Assertions.assertEquals((Object)"1", (Object)newRoot.child().strCfg());
        Assertions.assertEquals((Object)"1", (Object)((ThirdView)newRoot.elements().get("a")).strCfg());
    }

    @Test
    public void testModifiedFromAnotherStorage() throws Exception {
        ConfigurationChanger changer1 = this.createChanger(FirstConfiguration.KEY);
        changer1.start();
        ConfigurationChanger changer2 = this.createChanger(FirstConfiguration.KEY);
        changer2.start();
        changer1.change(ConfigurationChangerTest.source(FirstConfiguration.KEY, parent -> parent.changeChild(change -> change.changeIntCfg(1).changeStrCfg("1")).changeElements(change -> change.create("a", element -> element.changeStrCfg("1"))))).get(1L, TimeUnit.SECONDS);
        changer2.change(ConfigurationChangerTest.source(FirstConfiguration.KEY, parent -> parent.changeChild(change -> change.changeIntCfg(2).changeStrCfg("2")).changeElements(change -> change.createOrUpdate("a", element -> element.changeStrCfg("2")).create("b", element -> element.changeStrCfg("2"))))).get(1L, TimeUnit.SECONDS);
        FirstView newRoot1 = (FirstView)changer1.getRootNode(FirstConfiguration.KEY);
        Assertions.assertEquals((int)2, (int)newRoot1.child().intCfg());
        Assertions.assertEquals((Object)"2", (Object)newRoot1.child().strCfg());
        Assertions.assertEquals((Object)"2", (Object)((ThirdView)newRoot1.elements().get("a")).strCfg());
        Assertions.assertEquals((Object)"2", (Object)((ThirdView)newRoot1.elements().get("b")).strCfg());
        FirstView newRoot2 = (FirstView)changer2.getRootNode(FirstConfiguration.KEY);
        Assertions.assertEquals((int)2, (int)newRoot2.child().intCfg());
        Assertions.assertEquals((Object)"2", (Object)newRoot2.child().strCfg());
        Assertions.assertEquals((Object)"2", (Object)((ThirdView)newRoot2.elements().get("a")).strCfg());
        Assertions.assertEquals((Object)"2", (Object)((ThirdView)newRoot2.elements().get("b")).strCfg());
    }

    @Test
    public void testModifiedFromAnotherStorageWithIncompatibleChanges() throws Exception {
        ConfigurationChanger changer1 = this.createChanger(FirstConfiguration.KEY);
        changer1.start();
        Validator<MaybeInvalid, Object> validator = new Validator<MaybeInvalid, Object>(){

            public void validate(MaybeInvalid annotation, ValidationContext<Object> ctx) {
                ctx.addIssue(new ValidationIssue("foo"));
            }
        };
        TestConfigurationChanger changer2 = new TestConfigurationChanger(cgen, List.of(FirstConfiguration.KEY), Map.of(MaybeInvalid.class, Set.of(validator)), this.storage, List.of(), List.of());
        changer2.start();
        changer1.change(ConfigurationChangerTest.source(FirstConfiguration.KEY, parent -> parent.changeChild(change -> change.changeIntCfg(1).changeStrCfg("1")).changeElements(change -> change.create("a", element -> element.changeStrCfg("1"))))).get(1L, TimeUnit.SECONDS);
        Assertions.assertThrows(ExecutionException.class, () -> changer2.change(ConfigurationChangerTest.source(FirstConfiguration.KEY, parent -> parent.changeChild(change -> change.changeIntCfg(2).changeStrCfg("2")).changeElements(change -> change.create("a", element -> element.changeStrCfg("2")).create("b", element -> element.changeStrCfg("2"))))).get(1L, TimeUnit.SECONDS));
        FirstView newRoot = (FirstView)changer2.getRootNode(FirstConfiguration.KEY);
        Assertions.assertEquals((int)1, (int)newRoot.child().intCfg());
        Assertions.assertEquals((Object)"1", (Object)newRoot.child().strCfg());
        Assertions.assertEquals((Object)"1", (Object)((ThirdView)newRoot.elements().get("a")).strCfg());
    }

    @Test
    public void testFailedToWrite() {
        ConfigurationChanger changer = this.createChanger(FirstConfiguration.KEY);
        this.storage.fail(true);
        Assertions.assertThrows(ConfigurationChangeException.class, () -> ((ConfigurationChanger)changer).start());
        this.storage.fail(false);
        changer.start();
        this.storage.fail(true);
        Assertions.assertThrows(ExecutionException.class, () -> changer.change(ConfigurationChangerTest.source(FirstConfiguration.KEY, parent -> parent.changeChild(child -> child.changeIntCfg(1).changeStrCfg("1")))).get(1L, TimeUnit.SECONDS));
        this.storage.fail(false);
        CompletionStage dataFuture = this.storage.readAll().thenApply(Data::values);
        MatcherAssert.assertThat((Object)dataFuture, (Matcher)CompletableFutureMatcher.willBe((Matcher)Matchers.anEmptyMap()));
        FirstView newRoot = (FirstView)changer.getRootNode(FirstConfiguration.KEY);
        Assertions.assertNotNull((Object)newRoot.child());
        Assertions.assertNull((Object)newRoot.child().strCfg());
    }

    @Test
    public void defaultsOnInit() throws Exception {
        ConfigurationChanger changer = this.createChanger(DefaultsConfiguration.KEY);
        changer.start();
        changer.initializeDefaults();
        DefaultsView root = (DefaultsView)changer.getRootNode(DefaultsConfiguration.KEY);
        Assertions.assertEquals((Object)"foo", (Object)root.defStr());
        Assertions.assertEquals((Object)"bar", (Object)root.child().defStr());
        Assertions.assertEquals(List.of("xyz"), Arrays.asList(root.child().arr()));
        changer.change(ConfigurationChangerTest.source(DefaultsConfiguration.KEY, def -> def.changeChildrenList(children -> children.create("name", child -> {})))).get(1L, TimeUnit.SECONDS);
        root = (DefaultsView)changer.getRootNode(DefaultsConfiguration.KEY);
        Assertions.assertEquals((Object)"bar", (Object)((DefaultsChildView)root.childrenList().get("name")).defStr());
    }

    @Test
    public void testGetLatest() throws Exception {
        ConfigurationChanger changer = this.createChanger(DefaultsConfiguration.KEY);
        changer.start();
        changer.initializeDefaults();
        ConfigurationSource source = ConfigurationChangerTest.source(DefaultsConfiguration.KEY, change -> change.changeChildrenList(children -> children.create("name", child -> {})));
        changer.change(source).get(1L, TimeUnit.SECONDS);
        DefaultsView configurationView = (DefaultsView)changer.getLatest(List.of(ConfigurationChangerTest.node("def")));
        Assertions.assertEquals((Object)"foo", (Object)configurationView.defStr());
        Assertions.assertEquals((Object)"bar", (Object)configurationView.child().defStr());
        Assertions.assertArrayEquals((Object[])new String[]{"xyz"}, (Object[])configurationView.child().arr());
        Assertions.assertEquals((Object)"bar", (Object)((DefaultsChildView)configurationView.childrenList().get("name")).defStr());
    }

    @Test
    public void testGetLatestNested() {
        ConfigurationChanger changer = this.createChanger(DefaultsConfiguration.KEY);
        changer.start();
        changer.initializeDefaults();
        DefaultsChildView childView = (DefaultsChildView)changer.getLatest(List.of(ConfigurationChangerTest.node("def"), ConfigurationChangerTest.node("child")));
        Assertions.assertEquals((Object)"bar", (Object)childView.defStr());
        Assertions.assertArrayEquals((Object[])new String[]{"xyz"}, (Object[])childView.arr());
        String childStrValueView = (String)changer.getLatest(List.of(ConfigurationChangerTest.node("def"), ConfigurationChangerTest.node("child"), ConfigurationChangerTest.node("defStr")));
        Assertions.assertEquals((Object)"bar", (Object)childStrValueView);
        Object[] childArrView = (String[])changer.getLatest(List.of(ConfigurationChangerTest.node("def"), ConfigurationChangerTest.node("child"), ConfigurationChangerTest.node("arr")));
        Assertions.assertArrayEquals((Object[])new String[]{"xyz"}, (Object[])childArrView);
    }

    @Test
    public void testGetLatestNamedList() throws Exception {
        ConfigurationChanger changer = this.createChanger(DefaultsConfiguration.KEY);
        changer.start();
        changer.initializeDefaults();
        ConfigurationSource source = ConfigurationChangerTest.source(DefaultsConfiguration.KEY, change -> change.changeChildrenList(children -> {
            children.create("name1", child -> {});
            children.create("name2", child -> {});
        }));
        changer.change(source).get(1L, TimeUnit.SECONDS);
        for (String name : List.of("name1", "name2")) {
            NamedListView childrenListView = (NamedListView)changer.getLatest(List.of(ConfigurationChangerTest.node("def"), ConfigurationChangerTest.node("childrenList")));
            DefaultsChildView childrenListElementView = (DefaultsChildView)childrenListView.get(name);
            Assertions.assertEquals((Object)"bar", (Object)childrenListElementView.defStr());
            Assertions.assertArrayEquals((Object[])new String[]{"xyz"}, (Object[])childrenListElementView.arr());
            childrenListElementView = (DefaultsChildView)changer.getLatest(List.of(ConfigurationChangerTest.node("def"), ConfigurationChangerTest.node("childrenList"), ConfigurationChangerTest.listNode(name)));
            Assertions.assertEquals((Object)"bar", (Object)childrenListElementView.defStr());
            Assertions.assertArrayEquals((Object[])new String[]{"xyz"}, (Object[])childrenListElementView.arr());
            String childrenListStrValueView = (String)changer.getLatest(List.of(ConfigurationChangerTest.node("def"), ConfigurationChangerTest.node("childrenList"), ConfigurationChangerTest.listNode(name), ConfigurationChangerTest.node("defStr")));
            Assertions.assertEquals((Object)"bar", (Object)childrenListStrValueView);
            Object[] childrenListArrView = (String[])changer.getLatest(List.of(ConfigurationChangerTest.node("def"), ConfigurationChangerTest.node("childrenList"), ConfigurationChangerTest.listNode(name), ConfigurationChangerTest.node("arr")));
            Assertions.assertArrayEquals((Object[])new String[]{"xyz"}, (Object[])childrenListArrView);
        }
    }

    @Test
    public void testGetLatestMissingKey() throws Exception {
        ConfigurationChanger changer = this.createChanger(DefaultsConfiguration.KEY);
        changer.start();
        changer.initializeDefaults();
        ConfigurationSource source = ConfigurationChangerTest.source(DefaultsConfiguration.KEY, change -> change.changeChildrenList(children -> children.create("name", child -> {})));
        changer.change(source).get(1L, TimeUnit.SECONDS);
        NoSuchElementException e = (NoSuchElementException)Assertions.assertThrows(NoSuchElementException.class, () -> changer.getLatest(List.of(ConfigurationChangerTest.node("foo"))));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"foo"));
        e = (NoSuchElementException)Assertions.assertThrows(NoSuchElementException.class, () -> changer.getLatest(List.of(ConfigurationChangerTest.node("def"), ConfigurationChangerTest.node("foo"))));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"foo"));
        e = (NoSuchElementException)Assertions.assertThrows(NoSuchElementException.class, () -> changer.getLatest(List.of(ConfigurationChangerTest.node("def"), ConfigurationChangerTest.node("defStr"), ConfigurationChangerTest.node("foo"))));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"def.defStr.foo"));
        e = (NoSuchElementException)Assertions.assertThrows(NoSuchElementException.class, () -> changer.getLatest(List.of(ConfigurationChangerTest.node("def"), ConfigurationChangerTest.node("child"), ConfigurationChangerTest.node("foo"))));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"foo"));
        e = (NoSuchElementException)Assertions.assertThrows(NoSuchElementException.class, () -> changer.getLatest(List.of(ConfigurationChangerTest.node("def"), ConfigurationChangerTest.node("child"), ConfigurationChangerTest.node("defStr"), ConfigurationChangerTest.node("foo"))));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"def.child.defStr.foo"));
        e = (NoSuchElementException)Assertions.assertThrows(NoSuchElementException.class, () -> changer.getLatest(List.of(ConfigurationChangerTest.node("def"), ConfigurationChangerTest.node("childrenList"), ConfigurationChangerTest.listNode("foo"))));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"def.childrenList.foo"));
        e = (NoSuchElementException)Assertions.assertThrows(NoSuchElementException.class, () -> changer.getLatest(List.of(ConfigurationChangerTest.node("def"), ConfigurationChangerTest.node("childrenList"), ConfigurationChangerTest.listNode("name"), ConfigurationChangerTest.node("foo"))));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"def.childrenList.name.foo"));
        e = (NoSuchElementException)Assertions.assertThrows(NoSuchElementException.class, () -> changer.getLatest(List.of(ConfigurationChangerTest.node("def"), ConfigurationChangerTest.node("childrenList"), ConfigurationChangerTest.listNode("name"), ConfigurationChangerTest.node("defStr"), ConfigurationChangerTest.node("foo"))));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"def.childrenList.name.defStr"));
    }

    @Test
    void testLastRevision() throws Exception {
        ConfigurationChanger changer = this.createChanger(DefaultsConfiguration.KEY);
        changer.start();
        changer.initializeDefaults();
        Assertions.assertEquals((long)1L, (Long)this.storage.lastRevision().get(1L, TimeUnit.SECONDS));
        changer.change(ConfigurationChangerTest.source(DefaultsConfiguration.KEY, c -> c.changeDefStr("test0"))).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((long)2L, (Long)this.storage.lastRevision().get(1L, TimeUnit.SECONDS));
        this.storage.incrementAndGetRevision();
        Assertions.assertEquals((long)3L, (Long)this.storage.lastRevision().get(1L, TimeUnit.SECONDS));
        AtomicInteger invokeConsumerCnt = new AtomicInteger();
        CompletableFuture changeFut = changer.change(ConfigurationChangerTest.source(DefaultsConfiguration.KEY, c -> {
            invokeConsumerCnt.incrementAndGet();
            try {
                Assertions.assertEquals((long)3L, (Long)this.storage.lastRevision().get(1L, TimeUnit.SECONDS));
            }
            catch (Exception e) {
                Assertions.fail((Throwable)e);
            }
            c.changeDefStr("test1");
        }));
        Assertions.assertThrows(TimeoutException.class, () -> changeFut.get(1L, TimeUnit.SECONDS));
        Assertions.assertEquals((int)0, (int)invokeConsumerCnt.get());
        this.storage.decrementAndGetRevision();
        Assertions.assertEquals((long)2L, (Long)this.storage.lastRevision().get(1L, TimeUnit.SECONDS));
        changer.change(ConfigurationChangerTest.source(DefaultsConfiguration.KEY, c -> c.changeDefStr("test00"))).get(1L, TimeUnit.SECONDS);
        changeFut.get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)1, (int)invokeConsumerCnt.get());
    }

    @Test
    void testUpdateStorageRevisionOnEmptyChanges() throws Exception {
        ConfigurationChanger changer = this.createChanger(DefaultsConfiguration.KEY);
        changer.start();
        changer.initializeDefaults();
        Assertions.assertEquals((long)1L, (Long)this.storage.lastRevision().get(1L, TimeUnit.SECONDS));
        changer.change(ConfigurationChangerTest.source(DefaultsConfiguration.KEY, c -> {})).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((long)2L, (Long)this.storage.lastRevision().get(1L, TimeUnit.SECONDS));
        changer.change(ConfigurationChangerTest.source(DefaultsConfiguration.KEY, c -> c.changeDefStr("foo"))).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((long)3L, (Long)this.storage.lastRevision().get(1L, TimeUnit.SECONDS));
    }

    private static <CHANGET> ConfigurationSource source(final RootKey<?, ? super CHANGET> rootKey, final Consumer<CHANGET> changer) {
        return new ConfigurationSource(){

            public void descend(ConstructableTreeNode node) {
                ConfigurationSource changerSrc = new ConfigurationSource(){

                    public void descend(ConstructableTreeNode node) {
                        changer.accept(node);
                    }
                };
                node.construct(rootKey.key(), changerSrc, true);
            }
        };
    }

    private ConfigurationChanger createChanger(RootKey<?, ?> rootKey) {
        return new TestConfigurationChanger(cgen, List.of(rootKey), Map.of(), this.storage, List.of(), List.of());
    }

    private static KeyPathNode node(String key) {
        return new KeyPathNode(key);
    }

    private static KeyPathNode listNode(String key) {
        return new KeyPathNode(key, true);
    }

    @Config
    public static class DefaultsChildConfigurationSchema {
        @Value(hasDefault=true)
        public String defStr = "bar";
        @Value(hasDefault=true)
        public String[] arr = new String[]{"xyz"};
    }

    @ConfigurationRoot(rootName="def", type=ConfigurationType.LOCAL)
    public static class DefaultsConfigurationSchema {
        @ConfigValue
        public DefaultsChildConfigurationSchema child;
        @NamedConfigValue
        public DefaultsChildConfigurationSchema childrenList;
        @Value(hasDefault=true)
        public String defStr = "foo";
    }

    @Config
    public static class ThirdConfigurationSchema {
        @Value
        public String strCfg;
    }

    @Config
    public static class SecondConfigurationSchema {
        @Value
        @Immutable
        public int intCfg;
        @Value
        public String strCfg;
    }

    @ConfigurationRoot(rootName="key", type=ConfigurationType.LOCAL)
    public static class FirstConfigurationSchema {
        @ConfigValue
        @MaybeInvalid
        public SecondConfigurationSchema child;
        @NamedConfigValue
        public ThirdConfigurationSchema elements;
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface MaybeInvalid {
    }
}

