/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.validation;

import java.util.List;
import java.util.function.Function;
import org.apache.ignite.configuration.RootKey;
import org.apache.ignite.configuration.validation.ValidationContext;
import org.apache.ignite.configuration.validation.ValidationIssue;
import org.apache.ignite.internal.configuration.SuperRoot;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.apache.ignite.internal.configuration.tree.TraversableTreeNode;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.apache.ignite.internal.configuration.util.KeyNotFoundException;

class ValidationContextImpl<VIEWT>
implements ValidationContext<VIEWT> {
    private final SuperRoot oldRoots;
    private final SuperRoot newRoots;
    private final Function<RootKey<?, ?>, InnerNode> otherRoots;
    private final VIEWT val;
    private final String currentKey;
    private final List<String> currentPath;
    private final List<ValidationIssue> issues;

    ValidationContextImpl(SuperRoot oldRoots, SuperRoot newRoots, Function<RootKey<?, ?>, InnerNode> otherRoots, VIEWT val, String currentKey, List<String> currentPath, List<ValidationIssue> issues) {
        this.oldRoots = oldRoots;
        this.newRoots = newRoots;
        this.otherRoots = otherRoots;
        this.val = val;
        this.currentKey = currentKey;
        this.currentPath = currentPath;
        this.issues = issues;
        assert (!currentPath.isEmpty());
    }

    public String currentKey() {
        return this.currentKey;
    }

    public VIEWT getOldValue() {
        try {
            return (VIEWT)ConfigurationUtil.find(this.currentPath, this.oldRoots, true);
        }
        catch (KeyNotFoundException ignore) {
            return null;
        }
    }

    public VIEWT getNewValue() {
        return this.val;
    }

    public <ROOT> ROOT getOldRoot(RootKey<?, ROOT> rootKey) {
        InnerNode root = this.oldRoots.getRoot(rootKey);
        return (ROOT)(root == null ? this.otherRoots.apply(rootKey) : root);
    }

    public <ROOT> ROOT getNewRoot(RootKey<?, ROOT> rootKey) {
        InnerNode root = this.newRoots.getRoot(rootKey);
        return (ROOT)(root == null ? (TraversableTreeNode)this.otherRoots.apply(rootKey) : root);
    }

    public void addIssue(ValidationIssue issue) {
        this.issues.add(issue);
    }
}

