/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.configuration.ConfigurationProperty;
import org.apache.ignite.configuration.notifications.ConfigurationListener;
import org.apache.ignite.configuration.notifications.ConfigurationNamedListListener;
import org.apache.ignite.configuration.notifications.ConfigurationNotificationEvent;
import org.apache.ignite.internal.configuration.ConfigurationNode;
import org.apache.ignite.internal.configuration.DynamicConfiguration;
import org.apache.ignite.internal.configuration.DynamicProperty;
import org.apache.ignite.internal.configuration.NamedListConfiguration;
import org.apache.ignite.internal.configuration.tree.ConfigurationVisitor;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.apache.ignite.internal.configuration.tree.NamedListNode;
import org.apache.ignite.internal.configuration.util.ConfigurationContainer;
import org.apache.ignite.internal.configuration.util.ConfigurationNotificationEventImpl;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.apache.ignite.internal.util.CollectionUtils;
import org.jetbrains.annotations.Nullable;

public class ConfigurationNotificationsUtil {
    public static void notifyListeners(@Nullable InnerNode oldInnerNode, InnerNode newInnerNode, DynamicConfiguration<InnerNode, ?> cfgNode, long storageRevision, List<CompletableFuture<?>> futures) {
        ConfigurationNotificationsUtil.notifyListeners(oldInnerNode, newInnerNode, cfgNode, storageRevision, futures, List.of(), new HashMap(), true);
    }

    private static void notifyListeners(@Nullable InnerNode oldInnerNode, final InnerNode newInnerNode, final DynamicConfiguration<InnerNode, ?> cfgNode, final long storageRevision, final List<CompletableFuture<?>> futures, final Collection<DynamicConfiguration<InnerNode, ?>> anyConfigs, final Map<Class<?>, ConfigurationContainer> eventConfigs, boolean putConfigContainer) {
        assert (!(cfgNode instanceof NamedListConfiguration));
        if (oldInnerNode == null || oldInnerNode == newInnerNode) {
            return;
        }
        if (putConfigContainer) {
            ConfigurationNotificationsUtil.putConfigContainer(eventConfigs, cfgNode, null);
        }
        for (DynamicConfiguration<InnerNode, ?> anyConfig : anyConfigs) {
            ConfigurationNotificationsUtil.notifyPublicListeners(anyConfig.listeners(), oldInnerNode, newInnerNode, storageRevision, futures, ConfigurationListener::onUpdate, eventConfigs);
        }
        ConfigurationNotificationsUtil.notifyPublicListeners(cfgNode.listeners(), oldInnerNode, newInnerNode, storageRevision, futures, ConfigurationListener::onUpdate, eventConfigs);
        if (oldInnerNode.schemaType() != newInnerNode.schemaType()) {
            return;
        }
        oldInnerNode.traverseChildren(new ConfigurationVisitor<Void>(){

            @Override
            public Void visitLeafNode(String key, Serializable oldLeaf) {
                Serializable newLeaf = newInnerNode.traverseChild(key, ConfigurationUtil.leafNodeVisitor(), true);
                if (newLeaf != oldLeaf) {
                    for (DynamicConfiguration anyConfig : anyConfigs) {
                        ConfigurationNotificationsUtil.notifyPublicListeners(ConfigurationNotificationsUtil.listeners(ConfigurationNotificationsUtil.dynamicProperty(anyConfig, key)), oldLeaf, newLeaf, storageRevision, futures, ConfigurationListener::onUpdate, eventConfigs);
                    }
                    ConfigurationNotificationsUtil.notifyPublicListeners(ConfigurationNotificationsUtil.dynamicProperty(cfgNode, key).listeners(), oldLeaf, newLeaf, storageRevision, futures, ConfigurationListener::onUpdate, eventConfigs);
                }
                return null;
            }

            @Override
            public Void visitInnerNode(String key, InnerNode oldNode) {
                InnerNode newNode = newInnerNode.traverseChild(key, ConfigurationUtil.innerNodeVisitor(), true);
                ConfigurationNotificationsUtil.notifyListeners(oldNode, newNode, ConfigurationNotificationsUtil.dynamicConfig(cfgNode, key), storageRevision, futures, CollectionUtils.viewReadOnly((Collection)anyConfigs, cfg -> ConfigurationNotificationsUtil.dynamicConfig(cfg, key)), eventConfigs, true);
                return null;
            }

            @Override
            public Void visitNamedListNode(String key, NamedListNode<?> oldNamedList) {
                NamedListNode<?> newNamedList = newInnerNode.traverseChild(key, ConfigurationUtil.namedListNodeVisitor(), true);
                if (newNamedList != oldNamedList) {
                    InnerNode newVal;
                    InnerNode oldVal;
                    for (DynamicConfiguration anyConfig : anyConfigs) {
                        ConfigurationNotificationsUtil.notifyPublicListeners(ConfigurationNotificationsUtil.listeners(ConfigurationNotificationsUtil.namedDynamicConfig(anyConfig, key)), oldNamedList, newNamedList, storageRevision, futures, ConfigurationListener::onUpdate, eventConfigs);
                    }
                    ConfigurationNotificationsUtil.notifyPublicListeners(ConfigurationNotificationsUtil.namedDynamicConfig(cfgNode, key).listeners(), oldNamedList, newNamedList, storageRevision, futures, ConfigurationListener::onUpdate, eventConfigs);
                    List<String> oldNames = oldNamedList.namedListKeys();
                    List<String> newNames = newNamedList.namedListKeys();
                    NamedListConfiguration<?, InnerNode, ?> namedListCfg = ConfigurationNotificationsUtil.namedDynamicConfig(cfgNode, key);
                    Map<String, ConfigurationProperty<?>> namedListCfgMembers = namedListCfg.touchMembers();
                    HashSet<String> created = new HashSet<String>(newNames);
                    created.removeAll(oldNames);
                    HashSet<String> deleted = new HashSet<String>(oldNames);
                    deleted.removeAll(newNames);
                    HashMap<String, String> renamed = new HashMap<String, String>();
                    if (!created.isEmpty() && !deleted.isEmpty()) {
                        HashMap<UUID, String> createdIds = new HashMap<UUID, String>();
                        for (String string : created) {
                            createdIds.put(newNamedList.internalId(string), string);
                        }
                        for (String string : Set.copyOf(deleted)) {
                            UUID internalId = oldNamedList.internalId(string);
                            String maybeRenamedKey = (String)createdIds.get(internalId);
                            if (maybeRenamedKey == null) continue;
                            deleted.remove(string);
                            created.remove(maybeRenamedKey);
                            renamed.put(string, maybeRenamedKey);
                        }
                    }
                    Collection<DynamicConfiguration<InnerNode, ?>> newAnyConfigs = null;
                    for (String string : created) {
                        DynamicConfiguration newNodeCfg = (DynamicConfiguration)namedListCfg.members().get(string);
                        ConfigurationNotificationsUtil.touch(newNodeCfg);
                        ConfigurationNotificationsUtil.putConfigContainer(eventConfigs, newNodeCfg, string);
                        InnerNode newVal2 = newNamedList.getInnerNode(string);
                        for (Object anyConfig : anyConfigs) {
                            ConfigurationNotificationsUtil.notifyPublicListeners(ConfigurationNotificationsUtil.extendedListeners(ConfigurationNotificationsUtil.namedDynamicConfig(anyConfig, key)), null, newVal2, storageRevision, futures, ConfigurationNamedListListener::onCreate, eventConfigs);
                        }
                        ConfigurationNotificationsUtil.notifyPublicListeners(ConfigurationNotificationsUtil.namedDynamicConfig(cfgNode, key).extendedListeners(), null, newVal2, storageRevision, futures, ConfigurationNamedListListener::onCreate, eventConfigs);
                        if (newAnyConfigs == null) {
                            newAnyConfigs = ConfigurationNotificationsUtil.mergeAnyConfigs(CollectionUtils.viewReadOnly((Collection)anyConfigs, cfg -> ConfigurationNotificationsUtil.any(ConfigurationNotificationsUtil.namedDynamicConfig(cfg, key))), ConfigurationNotificationsUtil.any(namedListCfg));
                        }
                        ConfigurationNotificationsUtil.notifyAnyListenersOnCreate(newVal2, newNodeCfg, storageRevision, futures, newAnyConfigs, eventConfigs);
                        ConfigurationNotificationsUtil.removeConfigContainer(eventConfigs, newNodeCfg);
                    }
                    for (String string : deleted) {
                        DynamicConfiguration delNodeCfg = (DynamicConfiguration)namedListCfgMembers.get(string);
                        delNodeCfg.removedFromNamedList();
                        ConfigurationNotificationsUtil.putConfigContainer(eventConfigs, delNodeCfg, string);
                        oldVal = oldNamedList.getInnerNode(string);
                        for (Object anyConfig : anyConfigs) {
                            ConfigurationNotificationsUtil.notifyPublicListeners(ConfigurationNotificationsUtil.extendedListeners(ConfigurationNotificationsUtil.namedDynamicConfig(anyConfig, key)), oldVal, null, storageRevision, futures, ConfigurationNamedListListener::onDelete, eventConfigs);
                        }
                        ConfigurationNotificationsUtil.notifyPublicListeners(ConfigurationNotificationsUtil.namedDynamicConfig(cfgNode, key).extendedListeners(), oldVal, null, storageRevision, futures, ConfigurationNamedListListener::onDelete, eventConfigs);
                        for (Object anyConfig : anyConfigs) {
                            ConfigurationNotificationsUtil.notifyPublicListeners(ConfigurationNotificationsUtil.listeners(ConfigurationNotificationsUtil.any(ConfigurationNotificationsUtil.namedDynamicConfig(anyConfig, key))), oldVal, null, storageRevision, futures, ConfigurationListener::onUpdate, eventConfigs);
                        }
                        ConfigurationNotificationsUtil.notifyPublicListeners(delNodeCfg.listeners(), oldVal, null, storageRevision, futures, ConfigurationListener::onUpdate, eventConfigs);
                        ConfigurationNotificationsUtil.removeConfigContainer(eventConfigs, delNodeCfg);
                    }
                    for (Map.Entry entry : renamed.entrySet()) {
                        DynamicConfiguration renNodeCfg = (DynamicConfiguration)namedListCfg.members().get(entry.getValue());
                        ConfigurationNotificationsUtil.putConfigContainer(eventConfigs, renNodeCfg, (String)entry.getValue());
                        oldVal = oldNamedList.getInnerNode((String)entry.getKey());
                        newVal = newNamedList.getInnerNode((String)entry.getValue());
                        for (DynamicConfiguration anyConfig : anyConfigs) {
                            ConfigurationNotificationsUtil.notifyPublicListeners(ConfigurationNotificationsUtil.extendedListeners(ConfigurationNotificationsUtil.namedDynamicConfig(anyConfig, key)), oldVal, newVal, storageRevision, futures, (listener, evt) -> listener.onRename((String)entry.getKey(), (String)entry.getValue(), evt), eventConfigs);
                        }
                        ConfigurationNotificationsUtil.notifyPublicListeners(ConfigurationNotificationsUtil.namedDynamicConfig(cfgNode, key).extendedListeners(), oldVal, newVal, storageRevision, futures, (listener, evt) -> listener.onRename((String)entry.getKey(), (String)entry.getValue(), evt), eventConfigs);
                        ConfigurationNotificationsUtil.removeConfigContainer(eventConfigs, renNodeCfg);
                    }
                    HashSet<String> updated = new HashSet<String>(newNames);
                    updated.retainAll(oldNames);
                    for (String name : updated) {
                        oldVal = oldNamedList.getInnerNode(name);
                        if (oldVal == (newVal = newNamedList.getInnerNode(name))) continue;
                        DynamicConfiguration updNodeCfg = (DynamicConfiguration)namedListCfgMembers.get(name);
                        ConfigurationNotificationsUtil.putConfigContainer(eventConfigs, updNodeCfg, name);
                        for (DynamicConfiguration anyConfig : anyConfigs) {
                            ConfigurationNotificationsUtil.notifyPublicListeners(ConfigurationNotificationsUtil.extendedListeners(ConfigurationNotificationsUtil.namedDynamicConfig(anyConfig, key)), oldVal, newVal, storageRevision, futures, ConfigurationListener::onUpdate, eventConfigs);
                        }
                        ConfigurationNotificationsUtil.notifyPublicListeners(ConfigurationNotificationsUtil.namedDynamicConfig(cfgNode, key).extendedListeners(), oldVal, newVal, storageRevision, futures, ConfigurationListener::onUpdate, eventConfigs);
                        if (newAnyConfigs == null) {
                            newAnyConfigs = ConfigurationNotificationsUtil.mergeAnyConfigs(CollectionUtils.viewReadOnly((Collection)anyConfigs, cfg -> ConfigurationNotificationsUtil.any(ConfigurationNotificationsUtil.namedDynamicConfig(cfg, key))), ConfigurationNotificationsUtil.any(namedListCfg));
                        }
                        ConfigurationNotificationsUtil.notifyListeners(oldVal, newVal, updNodeCfg, storageRevision, futures, newAnyConfigs, eventConfigs, false);
                    }
                }
                return null;
            }
        }, true);
        ConfigurationNotificationsUtil.removeConfigContainer(eventConfigs, cfgNode);
    }

    private static <V, L extends ConfigurationListener<V>> void notifyPublicListeners(Collection<? extends L> listeners, @Nullable V oldVal, V newVal, long storageRevision, List<CompletableFuture<?>> futures, BiFunction<L, ConfigurationNotificationEvent<V>, CompletableFuture<?>> updater, Map<Class<?>, ConfigurationContainer> configs) {
        if (listeners.isEmpty()) {
            return;
        }
        ConfigurationNotificationEventImpl<V> evt = new ConfigurationNotificationEventImpl<V>(oldVal, newVal, storageRevision, configs);
        for (ConfigurationListener listener : listeners) {
            try {
                CompletableFuture<?> future = updater.apply(listener, evt);
                assert (future != null) : updater;
                if (!future.isCompletedExceptionally() && !future.isCancelled() && future.isDone()) continue;
                futures.add(future);
            }
            catch (Throwable t) {
                futures.add(CompletableFuture.failedFuture(t));
            }
        }
    }

    public static void touch(DynamicConfiguration<?, ?> cfg) {
        cfg.touchMembers();
        for (ConfigurationProperty<?> value : cfg.members().values()) {
            if (!(value instanceof DynamicConfiguration)) continue;
            ConfigurationNotificationsUtil.touch((DynamicConfiguration)value);
        }
    }

    private static void notifyAnyListenersOnCreate(InnerNode innerNode, final DynamicConfiguration<InnerNode, ?> cfgNode, final long storageRevision, final List<CompletableFuture<?>> futures, final Collection<DynamicConfiguration<InnerNode, ?>> anyConfigs, final Map<Class<?>, ConfigurationContainer> configs) {
        assert (!(cfgNode instanceof NamedListConfiguration));
        for (DynamicConfiguration<InnerNode, ?> anyConfig : anyConfigs) {
            ConfigurationNotificationsUtil.notifyPublicListeners(anyConfig.listeners(), null, innerNode, storageRevision, futures, ConfigurationListener::onUpdate, configs);
        }
        innerNode.traverseChildren(new ConfigurationVisitor<Void>(){

            @Override
            public Void visitLeafNode(String key, Serializable newLeaf) {
                for (DynamicConfiguration anyConfig : anyConfigs) {
                    ConfigurationNotificationsUtil.notifyPublicListeners(ConfigurationNotificationsUtil.listeners(ConfigurationNotificationsUtil.dynamicProperty(anyConfig, key)), null, newLeaf, storageRevision, futures, ConfigurationListener::onUpdate, configs);
                }
                return null;
            }

            @Override
            public Void visitInnerNode(String key, InnerNode newNode) {
                DynamicConfiguration<InnerNode, ?> innerNodeCfg = ConfigurationNotificationsUtil.dynamicConfig(cfgNode, key);
                configs.put(innerNodeCfg.configType(), new ConfigurationContainer(null, innerNodeCfg));
                ConfigurationNotificationsUtil.notifyAnyListenersOnCreate(newNode, innerNodeCfg, storageRevision, futures, CollectionUtils.viewReadOnly((Collection)anyConfigs, cfg -> ConfigurationNotificationsUtil.dynamicConfig(cfg, key)), configs);
                configs.remove(innerNodeCfg.configType());
                return null;
            }

            @Override
            public Void visitNamedListNode(String key, NamedListNode<?> newNamedList) {
                for (DynamicConfiguration anyConfig : anyConfigs) {
                    ConfigurationNotificationsUtil.notifyPublicListeners(ConfigurationNotificationsUtil.listeners(ConfigurationNotificationsUtil.namedDynamicConfig(anyConfig, key)), null, newNamedList, storageRevision, futures, ConfigurationListener::onUpdate, configs);
                }
                Collection<DynamicConfiguration<InnerNode, ?>> newAnyConfigs = null;
                for (String name : newNamedList.namedListKeys()) {
                    DynamicConfiguration<?, ?> newNodeCfg = ConfigurationNotificationsUtil.namedDynamicConfig(cfgNode, key).getConfig(name);
                    configs.put(newNodeCfg.configType(), new ConfigurationContainer(name, newNodeCfg));
                    InnerNode newVal = newNamedList.getInnerNode(name);
                    for (DynamicConfiguration anyConfig : anyConfigs) {
                        ConfigurationNotificationsUtil.notifyPublicListeners(ConfigurationNotificationsUtil.extendedListeners(ConfigurationNotificationsUtil.namedDynamicConfig(anyConfig, key)), null, newVal, storageRevision, futures, ConfigurationNamedListListener::onCreate, configs);
                    }
                    if (newAnyConfigs == null) {
                        newAnyConfigs = ConfigurationNotificationsUtil.mergeAnyConfigs(CollectionUtils.viewReadOnly((Collection)anyConfigs, cfg -> ConfigurationNotificationsUtil.any(ConfigurationNotificationsUtil.namedDynamicConfig(cfg, key))), ConfigurationNotificationsUtil.any(ConfigurationNotificationsUtil.namedDynamicConfig(cfgNode, key)));
                    }
                    ConfigurationNotificationsUtil.notifyAnyListenersOnCreate(newVal, newNodeCfg, storageRevision, futures, newAnyConfigs, configs);
                    configs.remove(newNodeCfg.configType());
                }
                return null;
            }
        }, true);
    }

    private static Collection<DynamicConfiguration<InnerNode, ?>> mergeAnyConfigs(Collection<DynamicConfiguration<InnerNode, ?>> anyConfigs, @Nullable DynamicConfiguration<InnerNode, ?> anyConfig) {
        return Stream.concat(anyConfigs.stream(), Stream.of(anyConfig)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    private static DynamicProperty<Serializable> dynamicProperty(DynamicConfiguration<InnerNode, ?> dynamicConfig, String nodeName) {
        return (DynamicProperty)dynamicConfig.members().get(nodeName);
    }

    @Nullable
    private static DynamicConfiguration<InnerNode, ?> dynamicConfig(DynamicConfiguration<InnerNode, ?> dynamicConfig, String nodeName) {
        return (DynamicConfiguration)dynamicConfig.members().get(nodeName);
    }

    @Nullable
    private static NamedListConfiguration<?, InnerNode, ?> namedDynamicConfig(DynamicConfiguration<InnerNode, ?> dynamicConfig, String nodeName) {
        return (NamedListConfiguration)dynamicConfig.members().get(nodeName);
    }

    @Nullable
    private static DynamicConfiguration<InnerNode, ?> any(@Nullable NamedListConfiguration<?, InnerNode, ?> namedConfig) {
        return namedConfig == null ? null : (DynamicConfiguration)namedConfig.any();
    }

    private static <T> Collection<ConfigurationListener<T>> listeners(@Nullable ConfigurationNode<T> node) {
        return node == null ? List.of() : node.listeners();
    }

    private static <T> Collection<ConfigurationNamedListListener<T>> extendedListeners(@Nullable NamedListConfiguration<?, T, ?> node) {
        return node == null ? List.of() : node.extendedListeners();
    }

    private static void putConfigContainer(Map<Class<?>, ConfigurationContainer> containers, DynamicConfiguration<InnerNode, ?> cfg, @Nullable String keyNamedCfg) {
        Class<?> polymorphicInstanceConfigType;
        ConfigurationContainer container = new ConfigurationContainer(keyNamedCfg, cfg.isRemovedFromNamedList() ? null : cfg);
        containers.put(cfg.configType(), container);
        Class<?>[] internalConfigTypes = cfg.internalConfigTypes();
        if (internalConfigTypes != null) {
            for (int i = 0; i < internalConfigTypes.length; ++i) {
                containers.put(internalConfigTypes[i], container);
            }
        }
        if ((polymorphicInstanceConfigType = cfg.polymorphicInstanceConfigType()) != null) {
            containers.put(polymorphicInstanceConfigType, new ConfigurationContainer(keyNamedCfg, (ConfigurationProperty<InnerNode>)(cfg.isRemovedFromNamedList() ? null : cfg.specificConfigTree())));
        }
    }

    private static void removeConfigContainer(Map<Class<?>, ConfigurationContainer> containers, DynamicConfiguration<InnerNode, ?> cfg) {
        Class<?> polymorphicInstanceConfigType;
        containers.remove(cfg.configType());
        Class<?>[] internalConfigTypes = cfg.internalConfigTypes();
        if (internalConfigTypes != null) {
            for (int i = 0; i < internalConfigTypes.length; ++i) {
                containers.remove(internalConfigTypes[i]);
            }
        }
        if ((polymorphicInstanceConfigType = cfg.polymorphicInstanceConfigType()) != null) {
            containers.remove(polymorphicInstanceConfigType);
        }
    }
}

