/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.util;

import java.util.Map;
import org.apache.ignite.configuration.ConfigurationProperty;
import org.apache.ignite.configuration.notifications.ConfigurationNotificationEvent;
import org.apache.ignite.internal.configuration.util.ConfigurationContainer;
import org.jetbrains.annotations.Nullable;

class ConfigurationNotificationEventImpl<VIEWT>
implements ConfigurationNotificationEvent<VIEWT> {
    private final VIEWT oldValue;
    private final VIEWT newValue;
    private final long storageRevision;
    private final Map<Class<?>, ConfigurationContainer> configs;

    ConfigurationNotificationEventImpl(VIEWT oldValue, VIEWT newValue, long storageRevision, Map<Class<?>, ConfigurationContainer> configs) {
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.storageRevision = storageRevision;
        this.configs = configs;
    }

    @Nullable
    public VIEWT oldValue() {
        return this.oldValue;
    }

    @Nullable
    public VIEWT newValue() {
        return this.newValue;
    }

    public long storageRevision() {
        return this.storageRevision;
    }

    @Nullable
    public <T extends ConfigurationProperty> T config(Class<?> configClass) {
        ConfigurationContainer container = this.configs.get(configClass);
        return (T)(container == null ? null : container.config);
    }

    @Nullable
    public String name(Class<?> configClass) {
        ConfigurationContainer container = this.configs.get(configClass);
        return container == null ? null : container.keyNamedConfig;
    }
}

