/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.tree;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.ignite.internal.configuration.tree.ConfigurationVisitor;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.apache.ignite.internal.configuration.tree.NamedListNode;

public class ConverterToMapVisitor
implements ConfigurationVisitor<Object> {
    private final boolean includeInternal;
    private final Deque<Object> deque = new ArrayDeque<Object>();

    public ConverterToMapVisitor(boolean includeInternal) {
        this.includeInternal = includeInternal;
    }

    @Override
    public Object visitLeafNode(String key, Serializable val) {
        List<?> valObj = val;
        if (val instanceof Character) {
            valObj = val.toString();
        } else if (val != null && val.getClass().isArray()) {
            valObj = this.toListOfObjects(val);
        }
        this.addToParent(key, valObj);
        return valObj;
    }

    @Override
    public Object visitInnerNode(String key, InnerNode node) {
        HashMap innerMap = new HashMap();
        this.deque.push(innerMap);
        node.traverseChildren(this, this.includeInternal);
        this.deque.pop();
        this.addToParent(key, innerMap);
        return innerMap;
    }

    @Override
    public Object visitNamedListNode(String key, NamedListNode<?> node) {
        ArrayList list = new ArrayList(node.size());
        this.deque.push(list);
        for (String subkey : node.namedListKeys()) {
            node.getInnerNode(subkey).accept(subkey, this);
            ((Map)list.get(list.size() - 1)).put(node.syntheticKeyName(), subkey);
        }
        this.deque.pop();
        this.addToParent(key, list);
        return list;
    }

    private void addToParent(String key, Object val) {
        Object parent = this.deque.peek();
        if (parent instanceof Map) {
            ((Map)parent).put(key, val);
        } else if (parent instanceof List) {
            ((Collection)parent).add(val);
        }
    }

    private List<?> toListOfObjects(Serializable val) {
        Stream<Object> stream = IntStream.range(0, Array.getLength(val)).mapToObj(i -> Array.get(val, i));
        if (val.getClass().getComponentType() == Character.TYPE) {
            stream = stream.map(Object::toString);
        }
        return stream.collect(Collectors.toList());
    }
}

