/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.direct;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.apache.ignite.configuration.ConfigurationProperty;
import org.apache.ignite.configuration.NamedConfigurationTree;
import org.apache.ignite.configuration.NamedListChange;
import org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.configuration.notifications.ConfigurationNamedListListener;
import org.apache.ignite.internal.configuration.DynamicConfigurationChanger;
import org.apache.ignite.internal.configuration.direct.DirectPropertyProxy;
import org.apache.ignite.internal.configuration.direct.KeyPathNode;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;

public class DirectNamedListProxy<T extends ConfigurationProperty<VIEWT>, VIEWT, CHANGET extends VIEWT>
extends DirectPropertyProxy<NamedListView<VIEWT>>
implements NamedConfigurationTree<T, VIEWT, CHANGET> {
    private final BiFunction<List<KeyPathNode>, DynamicConfigurationChanger, T> creator;

    public DirectNamedListProxy(List<KeyPathNode> keys, DynamicConfigurationChanger changer, BiFunction<List<KeyPathNode>, DynamicConfigurationChanger, T> creator) {
        super(keys, changer);
        this.creator = creator;
    }

    public T get(String name) {
        return (T)((ConfigurationProperty)this.creator.apply(ConfigurationUtil.appendKey(this.keys, new KeyPathNode(name, true)), this.changer));
    }

    public T getByInternalId(UUID internalId) {
        return (T)((ConfigurationProperty)this.creator.apply(ConfigurationUtil.appendKey(this.keys, new KeyPathNode(internalId.toString(), false)), this.changer));
    }

    public CompletableFuture<Void> change(Consumer<NamedListChange<VIEWT, CHANGET>> change) {
        throw new UnsupportedOperationException("change");
    }

    public void listenElements(ConfigurationNamedListListener<VIEWT> listener) {
        throw new UnsupportedOperationException("listenElements");
    }

    public void stopListenElements(ConfigurationNamedListListener<VIEWT> listener) {
        throw new UnsupportedOperationException("stopListenElements");
    }

    public T any() {
        throw new UnsupportedOperationException("any");
    }
}

