/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.asm;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.ignite.configuration.ConfigurationValue;
import org.apache.ignite.configuration.NamedConfigurationTree;
import org.apache.ignite.internal.configuration.DynamicConfigurationChanger;
import org.apache.ignite.internal.configuration.asm.ConfigurationAsmGenerator;
import org.apache.ignite.internal.configuration.asm.SchemaClassesInfo;
import org.apache.ignite.internal.configuration.direct.DirectConfigurationProxy;
import org.apache.ignite.internal.configuration.direct.DirectNamedListProxy;
import org.apache.ignite.internal.configuration.direct.DirectValueProxy;
import org.apache.ignite.internal.configuration.direct.KeyPathNode;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.apache.ignite.internal.util.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;

class DirectProxyAsmGenerator {
    private static final Constructor<?> DIRECT_CFG_CTOR;
    private static final Method APPEND_KEY;
    private final ConfigurationAsmGenerator cgen;
    private final Class<?> schemaClass;
    private final Set<Class<?>> internalExtensions;
    private final List<Field> schemaFields;
    private final Collection<Field> internalExtensionsFields;
    @Nullable
    private final Field internalIdField;
    private ClassDefinition classDef;

    DirectProxyAsmGenerator(ConfigurationAsmGenerator cgen, Class<?> schemaClass, Set<Class<?>> internalExtensions, List<Field> schemaFields, Collection<Field> internalExtensionsFields, Field internalIdField) {
        this.cgen = cgen;
        this.schemaClass = schemaClass;
        this.internalExtensions = internalExtensions;
        this.schemaFields = schemaFields;
        this.internalExtensionsFields = internalExtensionsFields;
        this.internalIdField = internalIdField;
    }

    public ClassDefinition generate() {
        assert (this.classDef == null);
        SchemaClassesInfo schemaClassInfo = this.cgen.schemaInfo(this.schemaClass);
        this.classDef = new ClassDefinition(EnumSet.of(Access.PUBLIC, Access.FINAL), ConfigurationAsmGenerator.internalName(schemaClassInfo.directProxyClassName), ParameterizedType.type(DirectConfigurationProxy.class), this.cgen.configClassInterfaces(this.schemaClass, this.internalExtensions));
        this.addConstructor();
        if (this.internalIdField != null) {
            this.addGetMethod(this.internalIdField);
        }
        for (Field schemaField : CollectionUtils.concat((Iterable[])new Iterable[]{this.schemaFields, this.internalExtensionsFields})) {
            this.addGetMethod(schemaField);
        }
        return this.classDef;
    }

    private void addConstructor() {
        MethodDefinition ctor = this.classDef.declareConstructor(EnumSet.of(Access.PUBLIC), new Parameter[]{Parameter.arg((String)"keys", List.class), Parameter.arg((String)"changer", DynamicConfigurationChanger.class)});
        ctor.getBody().append((BytecodeNode)ctor.getThis()).append((BytecodeNode)ctor.getScope().getVariable("keys")).append((BytecodeNode)ctor.getScope().getVariable("changer")).invokeConstructor(DIRECT_CFG_CTOR).ret();
    }

    private void addGetMethod(Field schemaField) {
        ParameterizedType returnType;
        Class<?> schemaFieldType = schemaField.getType();
        String fieldName = schemaField.getName();
        SchemaClassesInfo schemaClassInfo = this.cgen.schemaInfo(schemaFieldType);
        if (ConfigurationUtil.isConfigValue(schemaField)) {
            returnType = ParameterizedType.typeFromJavaClassName((String)schemaClassInfo.cfgClassName);
        } else if (ConfigurationUtil.isNamedConfigValue(schemaField)) {
            returnType = ParameterizedType.type(NamedConfigurationTree.class);
        } else {
            assert (ConfigurationUtil.isValue(schemaField) || ConfigurationUtil.isPolymorphicId(schemaField) || ConfigurationUtil.isInjectedName(schemaField) || ConfigurationUtil.isInternalId(schemaField)) : schemaField;
            returnType = ParameterizedType.type(ConfigurationValue.class);
        }
        MethodDefinition methodDef = this.classDef.declareMethod(EnumSet.of(Access.PUBLIC), fieldName, returnType, new Parameter[0]);
        BytecodeBlock body = methodDef.getBody();
        if (ConfigurationUtil.isValue(schemaField) || ConfigurationUtil.isPolymorphicId(schemaField) || ConfigurationUtil.isInjectedName(schemaField) || ConfigurationUtil.isInternalId(schemaField)) {
            body.append((BytecodeNode)BytecodeExpressions.newInstance(DirectValueProxy.class, (BytecodeExpression[])new BytecodeExpression[]{BytecodeExpressions.invokeStatic((Method)APPEND_KEY, (BytecodeExpression[])new BytecodeExpression[]{methodDef.getThis().getField("keys", List.class), BytecodeExpressions.newInstance(KeyPathNode.class, (BytecodeExpression[])new BytecodeExpression[]{BytecodeExpressions.constantString((String)(ConfigurationUtil.isInjectedName(schemaField) ? "<injected_name>" : (ConfigurationUtil.isInternalId(schemaField) ? "<internal_id>" : fieldName)))})}), methodDef.getThis().getField("changer", DynamicConfigurationChanger.class)}));
        } else {
            SchemaClassesInfo fieldSchemaClassInfo = this.cgen.schemaInfo(schemaField.getType());
            ParameterizedType resultType = ParameterizedType.typeFromJavaClassName((String)fieldSchemaClassInfo.directProxyClassName);
            if (ConfigurationUtil.isConfigValue(schemaField)) {
                body.append((BytecodeNode)BytecodeExpressions.newInstance((ParameterizedType)resultType, (BytecodeExpression[])new BytecodeExpression[]{BytecodeExpressions.invokeStatic((Method)APPEND_KEY, (BytecodeExpression[])new BytecodeExpression[]{methodDef.getThis().getField("keys", List.class), BytecodeExpressions.newInstance(KeyPathNode.class, (BytecodeExpression[])new BytecodeExpression[]{BytecodeExpressions.constantString((String)fieldName)})}), methodDef.getThis().getField("changer", DynamicConfigurationChanger.class)}));
            } else {
                body.append((BytecodeNode)BytecodeExpressions.newInstance(DirectNamedListProxy.class, (BytecodeExpression[])new BytecodeExpression[]{BytecodeExpressions.invokeStatic((Method)APPEND_KEY, (BytecodeExpression[])new BytecodeExpression[]{methodDef.getThis().getField("keys", List.class), BytecodeExpressions.newInstance(KeyPathNode.class, (BytecodeExpression[])new BytecodeExpression[]{BytecodeExpressions.constantString((String)fieldName)})}), methodDef.getThis().getField("changer", DynamicConfigurationChanger.class), DirectProxyAsmGenerator.newDirectProxyLambda(fieldSchemaClassInfo)}));
            }
        }
        body.retObject();
    }

    @NotNull
    public static BytecodeExpression newDirectProxyLambda(SchemaClassesInfo schemaClassInfo) {
        return BytecodeExpressions.invokeDynamic((Method)ConfigurationAsmGenerator.LAMBDA_METAFACTORY, Arrays.asList(Type.getMethodType((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(Object.class), Type.getType(Object.class)}), new Handle(8, ConfigurationAsmGenerator.internalName(schemaClassInfo.directProxyClassName), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(List.class), Type.getType(DynamicConfigurationChanger.class)}), false), Type.getMethodType((Type)ParameterizedType.typeFromJavaClassName((String)schemaClassInfo.directProxyClassName).getAsmType(), (Type[])new Type[]{Type.getType(List.class), Type.getType(DynamicConfigurationChanger.class)})), (String)"apply", (MethodType)MethodType.methodType(BiFunction.class), (BytecodeExpression[])new BytecodeExpression[0]);
    }

    static {
        try {
            DIRECT_CFG_CTOR = DirectConfigurationProxy.class.getDeclaredConstructor(List.class, DynamicConfigurationChanger.class);
            APPEND_KEY = ConfigurationUtil.class.getDeclaredMethod("appendKey", List.class, Object.class);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

