/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiFunction;
import org.apache.ignite.configuration.ConfigurationProperty;
import org.apache.ignite.configuration.NamedConfigurationTree;
import org.apache.ignite.configuration.NamedListChange;
import org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.configuration.RootKey;
import org.apache.ignite.configuration.notifications.ConfigurationNamedListListener;
import org.apache.ignite.internal.configuration.DynamicConfiguration;
import org.apache.ignite.internal.configuration.DynamicConfigurationChanger;
import org.apache.ignite.internal.configuration.direct.DirectNamedListProxy;
import org.apache.ignite.internal.configuration.direct.DirectPropertyProxy;
import org.apache.ignite.internal.configuration.direct.KeyPathNode;
import org.apache.ignite.internal.configuration.tree.NamedListNode;
import org.jetbrains.annotations.Nullable;

public class NamedListConfiguration<T extends ConfigurationProperty<VIEWT>, VIEWT, CHANGET extends VIEWT>
extends DynamicConfiguration<NamedListView<VIEWT>, NamedListChange<VIEWT, CHANGET>>
implements NamedConfigurationTree<T, VIEWT, CHANGET> {
    private final List<ConfigurationNamedListListener<VIEWT>> extendedListeners = new CopyOnWriteArrayList<ConfigurationNamedListListener<VIEWT>>();
    private final BiFunction<List<String>, String, T> cfgCreator;
    private BiFunction<List<KeyPathNode>, DynamicConfigurationChanger, T> directProxyCreator;
    private final T anyConfig;
    private volatile Map<String, T> notificationCache = Collections.emptyMap();

    public NamedListConfiguration(List<String> prefix, String key, RootKey<?, ?> rootKey, DynamicConfigurationChanger changer, boolean listenOnly, BiFunction<List<String>, String, T> cfgCreator, BiFunction<List<KeyPathNode>, DynamicConfigurationChanger, T> directProxyCreator, T anyConfig) {
        super(prefix, key, rootKey, changer, listenOnly);
        this.cfgCreator = cfgCreator;
        this.directProxyCreator = directProxyCreator;
        this.anyConfig = anyConfig;
    }

    @Nullable
    public T get(String name) {
        DynamicConfiguration<?, ?> config = this.getConfig(name);
        return (T)(config == null ? null : config.specificConfigTree());
    }

    @Nullable
    public DynamicConfiguration<?, ?> getConfig(String name) {
        this.refreshValue();
        return (DynamicConfiguration)this.members.get(name);
    }

    public T getByInternalId(UUID internalId) {
        NamedListNode value = (NamedListNode)this.value();
        return (T)((ConfigurationProperty)this.members.get(value.keyByInternalId(internalId)));
    }

    @Override
    protected synchronized void beforeRefreshValue(NamedListView<VIEWT> newValue, @Nullable NamedListView<VIEWT> oldValue) {
        Map oldValues = this.members;
        LinkedHashMap<String, ConfigurationProperty> newValues = new LinkedHashMap<String, ConfigurationProperty>();
        for (String key : newValue.namedListKeys()) {
            ConfigurationProperty oldElement = (ConfigurationProperty)oldValues.get(key);
            if (oldElement != null) {
                newValues.put(key, oldElement);
                continue;
            }
            newValues.put(key, (ConfigurationProperty)this.cfgCreator.apply(this.keys, key));
        }
        this.members = newValues;
    }

    @Override
    public Map<String, ConfigurationProperty<?>> touchMembers() {
        Map<String, T> res = this.notificationCache;
        this.refreshValue();
        this.notificationCache = this.members;
        return Collections.unmodifiableMap(res);
    }

    public List<ConfigurationNamedListListener<VIEWT>> extendedListeners() {
        return Collections.unmodifiableList(this.extendedListeners);
    }

    public void listenElements(ConfigurationNamedListListener<VIEWT> listener) {
        this.extendedListeners.add(listener);
    }

    public void stopListenElements(ConfigurationNamedListListener<VIEWT> listener) {
        this.extendedListeners.remove(listener);
    }

    public T any() {
        return this.anyConfig;
    }

    @Override
    public Class<?> configType() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    @Nullable
    public Class<?>[] internalConfigTypes() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    @Nullable
    public Class<?> polymorphicInstanceConfigType() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public NamedListView<VIEWT> value() {
        return (NamedListView)this.refreshValue();
    }

    @Override
    public DirectPropertyProxy<NamedListView<VIEWT>> directProxy() {
        if (this.listenOnly) {
            throw this.listenOnlyException();
        }
        assert (this.directProxyCreator != null);
        return new DirectNamedListProxy(this.keyPath(), this.changer, this.directProxyCreator);
    }
}

