/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.validation;

import java.util.Arrays;
import org.apache.ignite.configuration.validation.OneOf;
import org.apache.ignite.configuration.validation.ValidationContext;
import org.apache.ignite.configuration.validation.ValidationIssue;
import org.apache.ignite.configuration.validation.Validator;

public class OneOfValidator
implements Validator<OneOf, String> {
    public void validate(OneOf annotation, ValidationContext<String> ctx) {
        String value = (String)ctx.getNewValue();
        boolean caseSensitive = annotation.caseSensitive();
        for (String exp : annotation.value()) {
            if (!(caseSensitive ? exp.equals(value) : exp.equalsIgnoreCase(value))) continue;
            return;
        }
        String message = "'" + ctx.currentKey() + "' configuration value must be one of " + Arrays.toString(annotation.value()) + (caseSensitive ? " (case sensitive)" : " (case insensitive)");
        ctx.addIssue(new ValidationIssue(message));
    }
}

