/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.util;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.configuration.ConfigurationProperty;
import org.apache.ignite.configuration.DirectConfigurationProperty;
import org.apache.ignite.configuration.RootKey;
import org.apache.ignite.configuration.annotation.Config;
import org.apache.ignite.configuration.annotation.ConfigValue;
import org.apache.ignite.configuration.annotation.ConfigurationRoot;
import org.apache.ignite.configuration.annotation.InternalConfiguration;
import org.apache.ignite.configuration.annotation.NamedConfigValue;
import org.apache.ignite.configuration.annotation.Value;
import org.apache.ignite.internal.configuration.storage.ConfigurationStorage;
import org.apache.ignite.internal.configuration.tree.ConfigurationSource;
import org.apache.ignite.internal.configuration.tree.ConfigurationVisitor;
import org.apache.ignite.internal.configuration.tree.ConstructableTreeNode;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.apache.ignite.internal.configuration.tree.NamedListNode;
import org.apache.ignite.internal.configuration.tree.TraversableTreeNode;
import org.apache.ignite.internal.configuration.util.KeyNotFoundException;

public class ConfigurationUtil {
    public static final ConfigurationSource EMPTY_CFG_SRC = new ConfigurationSource(){};

    public static String escape(String key) {
        return key.replaceAll("([.\\\\])", "\\\\$1");
    }

    public static String unescape(String key) {
        return key.replaceAll("\\\\([.\\\\])", "$1");
    }

    public static List<String> split(String keys) {
        String[] split = keys.split("(?<!\\\\)[.]", -1);
        for (int i = 0; i < split.length; ++i) {
            split[i] = ConfigurationUtil.unescape(split[i]);
        }
        return Arrays.asList(split);
    }

    public static String join(List<String> keys) {
        return keys.stream().map(ConfigurationUtil::escape).collect(Collectors.joining("."));
    }

    public static <T> T find(final List<String> keys, TraversableTreeNode node, final boolean includeInternal) throws KeyNotFoundException {
        assert (keys instanceof RandomAccess) : keys.getClass();
        ConfigurationVisitor visitor = new ConfigurationVisitor<T>(){
            private int i;

            @Override
            public T visitLeafNode(String key, Serializable val) {
                if (this.i != keys.size()) {
                    throw new KeyNotFoundException("Configuration value '" + ConfigurationUtil.join(keys.subList(0, this.i)) + "' is a leaf");
                }
                return val;
            }

            @Override
            public T visitInnerNode(String key, InnerNode node) {
                if (this.i == keys.size()) {
                    return node;
                }
                if (node == null) {
                    throw new KeyNotFoundException("Configuration node '" + ConfigurationUtil.join(keys.subList(0, this.i)) + "' is null");
                }
                try {
                    return node.traverseChild((String)keys.get(this.i++), this, includeInternal);
                }
                catch (NoSuchElementException e) {
                    throw new KeyNotFoundException("Configuration value '" + ConfigurationUtil.join(keys.subList(0, this.i)) + "' has not been found");
                }
            }

            @Override
            public T visitNamedListNode(String key, NamedListNode<?> node) {
                if (this.i == keys.size()) {
                    return node;
                }
                String name = (String)keys.get(this.i++);
                return this.visitInnerNode(name, (InnerNode)node.get(name));
            }
        };
        return node.accept(null, visitor);
    }

    public static Map<String, ?> toPrefixMap(Map<String, ? extends Serializable> rawConfig) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        for (Map.Entry<String, ? extends Serializable> entry : rawConfig.entrySet()) {
            List<String> keys = ConfigurationUtil.split(entry.getKey());
            assert (keys instanceof RandomAccess) : keys.getClass();
            ConfigurationUtil.insert(res, keys, 0, entry.getValue());
        }
        return res;
    }

    private static void insert(Map<String, Object> map, List<String> keys, int idx, Serializable val) {
        String key = keys.get(idx);
        if (keys.size() == idx + 1) {
            assert (!map.containsKey(key)) : map.get(key);
            map.put(key, val);
        } else {
            HashMap<String, Object> submap;
            Object node = map.get(key);
            if (node == null) {
                submap = new HashMap();
                map.put(key, submap);
            } else {
                assert (node instanceof Map) : node;
                submap = (Map)node;
            }
            ConfigurationUtil.insert(submap, keys, idx + 1, val);
        }
    }

    public static void fillFromPrefixMap(ConstructableTreeNode node, Map<String, ?> prefixMap) {
        assert (node instanceof InnerNode);
        class InnerConfigurationSource
        implements ConfigurationSource {
            private final Map<String, ?> map;

            private InnerConfigurationSource(Map<String, ?> map) {
                this.map = map;
            }

            @Override
            public <T> T unwrap(Class<T> clazz) {
                throw new UnsupportedOperationException("unwrap");
            }

            @Override
            public void descend(ConstructableTreeNode node) {
                if (node instanceof NamedListNode) {
                    this.descendToNamedListNode((NamedListNode)node);
                    return;
                }
                for (Map.Entry<String, ?> entry : this.map.entrySet()) {
                    String key = entry.getKey();
                    Object val = entry.getValue();
                    assert (val == null || val instanceof Map || val instanceof Serializable);
                    if (key.equals("<order>") || key.equals("<name>")) continue;
                    if (val == null) {
                        node.construct(key, null, true);
                        continue;
                    }
                    if (val instanceof Map) {
                        node.construct(key, new InnerConfigurationSource((Map)val), true);
                        continue;
                    }
                    assert (val instanceof Serializable);
                    class LeafConfigurationSource
                    implements ConfigurationSource {
                        private final Serializable val;

                        private LeafConfigurationSource(Serializable val) {
                            this.val = val;
                        }

                        @Override
                        public <T> T unwrap(Class<T> clazz) {
                            assert (this.val == null || clazz.isInstance(this.val));
                            return clazz.cast(this.val);
                        }

                        @Override
                        public void descend(ConstructableTreeNode node) {
                            throw new UnsupportedOperationException("descend");
                        }
                    }
                    node.construct(key, new LeafConfigurationSource((Serializable)val), true);
                }
            }

            private void descendToNamedListNode(NamedListNode<?> node) {
                ArrayList<String> orderedKeys = new ArrayList<String>(node.namedListKeys());
                for (Map.Entry<String, ?> entry : this.map.entrySet()) {
                    String internalId = entry.getKey();
                    Object val = entry.getValue();
                    assert (val == null || val instanceof Map || val instanceof Serializable);
                    String oldKey = node.keyByInternalId(internalId);
                    if (val == null) {
                        node.forceDelete(oldKey);
                        continue;
                    }
                    if (val instanceof Map) {
                        boolean construct;
                        String newKey;
                        Map map = (Map)val;
                        int sizeDiff = 0;
                        Object idxObj = map.get("<order>");
                        if (idxObj != null) {
                            ++sizeDiff;
                        }
                        if ((newKey = (String)map.get("<name>")) != null) {
                            ++sizeDiff;
                        }
                        boolean bl = construct = map.size() != sizeDiff;
                        if (oldKey == null) {
                            node.construct(newKey, new InnerConfigurationSource(map), true);
                            node.setInternalId(newKey, internalId);
                        } else if (newKey != null) {
                            node.rename(oldKey, newKey);
                            if (construct) {
                                node.construct(newKey, new InnerConfigurationSource(map), true);
                            }
                        } else if (construct) {
                            node.construct(oldKey, new InnerConfigurationSource(map), true);
                        }
                        if (newKey == null) {
                            newKey = oldKey;
                        }
                        if (idxObj == null) continue;
                        assert (idxObj instanceof Integer) : val;
                        int idx = (Integer)idxObj;
                        if (idx >= orderedKeys.size()) {
                            orderedKeys.ensureCapacity(idx + 1);
                            while (idx != orderedKeys.size()) {
                                orderedKeys.add(null);
                            }
                            orderedKeys.add(newKey);
                            continue;
                        }
                        orderedKeys.set(idx, newKey);
                        continue;
                    }
                    assert (val instanceof Serializable);
                    node.construct(oldKey, new LeafConfigurationSource((Serializable)val), true);
                }
                node.reorderKeys(orderedKeys.size() > node.size() ? orderedKeys.subList(0, node.size()) : orderedKeys);
            }
        }
        InnerConfigurationSource src = new InnerConfigurationSource(prefixMap);
        src.descend(node);
    }

    public static List<String> appendKey(List<String> prefix, String key) {
        if (prefix.isEmpty()) {
            return List.of(key);
        }
        ArrayList<String> res = new ArrayList<String>(prefix.size() + 1);
        res.addAll(prefix);
        res.add(key);
        return res;
    }

    public static void addDefaults(final InnerNode node) {
        node.traverseChildren(new ConfigurationVisitor<Object>(){

            @Override
            public Object visitLeafNode(String key, Serializable val) {
                if (val == null) {
                    node.constructDefault(key);
                }
                return null;
            }

            @Override
            public Object visitInnerNode(String key, InnerNode innerNode) {
                InnerNode childNode = node.traverseChild(key, ConfigurationUtil.innerNodeVisitor(), true);
                if (childNode == null) {
                    node.construct(key, EMPTY_CFG_SRC, true);
                    childNode = node.traverseChild(key, ConfigurationUtil.innerNodeVisitor(), true);
                }
                ConfigurationUtil.addDefaults(childNode);
                return null;
            }

            @Override
            public Object visitNamedListNode(String key, NamedListNode<?> namedList) {
                namedList = node.traverseChild(key, ConfigurationUtil.namedListNodeVisitor(), true);
                for (String namedListKey : namedList.namedListKeys()) {
                    if (namedList.get(namedListKey) == null) continue;
                    namedList.construct(namedListKey, EMPTY_CFG_SRC, true);
                    ConfigurationUtil.addDefaults((InnerNode)namedList.get(namedListKey));
                }
                return null;
            }
        }, true);
    }

    public static void dropNulls(InnerNode node) {
        node.traverseChildren(new ConfigurationVisitor<Object>(){

            @Override
            public Object visitInnerNode(String key, InnerNode innerNode) {
                ConfigurationUtil.dropNulls(innerNode);
                return null;
            }

            @Override
            public Object visitNamedListNode(String key, NamedListNode<?> namedList) {
                for (String namedListKey : namedList.namedListKeys()) {
                    Object element = namedList.get(namedListKey);
                    if (element == null) {
                        namedList.forceDelete(namedListKey);
                        continue;
                    }
                    ConfigurationUtil.dropNulls((InnerNode)element);
                }
                return null;
            }
        }, true);
    }

    public static ConfigurationVisitor<Serializable> leafNodeVisitor() {
        return new ConfigurationVisitor<Serializable>(){

            @Override
            public Serializable visitLeafNode(String key, Serializable val) {
                return val;
            }
        };
    }

    public static ConfigurationVisitor<InnerNode> innerNodeVisitor() {
        return new ConfigurationVisitor<InnerNode>(){

            @Override
            public InnerNode visitInnerNode(String key, InnerNode node) {
                return node;
            }
        };
    }

    public static ConfigurationVisitor<NamedListNode<?>> namedListNodeVisitor() {
        return new ConfigurationVisitor<NamedListNode<?>>(){

            @Override
            public NamedListNode<?> visitNamedListNode(String key, NamedListNode<?> node) {
                return node;
            }
        };
    }

    public static void checkConfigurationType(Collection<RootKey<?, ?>> rootKeys, ConfigurationStorage storage) {
        for (RootKey<?, ?> key : rootKeys) {
            if (key.type() == storage.type()) continue;
            throw new IllegalArgumentException("Invalid root key configuration type [key=" + key + ", storage=" + storage.getClass().getName() + ", storageType=" + storage.type() + "]");
        }
    }

    public static Map<Class<?>, Set<Class<?>>> internalSchemaExtensions(Collection<Class<?>> extensions) {
        if (extensions.isEmpty()) {
            return Map.of();
        }
        HashMap res = new HashMap();
        for (Class<?> extension : extensions) {
            if (!extension.isAnnotationPresent(InternalConfiguration.class)) {
                throw new IllegalArgumentException(String.format("Extension should contain @%s: %s", InternalConfiguration.class.getSimpleName(), extension.getName()));
            }
            res.computeIfAbsent(extension.getSuperclass(), cls -> new HashSet()).add(extension);
        }
        return res;
    }

    public static boolean isValue(Field schemaField) {
        return schemaField.isAnnotationPresent(Value.class);
    }

    public static boolean isConfigValue(Field schemaField) {
        return schemaField.isAnnotationPresent(ConfigValue.class);
    }

    public static boolean isNamedConfigValue(Field schemaField) {
        return schemaField.isAnnotationPresent(NamedConfigValue.class);
    }

    public static String syntheticKeyName(Field field) {
        assert (ConfigurationUtil.isNamedConfigValue(field)) : field;
        return field.getAnnotation(NamedConfigValue.class).syntheticKeyName();
    }

    public static boolean hasDefault(Field field) {
        assert (ConfigurationUtil.isValue(field)) : field;
        return field.getAnnotation(Value.class).hasDefault();
    }

    public static Object defaultValue(Field field) {
        assert (ConfigurationUtil.hasDefault(field)) : field;
        try {
            Object o = field.getDeclaringClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            field.setAccessible(true);
            return field.get(o);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static Set<Field> extensionsFields(Collection<Class<?>> extensions) {
        if (extensions.isEmpty()) {
            return Set.of();
        }
        HashMap<String, Field> res = new HashMap<String, Field>();
        for (Class<?> extension : extensions) {
            assert (extension.isAnnotationPresent(InternalConfiguration.class)) : extension;
            for (Field field : extension.getDeclaredFields()) {
                String fieldName = field.getName();
                if (res.containsKey(fieldName)) {
                    throw new IllegalArgumentException(String.format("Duplicate field names are not allowed [field=%s, classes=%s]", field, ConfigurationUtil.classNames((Field)res.get(fieldName), field)));
                }
                res.put(fieldName, field);
            }
        }
        return Set.copyOf(res.values());
    }

    public static Set<Class<?>> collectSchemas(Collection<Class<?>> schemaClasses) {
        if (schemaClasses.isEmpty()) {
            return Set.of();
        }
        HashSet res = new HashSet();
        ArrayDeque queue = new ArrayDeque(Set.copyOf(schemaClasses));
        while (!queue.isEmpty()) {
            Class cls = (Class)queue.poll();
            if (!cls.isAnnotationPresent(ConfigurationRoot.class) && !cls.isAnnotationPresent(Config.class)) {
                throw new IllegalArgumentException(String.format("Configuration schema must contain @%s or @%s: %s", ConfigurationRoot.class.getSimpleName(), Config.class.getSimpleName(), cls.getName()));
            }
            res.add(cls);
            for (Field f : cls.getDeclaredFields()) {
                if (!f.isAnnotationPresent(ConfigValue.class) && !f.isAnnotationPresent(NamedConfigValue.class) || res.contains(f.getType())) continue;
                queue.add(f.getType());
            }
        }
        return res;
    }

    public static List<String> classNames(Field ... fields) {
        return Stream.of(fields).map(Field::getDeclaringClass).map(Class::getName).collect(Collectors.toList());
    }

    public static <T> T directValue(ConfigurationProperty<T> property) {
        return (T)((DirectConfigurationProperty)property).directValue();
    }
}

