/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import org.apache.ignite.configuration.ConfigurationProperty;
import org.apache.ignite.configuration.notifications.ConfigurationListener;
import org.apache.ignite.configuration.notifications.ConfigurationNamedListListener;
import org.apache.ignite.configuration.notifications.ConfigurationNotificationEvent;
import org.apache.ignite.internal.configuration.DynamicConfiguration;
import org.apache.ignite.internal.configuration.DynamicProperty;
import org.apache.ignite.internal.configuration.NamedListConfiguration;
import org.apache.ignite.internal.configuration.tree.ConfigurationVisitor;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.apache.ignite.internal.configuration.tree.NamedListNode;
import org.apache.ignite.internal.configuration.util.ConfigurationContainer;
import org.apache.ignite.internal.configuration.util.ConfigurationNotificationEventImpl;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.apache.ignite.internal.util.CollectionUtils;
import org.jetbrains.annotations.Nullable;

public class ConfigurationNotificationsUtil {
    public static void notifyListeners(@Nullable InnerNode oldInnerNode, InnerNode newInnerNode, DynamicConfiguration<InnerNode, ?> cfgNode, long storageRevision, List<CompletableFuture<?>> futures) {
        ConfigurationNotificationsUtil.notifyListeners(oldInnerNode, newInnerNode, cfgNode, storageRevision, futures, List.of(), new HashMap<Class<? extends ConfigurationProperty>, ConfigurationContainer>());
    }

    private static void notifyListeners(@Nullable InnerNode oldInnerNode, final InnerNode newInnerNode, final DynamicConfiguration<InnerNode, ?> cfgNode, final long storageRevision, final List<CompletableFuture<?>> futures, final Collection<DynamicConfiguration<InnerNode, ?>> anyConfigs, final Map<Class<? extends ConfigurationProperty>, ConfigurationContainer> eventConfigs) {
        assert (!(cfgNode instanceof NamedListConfiguration));
        if (oldInnerNode == null || oldInnerNode == newInnerNode) {
            return;
        }
        eventConfigs.computeIfAbsent(cfgNode.configType(), cls -> new ConfigurationContainer(null, cfgNode));
        for (DynamicConfiguration<InnerNode, ?> anyConfig : anyConfigs) {
            ConfigurationNotificationsUtil.notifyPublicListeners(anyConfig.listeners(), oldInnerNode, newInnerNode, storageRevision, futures, ConfigurationListener::onUpdate, eventConfigs);
        }
        ConfigurationNotificationsUtil.notifyPublicListeners(cfgNode.listeners(), oldInnerNode, newInnerNode, storageRevision, futures, ConfigurationListener::onUpdate, eventConfigs);
        oldInnerNode.traverseChildren(new ConfigurationVisitor<Void>(){

            @Override
            public Void visitLeafNode(String key, Serializable oldLeaf) {
                Serializable newLeaf = newInnerNode.traverseChild(key, ConfigurationUtil.leafNodeVisitor(), true);
                if (newLeaf != oldLeaf) {
                    for (DynamicConfiguration anyConfig : anyConfigs) {
                        ConfigurationNotificationsUtil.notifyPublicListeners(ConfigurationNotificationsUtil.dynamicProperty(anyConfig, key).listeners(), oldLeaf, newLeaf, storageRevision, futures, ConfigurationListener::onUpdate, eventConfigs);
                    }
                    ConfigurationNotificationsUtil.notifyPublicListeners(ConfigurationNotificationsUtil.dynamicProperty(cfgNode, key).listeners(), oldLeaf, newLeaf, storageRevision, futures, ConfigurationListener::onUpdate, eventConfigs);
                }
                return null;
            }

            @Override
            public Void visitInnerNode(String key, InnerNode oldNode) {
                InnerNode newNode = newInnerNode.traverseChild(key, ConfigurationUtil.innerNodeVisitor(), true);
                ConfigurationNotificationsUtil.notifyListeners(oldNode, newNode, ConfigurationNotificationsUtil.dynamicConfig(cfgNode, key), storageRevision, futures, CollectionUtils.viewReadOnly((Collection)anyConfigs, cfg -> ConfigurationNotificationsUtil.dynamicConfig(cfg, key)), eventConfigs);
                return null;
            }

            @Override
            public Void visitNamedListNode(String key, NamedListNode<?> oldNamedList) {
                NamedListNode<?> newNamedList = newInnerNode.traverseChild(key, ConfigurationUtil.namedListNodeVisitor(), true);
                if (newNamedList != oldNamedList) {
                    Object newVal;
                    Object oldVal;
                    for (DynamicConfiguration anyConfig : anyConfigs) {
                        ConfigurationNotificationsUtil.notifyPublicListeners(ConfigurationNotificationsUtil.namedDynamicConfig(anyConfig, key).listeners(), oldNamedList, newNamedList, storageRevision, futures, ConfigurationListener::onUpdate, eventConfigs);
                    }
                    ConfigurationNotificationsUtil.notifyPublicListeners(ConfigurationNotificationsUtil.namedDynamicConfig(cfgNode, key).listeners(), oldNamedList, newNamedList, storageRevision, futures, ConfigurationListener::onUpdate, eventConfigs);
                    List<String> oldNames = oldNamedList.namedListKeys();
                    List<String> newNames = newNamedList.namedListKeys();
                    NamedListConfiguration<?, InnerNode, ?> namedListCfg = ConfigurationNotificationsUtil.namedDynamicConfig(cfgNode, key);
                    Map<String, ConfigurationProperty<?>> namedListCfgMembers = namedListCfg.touchMembers();
                    HashSet<String> created = new HashSet<String>(newNames);
                    created.removeAll(oldNames);
                    HashSet<String> deleted = new HashSet<String>(oldNames);
                    deleted.removeAll(newNames);
                    HashMap<String, String> renamed = new HashMap<String, String>();
                    if (!created.isEmpty() && !deleted.isEmpty()) {
                        HashMap<String, String> createdIds = new HashMap<String, String>();
                        for (String string : created) {
                            createdIds.put(newNamedList.internalId(string), string);
                        }
                        for (String string : Set.copyOf(deleted)) {
                            String internalId = oldNamedList.internalId(string);
                            String maybeRenamedKey = (String)createdIds.get(internalId);
                            if (maybeRenamedKey == null) continue;
                            deleted.remove(string);
                            created.remove(maybeRenamedKey);
                            renamed.put(string, maybeRenamedKey);
                        }
                    }
                    Collection<DynamicConfiguration<InnerNode, ?>> newAnyConfigs = null;
                    for (String string : created) {
                        DynamicConfiguration newNodeCfg = (DynamicConfiguration)namedListCfg.members().get(string);
                        ConfigurationNotificationsUtil.touch(newNodeCfg);
                        eventConfigs.put(newNodeCfg.configType(), new ConfigurationContainer(string, newNodeCfg));
                        Object newVal2 = newNamedList.get(string);
                        for (Object anyConfig : anyConfigs) {
                            ConfigurationNotificationsUtil.notifyPublicListeners(ConfigurationNotificationsUtil.namedDynamicConfig(anyConfig, key).extendedListeners(), null, newVal2, storageRevision, futures, ConfigurationNamedListListener::onCreate, eventConfigs);
                        }
                        ConfigurationNotificationsUtil.notifyPublicListeners(ConfigurationNotificationsUtil.namedDynamicConfig(cfgNode, key).extendedListeners(), null, newVal2, storageRevision, futures, ConfigurationNamedListListener::onCreate, eventConfigs);
                        if (newAnyConfigs == null) {
                            newAnyConfigs = ConfigurationNotificationsUtil.mergeAnyConfigs(CollectionUtils.viewReadOnly((Collection)anyConfigs, cfg -> ConfigurationNotificationsUtil.any(ConfigurationNotificationsUtil.namedDynamicConfig(cfg, key))), ConfigurationNotificationsUtil.any(namedListCfg));
                        }
                        ConfigurationNotificationsUtil.notifyAnyListenersOnCreate((InnerNode)newVal2, newNodeCfg, storageRevision, futures, newAnyConfigs, eventConfigs);
                        eventConfigs.remove(newNodeCfg.configType());
                    }
                    for (String string : deleted) {
                        DynamicConfiguration delNodeCfg = (DynamicConfiguration)namedListCfgMembers.get(string);
                        eventConfigs.put(delNodeCfg.configType(), new ConfigurationContainer(string, null));
                        oldVal = oldNamedList.get(string);
                        for (Object anyConfig : anyConfigs) {
                            ConfigurationNotificationsUtil.notifyPublicListeners(ConfigurationNotificationsUtil.namedDynamicConfig(anyConfig, key).extendedListeners(), oldVal, null, storageRevision, futures, ConfigurationNamedListListener::onDelete, eventConfigs);
                        }
                        ConfigurationNotificationsUtil.notifyPublicListeners(ConfigurationNotificationsUtil.namedDynamicConfig(cfgNode, key).extendedListeners(), oldVal, null, storageRevision, futures, ConfigurationNamedListListener::onDelete, eventConfigs);
                        for (Object anyConfig : anyConfigs) {
                            ConfigurationNotificationsUtil.notifyPublicListeners(ConfigurationNotificationsUtil.any(ConfigurationNotificationsUtil.namedDynamicConfig(anyConfig, key)).listeners(), oldVal, null, storageRevision, futures, ConfigurationListener::onUpdate, eventConfigs);
                        }
                        ConfigurationNotificationsUtil.notifyPublicListeners(delNodeCfg.listeners(), oldVal, null, storageRevision, futures, ConfigurationListener::onUpdate, eventConfigs);
                        eventConfigs.remove(delNodeCfg.configType());
                    }
                    for (Map.Entry entry : renamed.entrySet()) {
                        DynamicConfiguration renNodeCfg = (DynamicConfiguration)namedListCfg.members().get(entry.getValue());
                        eventConfigs.put(renNodeCfg.configType(), new ConfigurationContainer((String)entry.getValue(), renNodeCfg));
                        oldVal = oldNamedList.get((String)entry.getKey());
                        newVal = newNamedList.get((String)entry.getValue());
                        for (DynamicConfiguration anyConfig : anyConfigs) {
                            ConfigurationNotificationsUtil.notifyPublicListeners(ConfigurationNotificationsUtil.namedDynamicConfig(anyConfig, key).extendedListeners(), oldVal, newVal, storageRevision, futures, (listener, evt) -> listener.onRename((String)entry.getKey(), (String)entry.getValue(), evt), eventConfigs);
                        }
                        ConfigurationNotificationsUtil.notifyPublicListeners(ConfigurationNotificationsUtil.namedDynamicConfig(cfgNode, key).extendedListeners(), oldVal, newVal, storageRevision, futures, (listener, evt) -> listener.onRename((String)entry.getKey(), (String)entry.getValue(), evt), eventConfigs);
                        eventConfigs.remove(renNodeCfg.configType());
                    }
                    HashSet<String> updated = new HashSet<String>(newNames);
                    updated.retainAll(oldNames);
                    for (String name : updated) {
                        oldVal = oldNamedList.get(name);
                        if (oldVal == (newVal = newNamedList.get(name))) continue;
                        DynamicConfiguration updNodeCfg = (DynamicConfiguration)namedListCfgMembers.get(name);
                        eventConfigs.put(updNodeCfg.configType(), new ConfigurationContainer(name, updNodeCfg));
                        for (DynamicConfiguration anyConfig : anyConfigs) {
                            ConfigurationNotificationsUtil.notifyPublicListeners(ConfigurationNotificationsUtil.namedDynamicConfig(anyConfig, key).extendedListeners(), oldVal, newVal, storageRevision, futures, ConfigurationListener::onUpdate, eventConfigs);
                        }
                        ConfigurationNotificationsUtil.notifyPublicListeners(ConfigurationNotificationsUtil.namedDynamicConfig(cfgNode, key).extendedListeners(), oldVal, newVal, storageRevision, futures, ConfigurationListener::onUpdate, eventConfigs);
                        if (newAnyConfigs == null) {
                            newAnyConfigs = ConfigurationNotificationsUtil.mergeAnyConfigs(CollectionUtils.viewReadOnly((Collection)anyConfigs, cfg -> ConfigurationNotificationsUtil.any(ConfigurationNotificationsUtil.namedDynamicConfig(cfg, key))), ConfigurationNotificationsUtil.any(namedListCfg));
                        }
                        ConfigurationNotificationsUtil.notifyListeners((InnerNode)oldVal, (InnerNode)newVal, updNodeCfg, storageRevision, futures, newAnyConfigs, eventConfigs);
                    }
                }
                return null;
            }
        }, true);
        eventConfigs.remove(cfgNode.configType());
    }

    private static <V, L extends ConfigurationListener<V>> void notifyPublicListeners(Collection<? extends L> listeners, V oldVal, V newVal, long storageRevision, List<CompletableFuture<?>> futures, BiFunction<L, ConfigurationNotificationEvent<V>, CompletableFuture<?>> updater, Map<Class<? extends ConfigurationProperty>, ConfigurationContainer> configs) {
        if (listeners.isEmpty()) {
            return;
        }
        ConfigurationNotificationEventImpl<V> evt = new ConfigurationNotificationEventImpl<V>(oldVal, newVal, storageRevision, configs);
        for (ConfigurationListener listener : listeners) {
            try {
                CompletableFuture<?> future = updater.apply(listener, evt);
                assert (future != null) : updater;
                if (!future.isCompletedExceptionally() && !future.isCancelled() && future.isDone()) continue;
                futures.add(future);
            }
            catch (Throwable t) {
                futures.add(CompletableFuture.failedFuture(t));
            }
        }
    }

    public static void touch(DynamicConfiguration<?, ?> cfg) {
        cfg.touchMembers();
        for (ConfigurationProperty<?> value : cfg.members().values()) {
            if (!(value instanceof DynamicConfiguration)) continue;
            ConfigurationNotificationsUtil.touch((DynamicConfiguration)value);
        }
    }

    private static void notifyAnyListenersOnCreate(InnerNode innerNode, final DynamicConfiguration<InnerNode, ?> cfgNode, final long storageRevision, final List<CompletableFuture<?>> futures, final Collection<DynamicConfiguration<InnerNode, ?>> anyConfigs, final Map<Class<? extends ConfigurationProperty>, ConfigurationContainer> configs) {
        assert (!(cfgNode instanceof NamedListConfiguration));
        for (DynamicConfiguration<InnerNode, ?> anyConfig : anyConfigs) {
            ConfigurationNotificationsUtil.notifyPublicListeners(anyConfig.listeners(), null, innerNode, storageRevision, futures, ConfigurationListener::onUpdate, configs);
        }
        innerNode.traverseChildren(new ConfigurationVisitor<Void>(){

            @Override
            public Void visitLeafNode(String key, Serializable newLeaf) {
                for (DynamicConfiguration anyConfig : anyConfigs) {
                    ConfigurationNotificationsUtil.notifyPublicListeners(ConfigurationNotificationsUtil.dynamicProperty(anyConfig, key).listeners(), null, newLeaf, storageRevision, futures, ConfigurationListener::onUpdate, configs);
                }
                return null;
            }

            @Override
            public Void visitInnerNode(String key, InnerNode newNode) {
                DynamicConfiguration<InnerNode, ?> innerNodeCfg = ConfigurationNotificationsUtil.dynamicConfig(cfgNode, key);
                configs.put(innerNodeCfg.configType(), new ConfigurationContainer(null, innerNodeCfg));
                ConfigurationNotificationsUtil.notifyAnyListenersOnCreate(newNode, innerNodeCfg, storageRevision, futures, CollectionUtils.viewReadOnly((Collection)anyConfigs, cfg -> ConfigurationNotificationsUtil.dynamicConfig(cfg, key)), configs);
                configs.remove(innerNodeCfg.configType());
                return null;
            }

            @Override
            public Void visitNamedListNode(String key, NamedListNode<?> newNamedList) {
                for (DynamicConfiguration anyConfig : anyConfigs) {
                    ConfigurationNotificationsUtil.notifyPublicListeners(ConfigurationNotificationsUtil.namedDynamicConfig(anyConfig, key).listeners(), null, newNamedList, storageRevision, futures, ConfigurationListener::onUpdate, configs);
                }
                Collection<DynamicConfiguration<InnerNode, ?>> newAnyConfigs = null;
                for (String name : newNamedList.namedListKeys()) {
                    DynamicConfiguration newNodeCfg = (DynamicConfiguration)ConfigurationNotificationsUtil.namedDynamicConfig(cfgNode, key).get(name);
                    configs.put(newNodeCfg.configType(), new ConfigurationContainer(name, newNodeCfg));
                    Object newVal = newNamedList.get(name);
                    for (DynamicConfiguration anyConfig : anyConfigs) {
                        ConfigurationNotificationsUtil.notifyPublicListeners(ConfigurationNotificationsUtil.namedDynamicConfig(anyConfig, key).extendedListeners(), null, newVal, storageRevision, futures, ConfigurationNamedListListener::onCreate, configs);
                    }
                    if (newAnyConfigs == null) {
                        newAnyConfigs = ConfigurationNotificationsUtil.mergeAnyConfigs(CollectionUtils.viewReadOnly((Collection)anyConfigs, cfg -> ConfigurationNotificationsUtil.any(ConfigurationNotificationsUtil.namedDynamicConfig(cfg, key))), ConfigurationNotificationsUtil.any(ConfigurationNotificationsUtil.namedDynamicConfig(cfgNode, key)));
                    }
                    ConfigurationNotificationsUtil.notifyAnyListenersOnCreate((InnerNode)newVal, newNodeCfg, storageRevision, futures, newAnyConfigs, configs);
                    configs.remove(newNodeCfg.configType());
                }
                return null;
            }
        }, true);
    }

    private static Collection<DynamicConfiguration<InnerNode, ?>> mergeAnyConfigs(Collection<DynamicConfiguration<InnerNode, ?>> anyConfigs, DynamicConfiguration<InnerNode, ?> anyConfig) {
        if (anyConfigs.isEmpty()) {
            return List.of(anyConfig);
        }
        ArrayList res = new ArrayList(anyConfigs.size() + 1);
        res.addAll(anyConfigs);
        res.add(anyConfig);
        return res;
    }

    private static DynamicProperty<Serializable> dynamicProperty(DynamicConfiguration<InnerNode, ?> dynamicConfig, String nodeName) {
        return (DynamicProperty)dynamicConfig.members().get(nodeName);
    }

    private static DynamicConfiguration<InnerNode, ?> dynamicConfig(DynamicConfiguration<InnerNode, ?> dynamicConfig, String nodeName) {
        return (DynamicConfiguration)dynamicConfig.members().get(nodeName);
    }

    private static NamedListConfiguration<?, InnerNode, ?> namedDynamicConfig(DynamicConfiguration<InnerNode, ?> dynamicConfig, String nodeName) {
        return (NamedListConfiguration)dynamicConfig.members().get(nodeName);
    }

    private static DynamicConfiguration<InnerNode, ?> any(NamedListConfiguration<?, InnerNode, ?> namedConfig) {
        return (DynamicConfiguration)namedConfig.any();
    }
}

