/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.util;

import java.util.Map;
import org.apache.ignite.configuration.ConfigurationProperty;
import org.apache.ignite.configuration.notifications.ConfigurationNotificationEvent;
import org.apache.ignite.internal.configuration.util.ConfigurationContainer;
import org.jetbrains.annotations.Nullable;

class ConfigurationNotificationEventImpl<VIEW>
implements ConfigurationNotificationEvent<VIEW> {
    private final VIEW oldValue;
    private final VIEW newValue;
    private final long storageRevision;
    private final Map<Class<? extends ConfigurationProperty>, ConfigurationContainer> configs;

    ConfigurationNotificationEventImpl(VIEW oldValue, VIEW newValue, long storageRevision, Map<Class<? extends ConfigurationProperty>, ConfigurationContainer> configs) {
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.storageRevision = storageRevision;
        this.configs = configs;
    }

    @Nullable
    public VIEW oldValue() {
        return this.oldValue;
    }

    @Nullable
    public VIEW newValue() {
        return this.newValue;
    }

    public long storageRevision() {
        return this.storageRevision;
    }

    @Nullable
    public <T extends ConfigurationProperty> T config(Class<? extends ConfigurationProperty> configClass) {
        ConfigurationContainer container = this.configs.get(configClass);
        return (T)(container == null ? null : container.config);
    }

    @Nullable
    public <T extends ConfigurationProperty> String name(Class<? extends ConfigurationProperty> configClass) {
        ConfigurationContainer container = this.configs.get(configClass);
        return container == null ? null : container.keyNamedConfig;
    }
}

