/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.tree;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.ignite.configuration.NamedListChange;
import org.apache.ignite.internal.configuration.tree.ConfigurationSource;
import org.apache.ignite.internal.configuration.tree.ConfigurationVisitor;
import org.apache.ignite.internal.configuration.tree.ConstructableTreeNode;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.apache.ignite.internal.configuration.tree.OrderedMap;
import org.apache.ignite.internal.configuration.tree.TraversableTreeNode;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;

public final class NamedListNode<N extends InnerNode>
implements NamedListChange<N, N>,
TraversableTreeNode,
ConstructableTreeNode {
    public static final String ORDER_IDX = "<order>";
    public static final String NAME = "<name>";
    private final String syntheticKeyName;
    private final Supplier<N> valSupplier;
    private final OrderedMap<ElementDescriptor<N>> map;
    private final Map<String, String> reverseIdMap;

    public NamedListNode(String syntheticKeyName, Supplier<N> valSupplier) {
        this.syntheticKeyName = syntheticKeyName;
        this.valSupplier = valSupplier;
        this.map = new OrderedMap();
        this.reverseIdMap = new HashMap<String, String>();
    }

    private NamedListNode(NamedListNode<N> node) {
        this.syntheticKeyName = node.syntheticKeyName;
        this.valSupplier = node.valSupplier;
        this.map = new OrderedMap();
        this.reverseIdMap = new HashMap<String, String>(node.reverseIdMap);
        for (String key : node.map.keys()) {
            this.map.put(key, node.map.get(key).shallowCopy());
        }
    }

    @Override
    public <T> T accept(String key, ConfigurationVisitor<T> visitor) {
        return visitor.visitNamedListNode(key, this);
    }

    public final List<String> namedListKeys() {
        return Collections.unmodifiableList(this.map.keys());
    }

    public final N get(String key) {
        ElementDescriptor<N> element = this.map.get(key);
        return element == null ? null : (N)element.value;
    }

    public N get(int index) throws IndexOutOfBoundsException {
        ElementDescriptor<N> element = this.map.get(index);
        return element == null ? null : (N)element.value;
    }

    public int size() {
        return this.map.size();
    }

    public NamedListChange<N, N> create(String key, Consumer<N> valConsumer) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(valConsumer, "valConsumer");
        this.checkNewKey(key);
        ElementDescriptor<N> element = this.newElementDescriptor();
        this.map.put(key, element);
        this.reverseIdMap.put(element.internalId, key);
        valConsumer.accept(element.value);
        return this;
    }

    public NamedListChange<N, N> create(int index, String key, Consumer<N> valConsumer) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(valConsumer, "valConsumer");
        if (index < 0 || index > this.map.size()) {
            throw new IndexOutOfBoundsException(index);
        }
        this.checkNewKey(key);
        ElementDescriptor<N> element = this.newElementDescriptor();
        this.map.putByIndex(index, key, element);
        this.reverseIdMap.put(element.internalId, key);
        valConsumer.accept(element.value);
        return this;
    }

    public NamedListChange<N, N> createAfter(String precedingKey, String key, Consumer<N> valConsumer) {
        Objects.requireNonNull(precedingKey, "precedingKey");
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(valConsumer, "valConsumer");
        if (!this.map.containsKey(precedingKey)) {
            throw new IllegalArgumentException("Element with name " + precedingKey + " doesn't exist.");
        }
        this.checkNewKey(key);
        ElementDescriptor<N> element = this.newElementDescriptor();
        this.map.putAfter(precedingKey, key, element);
        this.reverseIdMap.put(element.internalId, key);
        valConsumer.accept(element.value);
        return this;
    }

    public final NamedListChange<N, N> createOrUpdate(String key, Consumer<N> valConsumer) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(valConsumer, "valConsumer");
        if (this.map.containsKey(key) && this.map.get((String)key).value == null) {
            throw new IllegalArgumentException("You can't create entity that has just been deleted [key=" + key + "]");
        }
        ElementDescriptor<N> element = this.map.get(key);
        if (element == null) {
            element = this.newElementDescriptor();
            this.reverseIdMap.put(element.internalId, key);
        } else {
            element = element.copy();
        }
        this.map.put(key, element);
        valConsumer.accept(element.value);
        return this;
    }

    public NamedListChange<N, N> rename(String oldKey, String newKey) {
        Objects.requireNonNull(oldKey, "oldKey");
        Objects.requireNonNull(newKey, "newKey");
        if (!this.map.containsKey(oldKey)) {
            throw new IllegalArgumentException("Element with name " + oldKey + " does not exist.");
        }
        ElementDescriptor<N> element = this.map.get(oldKey);
        if (element.value == null) {
            throw new IllegalArgumentException("Can't rename entity that has just been deleted [key=" + oldKey + "]");
        }
        this.checkNewKey(newKey);
        this.map.rename(oldKey, newKey);
        this.reverseIdMap.put(element.internalId, newKey);
        return this;
    }

    private void checkNewKey(String key) {
        if (this.map.containsKey(key)) {
            if (this.map.get(key) == null) {
                throw new IllegalArgumentException("You can't create entity that has just been deleted [key=" + key + "]");
            }
            throw new IllegalArgumentException("Element with name " + key + " already exists.");
        }
    }

    public NamedListChange<N, N> delete(String key) {
        Objects.requireNonNull(key, "key");
        if (this.map.containsKey(key)) {
            this.map.get((String)key).value = null;
        }
        return this;
    }

    public String syntheticKeyName() {
        return this.syntheticKeyName;
    }

    public void setInternalId(String key, String internalId) {
        ElementDescriptor<N> element = this.map.get(key);
        if (element != null) {
            this.reverseIdMap.remove(element.internalId);
            element.internalId = internalId;
            this.reverseIdMap.put(internalId, key);
        }
    }

    public String internalId(String key) {
        ElementDescriptor<N> element = this.map.get(key);
        if (element == null) {
            throw new IllegalArgumentException("Element with name '" + key + "' does not exist.");
        }
        return element.internalId;
    }

    public String keyByInternalId(String internalId) {
        return this.reverseIdMap.get(internalId);
    }

    public Collection<String> internalIds() {
        return Collections.unmodifiableSet(this.reverseIdMap.keySet());
    }

    public void forceDelete(String key) {
        ElementDescriptor<N> removed = this.map.remove(key);
        if (removed != null) {
            this.reverseIdMap.remove(removed.internalId);
        }
    }

    public void reorderKeys(List<String> orderedKeys) {
        this.map.reorderKeys(orderedKeys);
    }

    @Override
    public void construct(String key, ConfigurationSource src, boolean includeInternal) {
        if (src == null) {
            this.delete(key);
        } else {
            this.createOrUpdate(key, src::descend);
        }
    }

    @Override
    public NamedListNode<N> copy() {
        return new NamedListNode<N>(this);
    }

    private ElementDescriptor<N> newElementDescriptor() {
        InnerNode newElement = (InnerNode)this.valSupplier.get();
        ConfigurationUtil.addDefaults(newElement);
        return new ElementDescriptor<InnerNode>(newElement);
    }

    private static class ElementDescriptor<N extends InnerNode> {
        public String internalId;
        public N value;

        ElementDescriptor(N value) {
            this.value = value;
            this.internalId = UUID.randomUUID().toString().replace("-", "");
        }

        private ElementDescriptor(String internalId, N value) {
            this.internalId = internalId;
            this.value = value;
        }

        public ElementDescriptor<N> copy() {
            return new ElementDescriptor<InnerNode>(this.internalId, ((InnerNode)this.value).copy());
        }

        public ElementDescriptor<N> shallowCopy() {
            return new ElementDescriptor<N>(this.internalId, this.value);
        }
    }
}

