/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.hocon;

import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.ignite.internal.configuration.hocon.HoconListConfigurationSource;
import org.apache.ignite.internal.configuration.hocon.HoconPrimitiveConfigurationSource;
import org.apache.ignite.internal.configuration.tree.ConfigurationSource;
import org.apache.ignite.internal.configuration.tree.ConstructableTreeNode;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.jetbrains.annotations.Nullable;

class HoconObjectConfigurationSource
implements ConfigurationSource {
    private final String ignoredKey;
    private final List<String> path;
    private final ConfigObject hoconCfgObject;

    HoconObjectConfigurationSource(@Nullable String ignoredKey, List<String> path, ConfigObject hoconCfgObject) {
        this.ignoredKey = ignoredKey;
        this.path = path;
        this.hoconCfgObject = hoconCfgObject;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        throw HoconPrimitiveConfigurationSource.wrongTypeException(clazz, this.path, -1);
    }

    @Override
    public void descend(ConstructableTreeNode node) {
        for (Map.Entry entry : this.hoconCfgObject.entrySet()) {
            String key = (String)entry.getKey();
            if (key.equals(this.ignoredKey)) continue;
            ConfigValue hoconCfgValue = (ConfigValue)entry.getValue();
            try {
                switch (hoconCfgValue.valueType()) {
                    case NULL: {
                        node.construct(key, null, false);
                        break;
                    }
                    case OBJECT: {
                        List<String> path = ConfigurationUtil.appendKey(this.path, key);
                        node.construct(key, new HoconObjectConfigurationSource(null, path, (ConfigObject)hoconCfgValue), false);
                        break;
                    }
                    case LIST: {
                        List<String> path = ConfigurationUtil.appendKey(this.path, key);
                        node.construct(key, new HoconListConfigurationSource(path, (ConfigList)hoconCfgValue), false);
                        break;
                    }
                    default: {
                        List<String> path = ConfigurationUtil.appendKey(this.path, key);
                        node.construct(key, new HoconPrimitiveConfigurationSource(path, hoconCfgValue), false);
                        break;
                    }
                }
            }
            catch (NoSuchElementException e) {
                if (this.path.isEmpty()) {
                    throw new IllegalArgumentException(String.format("'%s' configuration root doesn't exist", key), e);
                }
                throw new IllegalArgumentException(String.format("'%s' configuration doesn't have the '%s' sub-configuration", ConfigurationUtil.join(this.path), key), e);
            }
        }
    }
}

