/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.asm;

import org.apache.ignite.configuration.annotation.DirectAccess;
import org.apache.ignite.internal.configuration.DynamicConfiguration;
import org.apache.ignite.internal.configuration.tree.InnerNode;

class SchemaClassesInfo {
    private static final String CONFIGURATION_CLASS_POSTFIX = "Configuration";
    private static final String VIEW_CLASS_POSTFIX = "View";
    private static final String CHANGE_CLASS_POSTFIX = "Change";
    final Class<?> schemaClass;
    final boolean direct;
    final String viewClassName;
    final String changeClassName;
    final String cfgClassName;
    final String nodeClassName;
    final String cfgImplClassName;
    Class<? extends InnerNode> nodeClass;
    Class<? extends DynamicConfiguration<?, ?>> cfgImplClass;

    SchemaClassesInfo(Class<?> schemaClass) {
        this.schemaClass = schemaClass;
        this.direct = schemaClass.isAnnotationPresent(DirectAccess.class);
        String prefix = SchemaClassesInfo.prefix(schemaClass);
        this.viewClassName = prefix + VIEW_CLASS_POSTFIX;
        this.changeClassName = prefix + CHANGE_CLASS_POSTFIX;
        this.cfgClassName = prefix + CONFIGURATION_CLASS_POSTFIX;
        this.nodeClassName = prefix + "Node";
        this.cfgImplClassName = prefix + "ConfigurationImpl";
    }

    private static String prefix(Class<?> schemaClass) {
        String schemaClassName = schemaClass.getPackageName() + "." + schemaClass.getSimpleName();
        return schemaClassName.replaceAll("ConfigurationSchema$", "");
    }

    static String viewClassName(Class<?> schemaClass) {
        return SchemaClassesInfo.prefix(schemaClass) + VIEW_CLASS_POSTFIX;
    }

    static String changeClassName(Class<?> schemaClass) {
        return SchemaClassesInfo.prefix(schemaClass) + CHANGE_CLASS_POSTFIX;
    }

    static String configurationClassName(Class<?> schemaClass) {
        return SchemaClassesInfo.prefix(schemaClass) + CONFIGURATION_CLASS_POSTFIX;
    }
}

