/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.asm;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.ClassGenerator;
import com.facebook.presto.bytecode.FieldDefinition;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.configuration.ConfigurationProperty;
import org.apache.ignite.configuration.ConfigurationValue;
import org.apache.ignite.configuration.DirectConfigurationProperty;
import org.apache.ignite.configuration.NamedConfigurationTree;
import org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.configuration.RootKey;
import org.apache.ignite.configuration.annotation.Config;
import org.apache.ignite.configuration.annotation.ConfigurationRoot;
import org.apache.ignite.configuration.annotation.DirectAccess;
import org.apache.ignite.configuration.annotation.NamedConfigValue;
import org.apache.ignite.configuration.annotation.Value;
import org.apache.ignite.internal.configuration.DirectDynamicConfiguration;
import org.apache.ignite.internal.configuration.DirectDynamicProperty;
import org.apache.ignite.internal.configuration.DirectNamedListConfiguration;
import org.apache.ignite.internal.configuration.DynamicConfiguration;
import org.apache.ignite.internal.configuration.DynamicConfigurationChanger;
import org.apache.ignite.internal.configuration.DynamicProperty;
import org.apache.ignite.internal.configuration.NamedListConfiguration;
import org.apache.ignite.internal.configuration.TypeUtils;
import org.apache.ignite.internal.configuration.asm.SchemaClassesInfo;
import org.apache.ignite.internal.configuration.asm.StringSwitchBuilder;
import org.apache.ignite.internal.configuration.tree.ConfigurationSource;
import org.apache.ignite.internal.configuration.tree.ConfigurationVisitor;
import org.apache.ignite.internal.configuration.tree.ConstructableTreeNode;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.apache.ignite.internal.configuration.tree.NamedListNode;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.apache.ignite.internal.util.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;

public class ConfigurationAsmGenerator {
    private static final Method LAMBDA_METAFACTORY;
    private static final Method ACCEPT;
    private static final Method VISIT_LEAF;
    private static final Method VISIT_INNER;
    private static final Method VISIT_NAMED;
    private static final Method UNWRAP;
    private static final Method DESCEND;
    private static final Method COPY;
    private static final Constructor<?> DYNAMIC_CONFIGURATION_CTOR;
    private static final Constructor<?> DIRECT_DYNAMIC_CONFIGURATION_CTOR;
    private static final Method DYNAMIC_CONFIGURATION_ADD;
    private static final Method REQUIRE_NON_NULL;
    private final Map<Class<?>, SchemaClassesInfo> schemasInfo = new HashMap();
    private final ClassGenerator generator = ClassGenerator.classGenerator((ClassLoader)this.getClass().getClassLoader());

    public synchronized InnerNode instantiateNode(Class<?> schemaClass) {
        SchemaClassesInfo info = this.schemasInfo.get(schemaClass);
        assert (info != null && info.nodeClass != null) : schemaClass;
        try {
            Constructor<? extends InnerNode> constructor = info.nodeClass.getConstructor(new Class[0]);
            assert (constructor.canAccess(null));
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public synchronized DynamicConfiguration<?, ?> instantiateCfg(RootKey<?, ?> rootKey, DynamicConfigurationChanger changer) {
        SchemaClassesInfo info = this.schemasInfo.get(rootKey.schemaClass());
        assert (info != null && info.cfgImplClass != null);
        try {
            Constructor<DynamicConfiguration<?, ?>> constructor = info.cfgImplClass.getConstructor(List.class, String.class, RootKey.class, DynamicConfigurationChanger.class, Boolean.TYPE);
            assert (constructor.canAccess(null));
            return constructor.newInstance(Collections.emptyList(), rootKey.key(), rootKey, changer, false);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public synchronized void compileRootSchema(Class<?> rootSchemaClass, Map<Class<?>, Set<Class<?>>> internalSchemaExtensions) {
        if (this.schemasInfo.containsKey(rootSchemaClass)) {
            return;
        }
        ArrayDeque compileQueue = new ArrayDeque();
        compileQueue.add(rootSchemaClass);
        this.schemasInfo.put(rootSchemaClass, new SchemaClassesInfo(rootSchemaClass));
        HashSet<Class> schemas = new HashSet<Class>();
        ArrayList<ClassDefinition> definitions = new ArrayList<ClassDefinition>();
        while (!compileQueue.isEmpty()) {
            Class schemaClass = (Class)compileQueue.poll();
            assert (schemaClass.isAnnotationPresent(ConfigurationRoot.class) || schemaClass.isAnnotationPresent(Config.class)) : schemaClass + " is not properly annotated";
            assert (this.schemasInfo.containsKey(schemaClass)) : schemaClass;
            Field[] schemaFields = (Field[])Arrays.stream(schemaClass.getDeclaredFields()).filter(field -> ConfigurationUtil.isValue(field) || ConfigurationUtil.isConfigValue(field) || ConfigurationUtil.isNamedConfigValue(field)).toArray(Field[]::new);
            Set<Class<?>> schemaExtensions = internalSchemaExtensions.getOrDefault(schemaClass, Set.of());
            Set<Field> extensionsFields = ConfigurationUtil.extensionsFields(schemaExtensions);
            for (Field schemaField : CollectionUtils.concat((Iterable[])new Iterable[]{Arrays.asList(schemaFields), extensionsFields})) {
                Class<?> subSchemaClass;
                if (!ConfigurationUtil.isConfigValue(schemaField) && !ConfigurationUtil.isNamedConfigValue(schemaField) || this.schemasInfo.containsKey(subSchemaClass = schemaField.getType())) continue;
                compileQueue.offer(subSchemaClass);
                this.schemasInfo.put(subSchemaClass, new SchemaClassesInfo(subSchemaClass));
            }
            schemas.add(schemaClass);
            definitions.add(this.createNodeClass(schemaClass, schemaExtensions, schemaFields, extensionsFields));
            definitions.add(this.createCfgImplClass(schemaClass, schemaExtensions, schemaFields, extensionsFields));
        }
        Map definedClasses = this.generator.defineClasses(definitions);
        for (Class schemaClass : schemas) {
            SchemaClassesInfo info = this.schemasInfo.get(schemaClass);
            info.nodeClass = (Class)definedClasses.get(info.nodeClassName);
            info.cfgImplClass = (Class)definedClasses.get(info.cfgImplClassName);
        }
    }

    private ClassDefinition createNodeClass(Class<?> schemaClass, Set<Class<?>> schemaExtensions, Field[] schemaFields, Set<Field> extensionsFields) {
        SchemaClassesInfo schemaClassInfo = this.schemasInfo.get(schemaClass);
        ClassDefinition classDef = new ClassDefinition(EnumSet.of(Access.PUBLIC, Access.FINAL), ConfigurationAsmGenerator.internalName(schemaClassInfo.nodeClassName), ParameterizedType.type(InnerNode.class), ConfigurationAsmGenerator.nodeClassInterfaces(schemaClass, schemaExtensions));
        HashMap specFields = new HashMap();
        int i = 0;
        for (Class clazz : CollectionUtils.concat((Iterable[])new Iterable[]{List.of(schemaClass), schemaExtensions})) {
            specFields.put(clazz, classDef.declareField(EnumSet.of(Access.PRIVATE, Access.FINAL), "_spec" + i++, clazz));
        }
        ConfigurationAsmGenerator.addNodeSchemaTypeMethod(classDef, (FieldDefinition)specFields.get(schemaClass));
        HashMap<String, FieldDefinition> fieldDefs = new HashMap<String, FieldDefinition>();
        for (Field schemaField : CollectionUtils.concat((Iterable[])new Iterable[]{Arrays.asList(schemaFields), extensionsFields})) {
            assert (ConfigurationUtil.isValue(schemaField) || ConfigurationUtil.isConfigValue(schemaField) || ConfigurationUtil.isNamedConfigValue(schemaField)) : schemaField;
            fieldDefs.put(schemaField.getName(), this.addNodeField(classDef, schemaField));
        }
        this.addNodeConstructor(classDef, specFields, fieldDefs, schemaFields, extensionsFields);
        for (Field schemaField : CollectionUtils.concat((Iterable[])new Iterable[]{Arrays.asList(schemaFields), extensionsFields})) {
            String fieldName = schemaField.getName();
            FieldDefinition fieldDef = (FieldDefinition)fieldDefs.get(fieldName);
            this.addNodeViewMethod(classDef, schemaField, fieldDef);
            MethodDefinition changeMtd = ConfigurationAsmGenerator.addNodeChangeMethod(classDef, schemaField, fieldDef, schemaClassInfo.nodeClassName);
            ConfigurationAsmGenerator.addNodeChangeBridgeMethod(classDef, SchemaClassesInfo.changeClassName(schemaField.getDeclaringClass()), changeMtd);
        }
        ConfigurationAsmGenerator.addNodeTraverseChildrenMethod(classDef, fieldDefs, schemaFields, extensionsFields);
        ConfigurationAsmGenerator.addNodeTraverseChildMethod(classDef, fieldDefs, schemaFields, extensionsFields);
        this.addNodeConstructMethod(classDef, fieldDefs, schemaFields, extensionsFields);
        ConfigurationAsmGenerator.addNodeConstructDefaultMethod(classDef, specFields, fieldDefs, schemaFields, extensionsFields);
        return classDef;
    }

    private static void addNodeSchemaTypeMethod(ClassDefinition classDef, FieldDefinition specField) {
        MethodDefinition schemaTypeMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), "schemaType", ParameterizedType.type(Class.class), new Parameter[0]);
        schemaTypeMtd.getBody().append((BytecodeNode)schemaTypeMtd.getThis().getField(specField).invoke("getClass", Class.class, new BytecodeExpression[0])).retObject();
    }

    private FieldDefinition addNodeField(ClassDefinition classDef, Field schemaField) {
        Class<?> schemaFieldClass = schemaField.getType();
        ParameterizedType nodeFieldType = ConfigurationUtil.isValue(schemaField) ? ParameterizedType.type(ConfigurationAsmGenerator.box(schemaFieldClass)) : (ConfigurationUtil.isConfigValue(schemaField) ? ParameterizedType.typeFromJavaClassName((String)this.schemasInfo.get(schemaFieldClass).nodeClassName) : ParameterizedType.type(NamedListNode.class));
        return classDef.declareField(EnumSet.of(Access.PRIVATE), schemaField.getName(), nodeFieldType);
    }

    private void addNodeConstructor(ClassDefinition classDef, Map<Class<?>, FieldDefinition> specFields, Map<String, FieldDefinition> fieldDefs, Field[] schemaFields, Set<Field> extensionsFields) {
        MethodDefinition ctor = classDef.declareConstructor(EnumSet.of(Access.PUBLIC), new Parameter[0]);
        ctor.getBody().append((BytecodeNode)ctor.getThis()).invokeConstructor(InnerNode.class, new Class[0]);
        for (Map.Entry<Class<?>, FieldDefinition> e : specFields.entrySet()) {
            ctor.getBody().append((BytecodeNode)ctor.getThis().setField(e.getValue(), BytecodeExpressions.newInstance(e.getKey(), (BytecodeExpression[])new BytecodeExpression[0])));
        }
        for (Field schemaField : CollectionUtils.concat((Iterable[])new Iterable[]{Arrays.asList(schemaFields), extensionsFields})) {
            if (!ConfigurationUtil.isNamedConfigValue(schemaField)) continue;
            NamedConfigValue namedCfgAnnotation = schemaField.getAnnotation(NamedConfigValue.class);
            SchemaClassesInfo fieldClassNames = this.schemasInfo.get(schemaField.getType());
            ctor.getBody().append((BytecodeNode)ctor.getThis().setField(fieldDefs.get(schemaField.getName()), BytecodeExpressions.newInstance(NamedListNode.class, (BytecodeExpression[])new BytecodeExpression[]{BytecodeExpressions.constantString((String)namedCfgAnnotation.syntheticKeyName()), ConfigurationAsmGenerator.newNamedListElementLambda(fieldClassNames.nodeClassName)})));
        }
        ctor.getBody().ret();
    }

    private void addNodeViewMethod(ClassDefinition classDef, Field schemaField, FieldDefinition fieldDef) {
        Class<?> schemaFieldType = schemaField.getType();
        ParameterizedType returnType = ConfigurationUtil.isConfigValue(schemaField) ? ParameterizedType.typeFromJavaClassName((String)this.schemasInfo.get(schemaFieldType).viewClassName) : (ConfigurationUtil.isNamedConfigValue(schemaField) ? ParameterizedType.type(NamedListView.class) : ParameterizedType.type(schemaFieldType));
        String fieldName = schemaField.getName();
        MethodDefinition viewMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), fieldName, returnType, new Parameter[0]);
        viewMtd.getBody().append((BytecodeNode)viewMtd.getThis().getField(fieldDef));
        if (schemaFieldType.isPrimitive()) {
            viewMtd.getBody().invokeVirtual(ConfigurationAsmGenerator.box(schemaFieldType), schemaFieldType.getSimpleName() + "Value", schemaFieldType, new Class[0]);
        }
        if (schemaFieldType.isArray()) {
            viewMtd.getBody().invokeVirtual(schemaFieldType, "clone", Object.class, new Class[0]).checkCast(schemaFieldType);
        }
        viewMtd.getBody().ret(schemaFieldType);
    }

    private static MethodDefinition addNodeChangeMethod(ClassDefinition classDef, Field schemaField, FieldDefinition fieldDef, String nodeClassName) {
        Class<?> schemaFieldType = schemaField.getType();
        MethodDefinition changeMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), "change" + ConfigurationAsmGenerator.capitalize(schemaField.getName()), ParameterizedType.typeFromJavaClassName((String)nodeClassName), new Parameter[]{Parameter.arg((String)"change", (ParameterizedType)(ConfigurationUtil.isValue(schemaField) ? ParameterizedType.type(schemaFieldType) : ParameterizedType.type(Consumer.class)))});
        BytecodeBlock changeBody = changeMtd.getBody();
        Variable newValue = changeMtd.getScope().getVariable("change");
        if (!schemaFieldType.isPrimitive()) {
            changeBody.append((BytecodeNode)BytecodeExpressions.invokeStatic((Method)REQUIRE_NON_NULL, (BytecodeExpression[])new BytecodeExpression[]{newValue, BytecodeExpressions.constantString((String)"change")}));
        }
        if (ConfigurationUtil.isValue(schemaField)) {
            if (schemaFieldType.isPrimitive()) {
                newValue = BytecodeExpressions.invokeStatic((ParameterizedType)fieldDef.getType(), (String)"valueOf", (ParameterizedType)fieldDef.getType(), Collections.singleton(newValue));
            }
            if (schemaFieldType.isArray()) {
                newValue = newValue.invoke("clone", Object.class, new BytecodeExpression[0]).cast(schemaFieldType);
            }
            changeBody.append((BytecodeNode)changeMtd.getThis().setField(fieldDef, (BytecodeExpression)newValue));
        } else {
            changeBody.append((BytecodeNode)ConfigurationAsmGenerator.copyNodeField(changeMtd, fieldDef));
            changeBody.append((BytecodeNode)changeMtd.getScope().getVariable("change").invoke(ACCEPT, new BytecodeExpression[]{changeMtd.getThis().getField(fieldDef)}));
        }
        changeBody.append((BytecodeNode)changeMtd.getThis()).retObject();
        return changeMtd;
    }

    private static void addNodeChangeBridgeMethod(ClassDefinition classDef, String changeClassName, MethodDefinition changeMtd) {
        MethodDefinition bridgeMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC, Access.SYNTHETIC, Access.BRIDGE), changeMtd.getName(), ParameterizedType.typeFromJavaClassName((String)changeClassName), (Collection)changeMtd.getParameters());
        Variable changeVar = bridgeMtd.getScope().getVariable("change");
        BytecodeExpression invokeChangeMtd = bridgeMtd.getThis().invoke(changeMtd, List.of(changeVar));
        bridgeMtd.getBody().append((BytecodeNode)invokeChangeMtd).retObject();
    }

    private static void addNodeTraverseChildrenMethod(ClassDefinition classDef, Map<String, FieldDefinition> fieldDefs, Field[] schemaFields, Set<Field> extensionsFields) {
        MethodDefinition traverseChildrenMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), "traverseChildren", ParameterizedType.type(Void.TYPE), new Parameter[]{Parameter.arg((String)"visitor", (ParameterizedType)ParameterizedType.type(ConfigurationVisitor.class)), Parameter.arg((String)"includeInternal", (ParameterizedType)ParameterizedType.type(Boolean.TYPE))}).addException(NoSuchElementException.class);
        BytecodeBlock mtdBody = traverseChildrenMtd.getBody();
        ConfigurationAsmGenerator.invokeVisitForTraverseChildren(Arrays.asList(schemaFields), fieldDefs, traverseChildrenMtd).forEach(arg_0 -> ((BytecodeBlock)mtdBody).append(arg_0));
        if (!extensionsFields.isEmpty()) {
            Variable includeInternalVar = traverseChildrenMtd.getScope().getVariable("includeInternal");
            BytecodeBlock includeInternalBlock = new BytecodeBlock();
            ConfigurationAsmGenerator.invokeVisitForTraverseChildren(extensionsFields, fieldDefs, traverseChildrenMtd).forEach(arg_0 -> ((BytecodeBlock)includeInternalBlock).append(arg_0));
            mtdBody.append((BytecodeNode)new IfStatement().condition((BytecodeNode)includeInternalVar).ifTrue((BytecodeNode)includeInternalBlock));
        }
        mtdBody.ret();
    }

    private static void addNodeTraverseChildMethod(ClassDefinition classDef, Map<String, FieldDefinition> fieldDefs, Field[] schemaFields, Set<Field> extensionsFields) {
        MethodDefinition traverseChildMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), "traverseChild", ParameterizedType.type(Object.class), new Parameter[]{Parameter.arg((String)"key", (ParameterizedType)ParameterizedType.type(String.class)), Parameter.arg((String)"visitor", (ParameterizedType)ParameterizedType.type(ConfigurationVisitor.class)), Parameter.arg((String)"includeInternal", (ParameterizedType)ParameterizedType.type(Boolean.TYPE))}).addException(NoSuchElementException.class);
        BytecodeBlock mtdBody = traverseChildMtd.getBody();
        if (extensionsFields.isEmpty()) {
            mtdBody.append(ConfigurationAsmGenerator.invokeVisitForTraverseChild(Arrays.asList(schemaFields), fieldDefs, traverseChildMtd));
        } else {
            Variable includeInternalVar = traverseChildMtd.getScope().getVariable("includeInternal");
            mtdBody.append((BytecodeNode)new IfStatement().condition((BytecodeNode)includeInternalVar).ifTrue(ConfigurationAsmGenerator.invokeVisitForTraverseChild(CollectionUtils.union(extensionsFields, (Object[])schemaFields), fieldDefs, traverseChildMtd)).ifFalse(ConfigurationAsmGenerator.invokeVisitForTraverseChild(Arrays.asList(schemaFields), fieldDefs, traverseChildMtd)));
        }
    }

    private static BytecodeBlock invokeVisit(MethodDefinition mtd, Field schemaField, FieldDefinition fieldDef) {
        Method visitMethod = ConfigurationUtil.isValue(schemaField) ? VISIT_LEAF : (ConfigurationUtil.isConfigValue(schemaField) ? VISIT_INNER : VISIT_NAMED);
        return new BytecodeBlock().append((BytecodeNode)mtd.getScope().getVariable("visitor").invoke(visitMethod, new BytecodeExpression[]{BytecodeExpressions.constantString((String)fieldDef.getName()), mtd.getThis().getField(fieldDef)}));
    }

    private void addNodeConstructMethod(ClassDefinition classDef, Map<String, FieldDefinition> fieldDefs, Field[] schemaFields, Set<Field> extensionsFields) {
        MethodDefinition constructMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), "construct", ParameterizedType.type(Void.TYPE), new Parameter[]{Parameter.arg((String)"key", (ParameterizedType)ParameterizedType.type(String.class)), Parameter.arg((String)"src", (ParameterizedType)ParameterizedType.type(ConfigurationSource.class)), Parameter.arg((String)"includeInternal", (ParameterizedType)ParameterizedType.type(Boolean.TYPE))}).addException(NoSuchElementException.class);
        BytecodeBlock mtdBody = constructMtd.getBody();
        if (extensionsFields.isEmpty()) {
            mtdBody.append(this.treatSourceForConstruct(Arrays.asList(schemaFields), fieldDefs, constructMtd)).ret();
        } else {
            Variable includeInternalVar = constructMtd.getScope().getVariable("includeInternal");
            mtdBody.append((BytecodeNode)new IfStatement().condition((BytecodeNode)includeInternalVar).ifTrue(this.treatSourceForConstruct(CollectionUtils.union(extensionsFields, (Object[])schemaFields), fieldDefs, constructMtd)).ifFalse(this.treatSourceForConstruct(Arrays.asList(schemaFields), fieldDefs, constructMtd))).ret();
        }
    }

    private static void addNodeConstructDefaultMethod(ClassDefinition classDef, Map<Class<?>, FieldDefinition> specFields, Map<String, FieldDefinition> fieldDefs, Field[] schemaFields, Set<Field> extensionsFields) {
        MethodDefinition constructDfltMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), "constructDefault", ParameterizedType.type(Void.TYPE), new Parameter[]{Parameter.arg((String)"key", String.class)}).addException(NoSuchElementException.class);
        Variable keyVar = constructDfltMtd.getScope().getVariable("key");
        StringSwitchBuilder switchBuilder = new StringSwitchBuilder(constructDfltMtd.getScope()).expression((BytecodeExpression)keyVar);
        for (Field schemaField : CollectionUtils.concat((Iterable[])new Iterable[]{Arrays.asList(schemaFields), extensionsFields})) {
            if (!ConfigurationUtil.isValue(schemaField)) continue;
            if (!schemaField.getAnnotation(Value.class).hasDefault()) {
                switchBuilder.addCase(schemaField.getName(), (BytecodeNode)new BytecodeBlock());
                continue;
            }
            FieldDefinition fieldDef = fieldDefs.get(schemaField.getName());
            Class<?> schemaFieldType = schemaField.getType();
            FieldDefinition specField = specFields.get(schemaField.getDeclaringClass());
            BytecodeExpression defaultValue = constructDfltMtd.getThis().getField(specField).getField(schemaField);
            if (schemaFieldType.isPrimitive()) {
                defaultValue = BytecodeExpressions.invokeStatic((ParameterizedType)fieldDef.getType(), (String)"valueOf", (ParameterizedType)fieldDef.getType(), Collections.singleton(defaultValue));
            }
            if (schemaFieldType.isArray()) {
                defaultValue = defaultValue.invoke("clone", Object.class, new BytecodeExpression[0]).cast(schemaFieldType);
            }
            BytecodeBlock caseClause = new BytecodeBlock().append((BytecodeNode)constructDfltMtd.getThis().setField(fieldDef, defaultValue));
            switchBuilder.addCase(schemaField.getName(), (BytecodeNode)caseClause);
        }
        switchBuilder.defaultCase((BytecodeNode)new BytecodeBlock().append((BytecodeNode)BytecodeExpressions.newInstance(NoSuchElementException.class, (BytecodeExpression[])new BytecodeExpression[]{keyVar})).throwObject());
        constructDfltMtd.getBody().append((BytecodeNode)switchBuilder.build()).ret();
    }

    @NotNull
    private static BytecodeExpression copyNodeField(MethodDefinition mtd, FieldDefinition fieldDef) {
        return mtd.getThis().setField(fieldDef, BytecodeExpressions.inlineIf((BytecodeExpression)BytecodeExpressions.isNull((BytecodeExpression)mtd.getThis().getField(fieldDef)), (BytecodeExpression)BytecodeExpressions.newInstance((ParameterizedType)fieldDef.getType(), (BytecodeExpression[])new BytecodeExpression[0]), (BytecodeExpression)mtd.getThis().getField(fieldDef).invoke(COPY, new BytecodeExpression[0]).cast(fieldDef.getType())));
    }

    @NotNull
    private static BytecodeExpression newNamedListElementLambda(String nodeClassName) {
        return BytecodeExpressions.invokeDynamic((Method)LAMBDA_METAFACTORY, Arrays.asList(Type.getMethodType((Type)Type.getType(Object.class), (Type[])new Type[0]), new Handle(8, ConfigurationAsmGenerator.internalName(nodeClassName), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false), Type.getMethodType((Type)ParameterizedType.typeFromJavaClassName((String)nodeClassName).getAsmType(), (Type[])new Type[0])), (String)"get", (MethodType)MethodType.methodType(Supplier.class), (BytecodeExpression[])new BytecodeExpression[0]);
    }

    private ClassDefinition createCfgImplClass(Class<?> schemaClass, Set<Class<?>> schemaExtensions, Field[] schemaFields, Set<Field> extensionsFields) {
        SchemaClassesInfo schemaClassInfo = this.schemasInfo.get(schemaClass);
        Class superClass = schemaClassInfo.direct ? DirectDynamicConfiguration.class : DynamicConfiguration.class;
        ClassDefinition classDef = new ClassDefinition(EnumSet.of(Access.PUBLIC, Access.FINAL), ConfigurationAsmGenerator.internalName(schemaClassInfo.cfgImplClassName), ParameterizedType.type(superClass), this.configClassInterfaces(schemaClass, schemaExtensions));
        HashMap<String, FieldDefinition> fieldDefs = new HashMap<String, FieldDefinition>();
        for (Field schemaField : CollectionUtils.concat((Iterable[])new Iterable[]{Arrays.asList(schemaFields), extensionsFields})) {
            fieldDefs.put(schemaField.getName(), this.addConfigurationImplField(classDef, schemaField));
        }
        this.addConfigurationImplConstructor(classDef, schemaClassInfo, fieldDefs, schemaFields, extensionsFields);
        for (Field schemaField : CollectionUtils.concat((Iterable[])new Iterable[]{Arrays.asList(schemaFields), extensionsFields})) {
            this.addConfigurationImplGetMethod(classDef, schemaClass, fieldDefs, schemaField);
        }
        this.addCfgImplConfigTypeMethod(classDef, ParameterizedType.typeFromJavaClassName((String)schemaClassInfo.cfgClassName));
        return classDef;
    }

    private FieldDefinition addConfigurationImplField(ClassDefinition classDef, Field schemaField) {
        ParameterizedType fieldType = ConfigurationUtil.isConfigValue(schemaField) ? ParameterizedType.typeFromJavaClassName((String)this.schemasInfo.get(schemaField.getType()).cfgClassName) : (ConfigurationUtil.isNamedConfigValue(schemaField) ? ParameterizedType.type(NamedListConfiguration.class) : ParameterizedType.type(DynamicProperty.class));
        return classDef.declareField(EnumSet.of(Access.PRIVATE), schemaField.getName(), fieldType);
    }

    private void addConfigurationImplConstructor(ClassDefinition classDef, SchemaClassesInfo schemaClassInfo, Map<String, FieldDefinition> fieldDefs, Field[] schemaFields, Set<Field> extensionsFields) {
        MethodDefinition ctor = classDef.declareConstructor(EnumSet.of(Access.PUBLIC), new Parameter[]{Parameter.arg((String)"prefix", List.class), Parameter.arg((String)"key", String.class), Parameter.arg((String)"rootKey", RootKey.class), Parameter.arg((String)"changer", DynamicConfigurationChanger.class), Parameter.arg((String)"listenOnly", Boolean.TYPE)});
        Variable rootKeyVar = ctor.getScope().getVariable("rootKey");
        Variable changerVar = ctor.getScope().getVariable("changer");
        Variable listenOnlyVar = ctor.getScope().getVariable("listenOnly");
        Constructor<?> superCtor = schemaClassInfo.direct ? DIRECT_DYNAMIC_CONFIGURATION_CTOR : DYNAMIC_CONFIGURATION_CTOR;
        BytecodeBlock ctorBody = ctor.getBody().append((BytecodeNode)ctor.getThis()).append((BytecodeNode)ctor.getScope().getVariable("prefix")).append((BytecodeNode)ctor.getScope().getVariable("key")).append((BytecodeNode)rootKeyVar).append((BytecodeNode)changerVar).append((BytecodeNode)listenOnlyVar).invokeConstructor(superCtor);
        BytecodeExpression thisKeysVar = ctor.getThis().getField("keys", List.class);
        int newIdx = 0;
        for (Field schemaField : CollectionUtils.concat((Iterable[])new Iterable[]{Arrays.asList(schemaFields), extensionsFields})) {
            BytecodeExpression newValue;
            FieldDefinition fieldDef = fieldDefs.get(schemaField.getName());
            if (ConfigurationUtil.isValue(schemaField)) {
                Class fieldImplClass = schemaField.isAnnotationPresent(DirectAccess.class) ? DirectDynamicProperty.class : DynamicProperty.class;
                newValue = BytecodeExpressions.newInstance(fieldImplClass, (BytecodeExpression[])new BytecodeExpression[]{thisKeysVar, BytecodeExpressions.constantString((String)schemaField.getName()), rootKeyVar, changerVar, listenOnlyVar});
            } else {
                SchemaClassesInfo fieldInfo = this.schemasInfo.get(schemaField.getType());
                ParameterizedType cfgImplParameterizedType = ParameterizedType.typeFromJavaClassName((String)fieldInfo.cfgImplClassName);
                if (ConfigurationUtil.isConfigValue(schemaField)) {
                    newValue = BytecodeExpressions.newInstance((ParameterizedType)cfgImplParameterizedType, (BytecodeExpression[])new BytecodeExpression[]{thisKeysVar, BytecodeExpressions.constantString((String)schemaField.getName()), rootKeyVar, changerVar, listenOnlyVar});
                } else {
                    MethodDefinition newMtd = classDef.declareMethod(EnumSet.of(Access.PRIVATE, Access.STATIC, Access.SYNTHETIC), "$new$" + newIdx++, ParameterizedType.typeFromJavaClassName((String)fieldInfo.cfgClassName), new Parameter[]{Parameter.arg((String)"rootKey", RootKey.class), Parameter.arg((String)"changer", DynamicConfigurationChanger.class), Parameter.arg((String)"listenOnly", Boolean.TYPE), Parameter.arg((String)"prefix", List.class), Parameter.arg((String)"key", String.class)});
                    Class fieldImplClass = fieldInfo.direct ? DirectNamedListConfiguration.class : NamedListConfiguration.class;
                    newValue = BytecodeExpressions.newInstance(fieldImplClass, (BytecodeExpression[])new BytecodeExpression[]{thisKeysVar, BytecodeExpressions.constantString((String)schemaField.getName()), rootKeyVar, changerVar, listenOnlyVar, BytecodeExpressions.invokeDynamic((Method)LAMBDA_METAFACTORY, Arrays.asList(Type.getMethodType((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(Object.class), Type.getType(Object.class)}), new Handle(6, ConfigurationAsmGenerator.internalName(schemaClassInfo.cfgImplClassName), newMtd.getName(), newMtd.getMethodDescriptor(), false), Type.getMethodType((Type)ParameterizedType.typeFromJavaClassName((String)fieldInfo.cfgClassName).getAsmType(), (Type[])new Type[]{Type.getType(List.class), Type.getType(String.class)})), (String)"apply", BiFunction.class, (BytecodeExpression[])new BytecodeExpression[]{rootKeyVar, changerVar, listenOnlyVar}), BytecodeExpressions.newInstance((ParameterizedType)cfgImplParameterizedType, (BytecodeExpression[])new BytecodeExpression[]{thisKeysVar, BytecodeExpressions.constantString((String)"any"), rootKeyVar, changerVar, BytecodeExpressions.constantBoolean((boolean)true)}).cast(ConfigurationProperty.class)});
                    newMtd.getBody().append((BytecodeNode)BytecodeExpressions.newInstance((ParameterizedType)cfgImplParameterizedType, (BytecodeExpression[])new BytecodeExpression[]{newMtd.getScope().getVariable("prefix"), newMtd.getScope().getVariable("key"), newMtd.getScope().getVariable("rootKey"), newMtd.getScope().getVariable("changer"), newMtd.getScope().getVariable("listenOnly")})).retObject();
                }
            }
            ctorBody.append((BytecodeNode)ctor.getThis().setField(fieldDef, newValue));
            ctorBody.append((BytecodeNode)ctor.getThis().invoke(DYNAMIC_CONFIGURATION_ADD, new BytecodeExpression[]{ctor.getThis().getField(fieldDef)}));
        }
        ctorBody.ret();
    }

    private void addConfigurationImplGetMethod(ClassDefinition classDef, Class<?> schemaClass, Map<String, FieldDefinition> fieldDefs, Field schemaField) {
        ParameterizedType returnType;
        Class<?> schemaFieldType = schemaField.getType();
        String fieldName = schemaField.getName();
        FieldDefinition fieldDef = fieldDefs.get(fieldName);
        if (ConfigurationUtil.isConfigValue(schemaField)) {
            returnType = ParameterizedType.typeFromJavaClassName((String)this.schemasInfo.get(schemaFieldType).cfgClassName);
        } else if (ConfigurationUtil.isNamedConfigValue(schemaField)) {
            returnType = ParameterizedType.type(NamedConfigurationTree.class);
        } else {
            assert (ConfigurationUtil.isValue(schemaField)) : schemaClass;
            returnType = ParameterizedType.type(ConfigurationValue.class);
        }
        MethodDefinition viewMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), fieldName, returnType, new Parameter[0]);
        BytecodeBlock viewBody = viewMtd.getBody();
        viewBody.append((BytecodeNode)viewMtd.getThis()).getField(fieldDef).retObject();
    }

    private static String capitalize(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    @NotNull
    private static String internalName(String className) {
        return className.replace('.', '/');
    }

    private static Class<?> box(Class<?> clazz) {
        Class<?> boxed = TypeUtils.boxed(clazz);
        return boxed == null ? clazz : boxed;
    }

    private static Collection<BytecodeNode> invokeVisitForTraverseChildren(Collection<Field> schemaFields, Map<String, FieldDefinition> fieldDefs, MethodDefinition traverseChildrenMtd) {
        if (schemaFields.isEmpty()) {
            return List.of();
        }
        return schemaFields.stream().map(field -> ConfigurationAsmGenerator.invokeVisit(traverseChildrenMtd, field, (FieldDefinition)fieldDefs.get(field.getName())).pop()).collect(Collectors.toList());
    }

    private static BytecodeNode invokeVisitForTraverseChild(Collection<Field> schemaFields, Map<String, FieldDefinition> fieldDefs, MethodDefinition traverseChildMtd) {
        Variable keyVar = traverseChildMtd.getScope().getVariable("key");
        StringSwitchBuilder switchBuilder = new StringSwitchBuilder(traverseChildMtd.getScope()).expression((BytecodeExpression)keyVar);
        for (Field schemaField : schemaFields) {
            String fieldName = schemaField.getName();
            FieldDefinition fieldDef = fieldDefs.get(fieldName);
            switchBuilder.addCase(fieldName, (BytecodeNode)ConfigurationAsmGenerator.invokeVisit(traverseChildMtd, schemaField, fieldDef).retObject());
        }
        switchBuilder.defaultCase((BytecodeNode)new BytecodeBlock().append((BytecodeNode)BytecodeExpressions.newInstance(NoSuchElementException.class, (BytecodeExpression[])new BytecodeExpression[]{keyVar})).throwObject());
        return switchBuilder.build();
    }

    private BytecodeNode treatSourceForConstruct(Collection<Field> schemaFields, Map<String, FieldDefinition> fieldDefs, MethodDefinition constructMtd) {
        Variable keyVar = constructMtd.getScope().getVariable("key");
        Variable srcVar = constructMtd.getScope().getVariable("src");
        StringSwitchBuilder switchBuilder = new StringSwitchBuilder(constructMtd.getScope()).expression((BytecodeExpression)keyVar);
        for (Field schemaField : schemaFields) {
            FieldDefinition fieldDef = fieldDefs.get(schemaField.getName());
            BytecodeBlock caseClause = new BytecodeBlock();
            switchBuilder.addCase(schemaField.getName(), (BytecodeNode)caseClause);
            if (ConfigurationUtil.isValue(schemaField)) {
                caseClause.append((BytecodeNode)constructMtd.getThis().setField(fieldDef, BytecodeExpressions.inlineIf((BytecodeExpression)BytecodeExpressions.isNull((BytecodeExpression)srcVar), (BytecodeExpression)BytecodeExpressions.constantNull((ParameterizedType)fieldDef.getType()), (BytecodeExpression)srcVar.invoke(UNWRAP, new BytecodeExpression[]{BytecodeExpressions.constantClass((ParameterizedType)fieldDef.getType())}).cast(fieldDef.getType()))));
                continue;
            }
            if (ConfigurationUtil.isConfigValue(schemaField)) {
                caseClause.append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.isNull((BytecodeExpression)srcVar)).ifTrue((BytecodeNode)constructMtd.getThis().setField(fieldDef, BytecodeExpressions.constantNull((ParameterizedType)fieldDef.getType()))).ifFalse((BytecodeNode)new BytecodeBlock().append((BytecodeNode)ConfigurationAsmGenerator.copyNodeField(constructMtd, fieldDef)).append((BytecodeNode)srcVar.invoke(DESCEND, new BytecodeExpression[]{constructMtd.getThis().getField(fieldDef)}))));
                continue;
            }
            NamedConfigValue namedCfgAnnotation = schemaField.getAnnotation(NamedConfigValue.class);
            String fieldNodeClassName = this.schemasInfo.get(schemaField.getType()).nodeClassName;
            caseClause.append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.isNull((BytecodeExpression)srcVar)).ifTrue((BytecodeNode)constructMtd.getThis().setField(fieldDef, BytecodeExpressions.newInstance(NamedListNode.class, (BytecodeExpression[])new BytecodeExpression[]{BytecodeExpressions.constantString((String)namedCfgAnnotation.syntheticKeyName()), ConfigurationAsmGenerator.newNamedListElementLambda(fieldNodeClassName)}))).ifFalse((BytecodeNode)new BytecodeBlock().append((BytecodeNode)constructMtd.getThis().setField(fieldDef, constructMtd.getThis().getField(fieldDef).invoke(COPY, new BytecodeExpression[0]).cast(fieldDef.getType()))).append((BytecodeNode)srcVar.invoke(DESCEND, new BytecodeExpression[]{constructMtd.getThis().getField(fieldDef)}))));
        }
        switchBuilder.defaultCase((BytecodeNode)new BytecodeBlock().append((BytecodeNode)BytecodeExpressions.newInstance(NoSuchElementException.class, (BytecodeExpression[])new BytecodeExpression[]{keyVar})).throwObject());
        return switchBuilder.build();
    }

    private static ParameterizedType[] nodeClassInterfaces(Class<?> schemaClass, Set<Class<?>> schemaExtensions) {
        return (ParameterizedType[])Stream.concat(Stream.of(schemaClass), schemaExtensions.stream()).flatMap(cls -> Stream.of(SchemaClassesInfo.viewClassName(cls), SchemaClassesInfo.changeClassName(cls))).map(ParameterizedType::typeFromJavaClassName).toArray(ParameterizedType[]::new);
    }

    private ParameterizedType[] configClassInterfaces(Class<?> schemaClass, Set<Class<?>> schemaExtensions) {
        ArrayList<ParameterizedType> result = new ArrayList<ParameterizedType>();
        Stream.concat(Stream.of(schemaClass), schemaExtensions.stream()).map(cls -> ParameterizedType.typeFromJavaClassName((String)SchemaClassesInfo.configurationClassName(cls))).forEach(result::add);
        if (this.schemasInfo.get(schemaClass).direct) {
            result.add(ParameterizedType.type(DirectConfigurationProperty.class));
        }
        return result.toArray(new ParameterizedType[0]);
    }

    private void addCfgImplConfigTypeMethod(ClassDefinition classDef, ParameterizedType clazz) {
        classDef.declareMethod(EnumSet.of(Access.PUBLIC), "configType", ParameterizedType.type(Class.class), new Parameter[0]).getBody().append((BytecodeNode)BytecodeExpressions.constantClass((ParameterizedType)clazz)).retObject();
    }

    static {
        try {
            LAMBDA_METAFACTORY = LambdaMetafactory.class.getDeclaredMethod("metafactory", MethodHandles.Lookup.class, String.class, MethodType.class, MethodType.class, MethodHandle.class, MethodType.class);
            ACCEPT = Consumer.class.getDeclaredMethod("accept", Object.class);
            VISIT_LEAF = ConfigurationVisitor.class.getDeclaredMethod("visitLeafNode", String.class, Serializable.class);
            VISIT_INNER = ConfigurationVisitor.class.getDeclaredMethod("visitInnerNode", String.class, InnerNode.class);
            VISIT_NAMED = ConfigurationVisitor.class.getDeclaredMethod("visitNamedListNode", String.class, NamedListNode.class);
            UNWRAP = ConfigurationSource.class.getDeclaredMethod("unwrap", Class.class);
            DESCEND = ConfigurationSource.class.getDeclaredMethod("descend", ConstructableTreeNode.class);
            COPY = ConstructableTreeNode.class.getDeclaredMethod("copy", new Class[0]);
            DYNAMIC_CONFIGURATION_CTOR = DynamicConfiguration.class.getDeclaredConstructor(List.class, String.class, RootKey.class, DynamicConfigurationChanger.class, Boolean.TYPE);
            DIRECT_DYNAMIC_CONFIGURATION_CTOR = DirectDynamicConfiguration.class.getDeclaredConstructor(List.class, String.class, RootKey.class, DynamicConfigurationChanger.class, Boolean.TYPE);
            DYNAMIC_CONFIGURATION_ADD = DynamicConfiguration.class.getDeclaredMethod("add", ConfigurationProperty.class);
            REQUIRE_NON_NULL = Objects.class.getDeclaredMethod("requireNonNull", Object.class, String.class);
        }
        catch (NoSuchMethodException nsme) {
            throw new ExceptionInInitializerError(nsme);
        }
    }
}

