/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiFunction;
import org.apache.ignite.configuration.ConfigurationProperty;
import org.apache.ignite.configuration.NamedConfigurationTree;
import org.apache.ignite.configuration.NamedListChange;
import org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.configuration.RootKey;
import org.apache.ignite.configuration.notifications.ConfigurationNamedListListener;
import org.apache.ignite.internal.configuration.DynamicConfiguration;
import org.apache.ignite.internal.configuration.DynamicConfigurationChanger;

public class NamedListConfiguration<T extends ConfigurationProperty<VIEW>, VIEW, CHANGE extends VIEW>
extends DynamicConfiguration<NamedListView<VIEW>, NamedListChange<VIEW, CHANGE>>
implements NamedConfigurationTree<T, VIEW, CHANGE> {
    private final List<ConfigurationNamedListListener<VIEW>> extendedListeners = new CopyOnWriteArrayList<ConfigurationNamedListListener<VIEW>>();
    private final BiFunction<List<String>, String, T> creator;
    private final T anyConfig;
    private volatile Map<String, T> notificationCache = Collections.emptyMap();

    public NamedListConfiguration(List<String> prefix, String key, RootKey<?, ?> rootKey, DynamicConfigurationChanger changer, boolean listenOnly, BiFunction<List<String>, String, T> creator, T anyConfig) {
        super(prefix, key, rootKey, changer, listenOnly);
        this.creator = creator;
        this.anyConfig = anyConfig;
    }

    public T get(String name) {
        this.refreshValue();
        return (T)((ConfigurationProperty)this.members.get(name));
    }

    @Override
    protected synchronized void beforeRefreshValue(NamedListView<VIEW> newValue) {
        Map oldValues = this.members;
        LinkedHashMap<String, ConfigurationProperty> newValues = new LinkedHashMap<String, ConfigurationProperty>();
        for (String key : newValue.namedListKeys()) {
            ConfigurationProperty oldElement = (ConfigurationProperty)oldValues.get(key);
            if (oldElement != null) {
                newValues.put(key, oldElement);
                continue;
            }
            newValues.put(key, (ConfigurationProperty)this.creator.apply(this.keys, key));
        }
        this.members = newValues;
    }

    @Override
    public Map<String, ConfigurationProperty<?>> touchMembers() {
        Map<String, T> res = this.notificationCache;
        this.refreshValue();
        this.notificationCache = this.members;
        return Collections.unmodifiableMap(res);
    }

    public List<ConfigurationNamedListListener<VIEW>> extendedListeners() {
        return Collections.unmodifiableList(this.extendedListeners);
    }

    public void listenElements(ConfigurationNamedListListener<VIEW> listener) {
        this.extendedListeners.add(listener);
    }

    public void stopListenElements(ConfigurationNamedListListener<VIEW> listener) {
        this.extendedListeners.remove(listener);
    }

    public T any() {
        return this.anyConfig;
    }

    @Override
    public Class<? extends ConfigurationProperty<NamedListView<VIEW>>> configType() {
        throw new UnsupportedOperationException("Not supported.");
    }
}

