/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.configuration.ConfigurationValue;
import org.apache.ignite.configuration.RootKey;
import org.apache.ignite.internal.configuration.ConfigurationNode;
import org.apache.ignite.internal.configuration.DynamicConfigurationChanger;
import org.apache.ignite.internal.configuration.tree.ConfigurationSource;
import org.apache.ignite.internal.configuration.tree.ConstructableTreeNode;
import org.apache.ignite.internal.tostring.S;

public class DynamicProperty<T extends Serializable>
extends ConfigurationNode<T>
implements ConfigurationValue<T> {
    public DynamicProperty(List<String> prefix, String key, RootKey<?, ?> rootKey, DynamicConfigurationChanger changer, boolean listenOnly) {
        super(prefix, key, rootKey, changer, listenOnly);
    }

    public T value() {
        return (T)((Serializable)this.refreshValue());
    }

    public CompletableFuture<Void> update(T newValue) {
        Objects.requireNonNull(newValue, "Configuration value cannot be null.");
        if (this.listenOnly) {
            throw this.listenOnlyException();
        }
        assert (this.keys instanceof RandomAccess);
        assert (!this.keys.isEmpty());
        ConfigurationSource src = new ConfigurationSource((Serializable)newValue){
            private int level = 0;
            final /* synthetic */ Serializable val$newValue;
            {
                this.val$newValue = serializable;
            }

            @Override
            public void descend(ConstructableTreeNode node) {
                assert (this.level < DynamicProperty.this.keys.size());
                node.construct((String)DynamicProperty.this.keys.get(this.level++), this, true);
            }

            @Override
            public <T> T unwrap(Class<T> clazz) {
                assert (this.level == DynamicProperty.this.keys.size());
                assert (clazz.isInstance(this.val$newValue));
                return clazz.cast(this.val$newValue);
            }

            @Override
            public void reset() {
                this.level = 0;
            }
        };
        return this.changer.change(src);
    }

    public String key() {
        return this.key;
    }

    public String toString() {
        return S.toString(DynamicProperty.class, (Object)this, (String)"key", (Object)this.key, (String)"value", (Object)this.value());
    }
}

