/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.apache.ignite.configuration.ConfigurationProperty;
import org.apache.ignite.configuration.ConfigurationTree;
import org.apache.ignite.configuration.RootKey;
import org.apache.ignite.internal.configuration.ConfigurationNode;
import org.apache.ignite.internal.configuration.DynamicConfigurationChanger;
import org.apache.ignite.internal.configuration.tree.ConfigurationSource;
import org.apache.ignite.internal.configuration.tree.ConstructableTreeNode;

public abstract class DynamicConfiguration<VIEW, CHANGE>
extends ConfigurationNode<VIEW>
implements ConfigurationTree<VIEW, CHANGE> {
    protected volatile Map<String, ConfigurationProperty<?>> members = new LinkedHashMap();

    public DynamicConfiguration(List<String> prefix, String key, RootKey<?, ?> rootKey, DynamicConfigurationChanger changer, boolean listenOnly) {
        super(prefix, key, rootKey, changer, listenOnly);
    }

    protected final <P extends ConfigurationProperty<?>> void add(P member) {
        this.members.put(member.key(), member);
    }

    public final CompletableFuture<Void> change(final Consumer<CHANGE> change) {
        Objects.requireNonNull(change, "Configuration consumer cannot be null.");
        if (this.listenOnly) {
            throw this.listenOnlyException();
        }
        assert (this.keys instanceof RandomAccess);
        ConfigurationSource src = new ConfigurationSource(){
            private int level = 0;

            @Override
            public void descend(ConstructableTreeNode node) {
                if (this.level == DynamicConfiguration.this.keys.size()) {
                    change.accept(node);
                } else {
                    node.construct((String)DynamicConfiguration.this.keys.get(this.level++), this, true);
                }
            }

            @Override
            public void reset() {
                this.level = 0;
            }
        };
        return this.changer.change(src);
    }

    public final String key() {
        return this.key;
    }

    public final VIEW value() {
        return this.refreshValue();
    }

    public Map<String, ConfigurationProperty<?>> members() {
        if (!this.listenOnly) {
            this.refreshValue();
        }
        return Collections.unmodifiableMap(this.members);
    }

    public Map<String, ConfigurationProperty<?>> touchMembers() {
        return this.members();
    }

    public abstract Class<? extends ConfigurationProperty<VIEW>> configType();
}

