/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.ignite.configuration.ConfigurationTree;
import org.apache.ignite.configuration.RootKey;
import org.apache.ignite.configuration.validation.Immutable;
import org.apache.ignite.configuration.validation.Max;
import org.apache.ignite.configuration.validation.Min;
import org.apache.ignite.configuration.validation.OneOf;
import org.apache.ignite.configuration.validation.Validator;
import org.apache.ignite.internal.configuration.ConfigurationChanger;
import org.apache.ignite.internal.configuration.DynamicConfiguration;
import org.apache.ignite.internal.configuration.SuperRoot;
import org.apache.ignite.internal.configuration.asm.ConfigurationAsmGenerator;
import org.apache.ignite.internal.configuration.storage.ConfigurationStorage;
import org.apache.ignite.internal.configuration.tree.ConfigurationSource;
import org.apache.ignite.internal.configuration.tree.ConfigurationVisitor;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.apache.ignite.internal.configuration.tree.TraversableTreeNode;
import org.apache.ignite.internal.configuration.util.ConfigurationNotificationsUtil;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.apache.ignite.internal.configuration.util.KeyNotFoundException;
import org.apache.ignite.internal.configuration.validation.ImmutableValidator;
import org.apache.ignite.internal.configuration.validation.MaxValidator;
import org.apache.ignite.internal.configuration.validation.MinValidator;
import org.apache.ignite.internal.configuration.validation.OneOfValidator;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.lang.IgniteLogger;

public class ConfigurationRegistry
implements IgniteComponent {
    private static final IgniteLogger LOG = IgniteLogger.forClass(ConfigurationRegistry.class);
    private final Map<String, DynamicConfiguration<?, ?>> configs = new HashMap();
    private final Collection<RootKey<?, ?>> rootKeys;
    private final ConfigurationChanger changer;
    private final ConfigurationAsmGenerator cgen = new ConfigurationAsmGenerator();

    public ConfigurationRegistry(Collection<RootKey<?, ?>> rootKeys, Map<Class<? extends Annotation>, Set<Validator<? extends Annotation, ?>>> validators, ConfigurationStorage storage, Collection<Class<?>> internalSchemaExtensions) {
        ConfigurationUtil.checkConfigurationType(rootKeys, storage);
        Set<Class<Class<?>>> allSchemas = ConfigurationUtil.collectSchemas(rootKeys.stream().map(RootKey::schemaClass).collect(Collectors.toSet()));
        Map<Class<?>, Set<Class<?>>> extensions = ConfigurationUtil.internalSchemaExtensions(internalSchemaExtensions);
        if (!allSchemas.containsAll(extensions.keySet())) {
            Set notInAllSchemas = extensions.keySet().stream().filter(Predicate.not(allSchemas::contains)).collect(Collectors.toSet());
            throw new IllegalArgumentException("Internal extensions for which no parent configuration schemes were found: " + notInAllSchemas);
        }
        this.rootKeys = rootKeys;
        HashMap validators0 = new HashMap(validators);
        validators0.computeIfAbsent(Min.class, a -> new HashSet(1)).add(new MinValidator());
        validators0.computeIfAbsent(Max.class, a -> new HashSet(1)).add(new MaxValidator());
        validators0.computeIfAbsent(Immutable.class, a -> new HashSet(1)).add(new ImmutableValidator());
        validators0.computeIfAbsent(OneOf.class, a -> new HashSet(1)).add(new OneOfValidator());
        this.changer = new ConfigurationChanger(this::notificator, rootKeys, validators0, storage){

            @Override
            public InnerNode createRootNode(RootKey<?, ?> rootKey) {
                return ConfigurationRegistry.this.cgen.instantiateNode(rootKey.schemaClass());
            }
        };
        rootKeys.forEach(rootKey -> {
            this.cgen.compileRootSchema(rootKey.schemaClass(), extensions);
            DynamicConfiguration<?, ?> cfg = this.cgen.instantiateCfg((RootKey<?, ?>)rootKey, this.changer);
            this.configs.put(rootKey.key(), cfg);
        });
    }

    public void start() {
        this.changer.start();
    }

    public void stop() {
        this.changer.stop();
    }

    public void initializeDefaults() {
        this.changer.initializeDefaults();
        for (RootKey<?, ?> rootKey : this.rootKeys) {
            DynamicConfiguration<?, ?> dynCfg = this.configs.get(rootKey.key());
            ConfigurationNotificationsUtil.touch(dynCfg);
        }
    }

    public <V, C, T extends ConfigurationTree<V, C>> T getConfiguration(RootKey<T, V> rootKey) {
        return (T)this.configs.get(rootKey.key());
    }

    public <T> T represent(List<String> path, ConfigurationVisitor<T> visitor) throws IllegalArgumentException {
        Object node;
        SuperRoot superRoot = this.changer.superRoot();
        try {
            node = ConfigurationUtil.find(path, superRoot, false);
        }
        catch (KeyNotFoundException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        if (node instanceof TraversableTreeNode) {
            return ((TraversableTreeNode)node).accept(null, visitor);
        }
        assert (node == null || node instanceof Serializable);
        return visitor.visitLeafNode(null, (Serializable)node);
    }

    public CompletableFuture<Void> change(ConfigurationSource changesSrc) {
        return this.changer.change(changesSrc);
    }

    private CompletableFuture<Void> notificator(final SuperRoot oldSuperRoot, SuperRoot newSuperRoot, final long storageRevision) {
        final ArrayList futures = new ArrayList();
        newSuperRoot.traverseChildren(new ConfigurationVisitor<Void>(){

            @Override
            public Void visitInnerNode(String key, InnerNode newRoot) {
                InnerNode oldRoot = oldSuperRoot.traverseChild(key, ConfigurationUtil.innerNodeVisitor(), true);
                DynamicConfiguration<?, ?> cfg = ConfigurationRegistry.this.configs.get(key);
                assert (oldRoot != null && cfg != null) : key;
                if (oldRoot != newRoot) {
                    ConfigurationNotificationsUtil.notifyListeners(oldRoot, newRoot, cfg, storageRevision, futures);
                }
                return null;
            }
        }, true);
        Function<CompletableFuture, CompletableFuture> mapping = fut -> fut.whenComplete((res, throwable) -> {
            if (throwable != null) {
                LOG.error("Failed to notify configuration listener.", throwable);
            }
        });
        CompletableFuture[] resultFutures = (CompletableFuture[])futures.stream().map(mapping).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(resultFutures);
    }
}

