/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.ignite.configuration.ConfigurationListenOnlyException;
import org.apache.ignite.configuration.ConfigurationProperty;
import org.apache.ignite.configuration.RootKey;
import org.apache.ignite.configuration.notifications.ConfigurationListener;
import org.apache.ignite.internal.configuration.DynamicConfigurationChanger;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.apache.ignite.internal.configuration.tree.TraversableTreeNode;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.apache.ignite.internal.configuration.util.KeyNotFoundException;

public abstract class ConfigurationNode<VIEW>
implements ConfigurationProperty<VIEW> {
    private final List<ConfigurationListener<VIEW>> updateListeners = new CopyOnWriteArrayList<ConfigurationListener<VIEW>>();
    protected final List<String> keys;
    protected final String key;
    protected final RootKey<?, ?> rootKey;
    protected final DynamicConfigurationChanger changer;
    protected final boolean listenOnly;
    private volatile TraversableTreeNode cachedRootNode;
    private VIEW val;
    private boolean invalid;

    protected ConfigurationNode(List<String> prefix, String key, RootKey<?, ?> rootKey, DynamicConfigurationChanger changer, boolean listenOnly) {
        this.keys = ConfigurationUtil.appendKey(prefix, key);
        this.key = key;
        this.rootKey = rootKey;
        this.changer = changer;
        this.listenOnly = listenOnly;
        assert (Objects.equals(rootKey.key(), this.keys.get(0)));
    }

    public void listen(ConfigurationListener<VIEW> listener) {
        this.updateListeners.add(listener);
    }

    public void stopListen(ConfigurationListener<VIEW> listener) {
        this.updateListeners.remove(listener);
    }

    public Collection<ConfigurationListener<VIEW>> listeners() {
        return Collections.unmodifiableCollection(this.updateListeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final VIEW refreshValue() throws NoSuchElementException {
        InnerNode newRootNode = this.changer.getRootNode(this.rootKey);
        TraversableTreeNode oldRootNode = this.cachedRootNode;
        if (this.invalid) {
            throw this.noSuchElementException();
        }
        if (this.listenOnly) {
            throw this.listenOnlyException();
        }
        if (oldRootNode == newRootNode) {
            return this.val;
        }
        try {
            Object newVal = ConfigurationUtil.find(this.keys.subList(1, this.keys.size()), newRootNode, true);
            ConfigurationNode configurationNode = this;
            synchronized (configurationNode) {
                if (this.cachedRootNode == oldRootNode) {
                    this.beforeRefreshValue(newVal);
                    this.val = newVal;
                    this.cachedRootNode = newRootNode;
                    return (VIEW)newVal;
                }
                if (this.invalid) {
                    throw this.noSuchElementException();
                }
                return this.val;
            }
        }
        catch (KeyNotFoundException e) {
            ConfigurationNode configurationNode = this;
            synchronized (configurationNode) {
                this.invalid = true;
                this.cachedRootNode = newRootNode;
            }
            throw this.noSuchElementException();
        }
    }

    private NoSuchElementException noSuchElementException() {
        return new NoSuchElementException(ConfigurationUtil.join(this.keys));
    }

    protected void beforeRefreshValue(VIEW newValue) {
    }

    protected ConfigurationListenOnlyException listenOnlyException() {
        throw new ConfigurationListenOnlyException("Adding only listeners mode: " + this.keys);
    }
}

