/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.configuration.ConfigurationChangeException;
import org.apache.ignite.configuration.RootKey;
import org.apache.ignite.configuration.validation.ConfigurationValidationException;
import org.apache.ignite.configuration.validation.ValidationIssue;
import org.apache.ignite.configuration.validation.Validator;
import org.apache.ignite.internal.configuration.DynamicConfigurationChanger;
import org.apache.ignite.internal.configuration.RootInnerNode;
import org.apache.ignite.internal.configuration.SuperRoot;
import org.apache.ignite.internal.configuration.storage.ConfigurationStorage;
import org.apache.ignite.internal.configuration.storage.Data;
import org.apache.ignite.internal.configuration.storage.StorageException;
import org.apache.ignite.internal.configuration.tree.ConfigurationSource;
import org.apache.ignite.internal.configuration.tree.ConfigurationVisitor;
import org.apache.ignite.internal.configuration.tree.ConstructableTreeNode;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.apache.ignite.internal.configuration.tree.NamedListNode;
import org.apache.ignite.internal.configuration.util.ConfigurationFlattener;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.apache.ignite.internal.configuration.util.KeyNotFoundException;
import org.apache.ignite.internal.configuration.validation.MemberKey;
import org.apache.ignite.internal.configuration.validation.ValidationUtil;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.NodeStoppingException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigurationChanger
implements DynamicConfigurationChanger {
    private final ForkJoinPool pool = new ForkJoinPool(2);
    private final Map<MemberKey, Annotation[]> cachedAnnotations = new ConcurrentHashMap<MemberKey, Annotation[]>();
    private final Notificator notificator;
    private final Map<String, RootKey<?, ?>> rootKeys;
    private final Map<Class<? extends Annotation>, Set<Validator<?, ?>>> validators;
    private final ConfigurationStorage storage;
    private volatile StorageRoots storageRoots;

    public ConfigurationChanger(Notificator notificator, Collection<RootKey<?, ?>> rootKeys, Map<Class<? extends Annotation>, Set<Validator<?, ?>>> validators, ConfigurationStorage storage) {
        ConfigurationUtil.checkConfigurationType(rootKeys, storage);
        this.notificator = notificator;
        this.validators = validators;
        this.storage = storage;
        this.rootKeys = rootKeys.stream().collect(Collectors.toMap(RootKey::key, Function.identity()));
    }

    public abstract InnerNode createRootNode(RootKey<?, ?> var1);

    private Function<String, RootInnerNode> rootCreator() {
        return key -> {
            RootKey<?, ?> rootKey = this.rootKeys.get(key);
            return rootKey == null ? null : new RootInnerNode(rootKey, this.createRootNode(rootKey));
        };
    }

    public void start() throws ConfigurationChangeException {
        Data data;
        try {
            data = this.storage.readAll();
        }
        catch (StorageException e) {
            throw new ConfigurationChangeException("Failed to initialize configuration: " + e.getMessage(), (Throwable)e);
        }
        SuperRoot superRoot = new SuperRoot(this.rootCreator());
        Map<String, ?> dataValuesPrefixMap = ConfigurationUtil.toPrefixMap(data.values());
        for (RootKey<?, ?> rootKey : this.rootKeys.values()) {
            Map rootPrefixMap = (Map)dataValuesPrefixMap.get(rootKey.key());
            InnerNode rootNode = this.createRootNode(rootKey);
            if (rootPrefixMap != null) {
                ConfigurationUtil.fillFromPrefixMap(rootNode, rootPrefixMap);
            }
            superRoot.addRoot(rootKey, rootNode);
        }
        ConfigurationUtil.addDefaults(superRoot);
        this.storageRoots = new StorageRoots(superRoot, data.changeId());
        this.storage.registerConfigurationListener(this::updateFromListener);
    }

    public void initializeDefaults() throws ConfigurationValidationException, ConfigurationChangeException {
        try {
            ConfigurationSource defaultsCfgSource = new ConfigurationSource(){

                @Override
                public void descend(ConstructableTreeNode node) {
                    ConfigurationUtil.addDefaults((InnerNode)node);
                }
            };
            this.changeInternally(defaultsCfgSource).get(5L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ConfigurationValidationException) {
                throw (ConfigurationValidationException)cause;
            }
            if (cause instanceof ConfigurationChangeException) {
                throw (ConfigurationChangeException)cause;
            }
            throw new ConfigurationChangeException("Failed to write default configuration values into the storage " + this.storage.getClass(), (Throwable)e);
        }
        catch (InterruptedException | TimeoutException e) {
            throw new ConfigurationChangeException("Failed to initialize configuration storage " + this.storage.getClass(), (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Void> change(ConfigurationSource source) {
        return this.changeInternally(source);
    }

    @Override
    public <T> T getLatest(final List<String> path) {
        assert (!path.isEmpty());
        final ArrayList<String> storagePath = new ArrayList<String>(path.size());
        ConfigurationVisitor<Void> visitor = new ConfigurationVisitor<Void>(){
            private int pathIndex;

            @Override
            @Nullable
            public Void visitLeafNode(String key, Serializable val) {
                assert (((String)path.get(this.pathIndex)).equals(key));
                if (this.pathIndex != path.size() - 1) {
                    throw new NoSuchElementException(ConfigurationUtil.join(path.subList(0, this.pathIndex + 2)));
                }
                storagePath.add(key);
                return null;
            }

            @Override
            @Nullable
            public Void visitInnerNode(String key, InnerNode node) {
                assert (((String)path.get(this.pathIndex)).equals(key));
                storagePath.add(key);
                if (this.pathIndex == path.size() - 1) {
                    return null;
                }
                ++this.pathIndex;
                return node.traverseChild((String)path.get(this.pathIndex), this, true);
            }

            @Override
            @Nullable
            public Void visitNamedListNode(String key, NamedListNode<?> node) {
                assert (((String)path.get(this.pathIndex)).equals(key));
                storagePath.add(key);
                return null;
            }
        };
        this.storageRoots.roots.traverseChild(path.get(0), visitor, true);
        Map<String, ? extends Serializable> storageData = this.storage.readAllLatest(ConfigurationUtil.join(storagePath));
        SuperRoot rootNode = new SuperRoot(this.rootCreator());
        ConfigurationUtil.fillFromPrefixMap(rootNode, ConfigurationUtil.toPrefixMap(storageData));
        if (storageData.isEmpty()) {
            ((InnerNode)rootNode).construct(path.get(0), ConfigurationUtil.EMPTY_CFG_SRC, true);
        }
        ConfigurationUtil.addDefaults(rootNode);
        try {
            Object result = ConfigurationUtil.find(path, rootNode, true);
            if (result == null) {
                throw new NoSuchElementException(ConfigurationUtil.join(path));
            }
            return result;
        }
        catch (KeyNotFoundException e) {
            throw new NoSuchElementException(ConfigurationUtil.join(path));
        }
    }

    public void stop() {
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.pool, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        StorageRoots roots = this.storageRoots;
        if (roots != null) {
            roots.changeFuture.completeExceptionally((Throwable)new NodeStoppingException());
        }
    }

    @Override
    public InnerNode getRootNode(RootKey<?, ?> rootKey) {
        return this.storageRoots.roots.getRoot(rootKey);
    }

    public SuperRoot superRoot() {
        return this.storageRoots.roots;
    }

    private CompletableFuture<Void> changeInternally(ConfigurationSource src) {
        StorageRoots localRoots = this.storageRoots;
        return CompletableFuture.supplyAsync(() -> {
            SuperRoot curRoots = localRoots.roots;
            SuperRoot changes = curRoots.copy();
            src.reset();
            src.descend(changes);
            ConfigurationUtil.addDefaults(changes);
            Map<String, Serializable> allChanges = ConfigurationFlattener.createFlattenedUpdatesMap(curRoots, changes);
            if (allChanges.isEmpty()) {
                return null;
            }
            ConfigurationUtil.dropNulls(changes);
            List<ValidationIssue> validationIssues = ValidationUtil.validate(curRoots, changes, this::getRootNode, this.cachedAnnotations, this.validators);
            if (!validationIssues.isEmpty()) {
                throw new ConfigurationValidationException(validationIssues);
            }
            return allChanges;
        }, this.pool).thenCompose(allChanges -> {
            if (allChanges == null) {
                return CompletableFuture.completedFuture(null);
            }
            return ((CompletableFuture)this.storage.write((Map<String, ? extends Serializable>)allChanges, localRoots.version).thenCompose(casResult -> {
                if (casResult.booleanValue()) {
                    return localRoots.changeFuture;
                }
                return localRoots.changeFuture.thenCompose(v -> this.changeInternally(src));
            })).exceptionally(throwable -> {
                throw new ConfigurationChangeException("Failed to change configuration", throwable);
            });
        });
    }

    private CompletableFuture<Void> updateFromListener(Data changedEntries) {
        StorageRoots oldStorageRoots = this.storageRoots;
        Map<String, ?> dataValuesPrefixMap = ConfigurationUtil.toPrefixMap(changedEntries.values());
        this.compressDeletedEntries(dataValuesPrefixMap);
        SuperRoot oldSuperRoot = oldStorageRoots.roots;
        SuperRoot newSuperRoot = oldSuperRoot.copy();
        ConfigurationUtil.fillFromPrefixMap(newSuperRoot, dataValuesPrefixMap);
        long newChangeId = changedEntries.changeId();
        this.storageRoots = new StorageRoots(newSuperRoot, newChangeId);
        return this.notificator.notify(oldSuperRoot, newSuperRoot, newChangeId).whenComplete((v, t) -> {
            if (t == null) {
                oldStorageRoots.changeFuture.complete(null);
            } else {
                oldStorageRoots.changeFuture.completeExceptionally((Throwable)t);
            }
        });
    }

    private void compressDeletedEntries(Map<String, ?> prefixMap) {
        prefixMap.replaceAll((key, value) -> value instanceof Map && ((Map)value).containsValue(null) ? null : value);
        for (Object value2 : prefixMap.values()) {
            if (!(value2 instanceof Map)) continue;
            this.compressDeletedEntries((Map)value2);
        }
    }

    private static class StorageRoots {
        private final SuperRoot roots;
        private final long version;
        private final CompletableFuture<Void> changeFuture = new CompletableFuture();

        private StorageRoots(SuperRoot roots, long version) {
            this.roots = roots;
            this.version = version;
        }
    }

    @FunctionalInterface
    public static interface Notificator {
        @NotNull
        public CompletableFuture<Void> notify(SuperRoot var1, SuperRoot var2, long var3);
    }
}

