/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.configuration.internal.selector;

import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ignite.configuration.internal.DynamicConfiguration;
import org.apache.ignite.configuration.internal.Modifier;
import org.apache.ignite.configuration.internal.selector.Selector;
import org.apache.ignite.configuration.internal.selector.SelectorNotFoundException;

public class BaseSelectors {
    private static final Map<String, SelectorHolder> selectors = new HashMap<String, SelectorHolder>();

    public static <ROOT extends DynamicConfiguration<?, ?, ?>, TARGET extends Modifier<VIEW, INIT, CHANGE>, VIEW, INIT, CHANGE> Selector<ROOT, TARGET, VIEW, INIT, CHANGE> find(String name) {
        String partialKey;
        SelectorHolder partialSelector;
        int lastDot;
        String[] nameParts = name.split("\\.");
        ArrayList<String> arguments = new ArrayList<String>();
        StringBuilder keyBuilder = new StringBuilder();
        for (int i = 0; i < nameParts.length; ++i) {
            int end;
            String part = nameParts[i];
            int start = part.indexOf(91);
            String methodArg = null;
            if (start != -1 && (end = part.indexOf(93)) != -1) {
                methodArg = part.substring(start + 1, end);
                part = part.substring(0, start);
            }
            if (methodArg != null) {
                arguments.add(methodArg);
            }
            keyBuilder.append(part);
            if (i == nameParts.length - 1) continue;
            keyBuilder.append('.');
        }
        String key = keyBuilder.toString();
        SelectorHolder selector = selectors.get(key);
        if (selector == null && (lastDot = key.lastIndexOf(46)) != -1 && (partialSelector = selectors.get(partialKey = key.substring(0, lastDot))) != null) {
            String availableOptions = selectors.keySet().stream().filter(s -> s.startsWith(partialKey)).collect(Collectors.joining(", "));
            throw new SelectorNotFoundException("Selector " + key + " was not found, available options are: " + availableOptions);
        }
        try {
            return selector.get(arguments);
        }
        catch (Throwable throwable) {
            throw new SelectorNotFoundException("Failed to get selector: " + throwable.getMessage(), throwable);
        }
    }

    public static void put(String key, Selector<?, ?, ?, ?, ?> selector) {
        selectors.put(key, new SelectorHolder(selector));
    }

    public static void put(String key, MethodHandle handle) {
        selectors.put(key, new SelectorHolder(handle));
    }

    private static final class SelectorHolder {
        Selector<?, ?, ?, ?, ?> selector;
        MethodHandle selectorFn;

        public SelectorHolder(Selector<?, ?, ?, ?, ?> selector) {
            this.selector = selector;
        }

        public SelectorHolder(MethodHandle selectorFn) {
            this.selectorFn = selectorFn;
        }

        Selector<?, ?, ?, ?, ?> get(List<String> arguments) throws Throwable {
            if (this.selector != null) {
                return this.selector;
            }
            return (Selector)this.selectorFn.invokeWithArguments(arguments);
        }
    }
}

