/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.configuration.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.ignite.configuration.Configurator;
import org.apache.ignite.configuration.internal.DynamicConfiguration;
import org.apache.ignite.configuration.internal.Modifier;
import org.apache.ignite.configuration.internal.NamedList;

public class NamedListConfiguration<VIEW, T extends Modifier<VIEW, INIT, CHANGE>, INIT, CHANGE>
extends DynamicConfiguration<NamedList<VIEW>, NamedList<INIT>, NamedList<CHANGE>> {
    private final BiFunction<String, String, T> creator;
    private final Map<String, T> values = new HashMap<String, T>();

    public NamedListConfiguration(String prefix, String key, Configurator<? extends DynamicConfiguration<?, ?, ?>> configurator, DynamicConfiguration<?, ?, ?> root, BiFunction<String, String, T> creator) {
        super(prefix, key, false, configurator, root);
        this.creator = creator;
    }

    private NamedListConfiguration(NamedListConfiguration<VIEW, T, INIT, CHANGE> base, Configurator<? extends DynamicConfiguration<?, ?, ?>> configurator, DynamicConfiguration<?, ?, ?> root) {
        super(base.prefix, base.key, false, configurator, root);
        this.creator = base.creator;
        for (Map.Entry<String, T> entry : base.values.entrySet()) {
            String k = entry.getKey();
            Modifier value = (Modifier)entry.getValue();
            DynamicConfiguration copy = ((DynamicConfiguration)value).copy(root);
            this.add(copy);
            this.values.put(k, copy);
        }
    }

    @Override
    public void init(NamedList<INIT> list) {
        list.getValues().forEach((key, init) -> {
            if (!this.values.containsKey(key)) {
                Modifier created = (Modifier)this.creator.apply(this.qualifiedName, (String)key);
                this.add(created);
                this.values.put((String)key, (T)created);
            }
            ((Modifier)this.values.get(key)).init(init);
        });
    }

    public T get(String name) {
        return (T)((Modifier)this.values.get(name));
    }

    @Override
    public NamedList<VIEW> value() {
        return new NamedList<Object>(this.values.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, it -> ((Modifier)it.getValue()).value())));
    }

    @Override
    public void changeWithoutValidation(NamedList<CHANGE> list) {
        list.getValues().forEach((key, change) -> {
            if (!this.values.containsKey(key)) {
                Modifier created = (Modifier)this.creator.apply(this.qualifiedName, (String)key);
                this.add(created);
                this.values.put((String)key, (T)created);
            }
            ((Modifier)this.values.get(key)).changeWithoutValidation(change);
        });
    }

    public NamedListConfiguration<VIEW, T, INIT, CHANGE> copy(DynamicConfiguration<?, ?, ?> root) {
        return new NamedListConfiguration<VIEW, T, INIT, CHANGE>(this, this.configurator, root);
    }
}

