/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.configuration.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.configuration.ConfigurationValue;
import org.apache.ignite.configuration.Configurator;
import org.apache.ignite.configuration.PropertyListener;
import org.apache.ignite.configuration.internal.DynamicConfiguration;
import org.apache.ignite.configuration.internal.Modifier;
import org.apache.ignite.configuration.internal.selector.BaseSelectors;
import org.apache.ignite.configuration.internal.validation.MemberKey;
import org.apache.ignite.configuration.validation.ConfigurationValidationException;
import org.apache.ignite.configuration.validation.FieldValidator;

public class DynamicProperty<T extends Serializable>
implements Modifier<T, T, T>,
ConfigurationValue<T> {
    private final String name;
    private final MemberKey memberKey;
    private final String qualifiedName;
    protected volatile T val;
    private final List<PropertyListener<T, T>> updateListeners = new ArrayList<PropertyListener<T, T>>();
    protected final Configurator<? extends DynamicConfiguration<?, ?, ?>> configurator;
    protected final DynamicConfiguration<?, ?, ?> root;

    public DynamicProperty(String prefix, String name, MemberKey memberKey, Configurator<? extends DynamicConfiguration<?, ?, ?>> configurator, DynamicConfiguration<?, ?, ?> root) {
        this(prefix, name, memberKey, null, configurator, root);
    }

    public DynamicProperty(String prefix, String name, MemberKey memberKey, T defaultValue, Configurator<? extends DynamicConfiguration<?, ?, ?>> configurator, DynamicConfiguration<?, ?, ?> root) {
        this(defaultValue, name, memberKey, String.format("%s.%s", prefix, name), configurator, root, false);
    }

    private DynamicProperty(DynamicProperty<T> base, DynamicConfiguration<?, ?, ?> root) {
        this(base.val, base.name, base.memberKey, base.qualifiedName, base.configurator, root, true);
    }

    private DynamicProperty(T value, String name, MemberKey memberKey, String qualifiedName, Configurator<? extends DynamicConfiguration<?, ?, ?>> configurator, DynamicConfiguration<?, ?, ?> root, boolean isCopy) {
        this.name = name;
        this.memberKey = memberKey;
        this.qualifiedName = qualifiedName;
        this.val = value;
        this.configurator = configurator;
        this.root = root;
        if (isCopy) {
            configurator.onAttached(this);
        }
    }

    public void addListener(PropertyListener<T, T> listener) {
        this.updateListeners.add(listener);
    }

    @Override
    public T value() {
        return this.val;
    }

    @Override
    public void change(T object) throws ConfigurationValidationException {
        this.configurator.set(BaseSelectors.find(this.qualifiedName), object);
    }

    @Override
    public void init(T object) throws ConfigurationValidationException {
        this.val = object;
    }

    @Override
    public void changeWithoutValidation(T object) {
        this.val = object;
        for (PropertyListener<T, T> listener : this.updateListeners) {
            listener.update(object, this);
        }
    }

    @Override
    public void validate(DynamicConfiguration<?, ?, ?> oldRoot) throws ConfigurationValidationException {
        List<FieldValidator<Serializable, DynamicConfiguration<?, ?, ?>>> validators = this.configurator.validators(this.memberKey);
        for (FieldValidator<Serializable, DynamicConfiguration<?, ?, ?>> validator : validators) {
            validator.validate((Serializable)this.val, this.root, oldRoot);
        }
    }

    @Override
    public String key() {
        return this.name;
    }

    public String qualifiedName() {
        return this.qualifiedName;
    }

    public void setSilently(T serializable) {
        this.val = serializable;
        for (PropertyListener<T, T> listener : this.updateListeners) {
            listener.update(this.val, this);
        }
    }

    public DynamicProperty<T> copy(DynamicConfiguration<?, ?, ?> newRoot) {
        return new DynamicProperty<T>(this, newRoot);
    }
}

