/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.configuration.internal;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ignite.configuration.ConfigurationProperty;
import org.apache.ignite.configuration.ConfigurationTree;
import org.apache.ignite.configuration.Configurator;
import org.apache.ignite.configuration.internal.DynamicProperty;
import org.apache.ignite.configuration.internal.Modifier;
import org.apache.ignite.configuration.internal.selector.BaseSelectors;
import org.apache.ignite.configuration.validation.ConfigurationValidationException;
import org.apache.ignite.configuration.validation.FieldValidator;

public abstract class DynamicConfiguration<VIEW, INIT, CHANGE>
implements Modifier<VIEW, INIT, CHANGE>,
ConfigurationTree<VIEW, CHANGE> {
    protected final String qualifiedName;
    protected final String key;
    protected final String prefix;
    protected final Map<String, Modifier<?, ?, ?>> members = new HashMap();
    protected final DynamicConfiguration<?, ?, ?> root;
    protected final boolean isNamed;
    protected final Configurator<? extends DynamicConfiguration<?, ?, ?>> configurator;

    protected DynamicConfiguration(String prefix, String key, boolean isNamed, Configurator<? extends DynamicConfiguration<?, ?, ?>> configurator, DynamicConfiguration<?, ?, ?> root) {
        this.prefix = prefix;
        this.isNamed = isNamed;
        this.configurator = configurator;
        this.key = key;
        this.qualifiedName = root == null ? key : (isNamed ? String.format("%s[%s]", prefix, key) : String.format("%s.%s", prefix, key));
        this.root = root != null ? root : this;
    }

    protected <M extends Modifier<?, ?, ?>> void add(M member) {
        this.members.put(member.key(), member);
    }

    protected <PROP extends Serializable, M extends DynamicProperty<PROP>> void add(M member, List<FieldValidator<? super PROP, ? extends ConfigurationTree<?, ?>>> validators) {
        this.members.put(member.key(), member);
        this.configurator.addValidations(this.getClass(), member.key(), validators);
    }

    @Override
    public void change(CHANGE change) throws ConfigurationValidationException {
        this.configurator.set(BaseSelectors.find(this.qualifiedName), change);
    }

    @Override
    public String key() {
        return this.key;
    }

    public abstract DynamicConfiguration<VIEW, INIT, CHANGE> copy(DynamicConfiguration<?, ?, ?> var1);

    public final DynamicConfiguration<VIEW, INIT, CHANGE> copy() {
        return this.copy(null);
    }

    @Override
    public void validate(DynamicConfiguration<?, ?, ?> oldRoot) throws ConfigurationValidationException {
        for (Modifier<?, ?, ?> member : this.members.values()) {
            member.validate(oldRoot);
        }
    }

    @Override
    public Map<String, ConfigurationProperty<?, ?>> members() {
        return this.members.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

