/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.configuration;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.ignite.configuration.ConfigurationProperty;
import org.apache.ignite.configuration.ConfigurationTree;
import org.apache.ignite.configuration.PropertyListener;
import org.apache.ignite.configuration.internal.DynamicConfiguration;
import org.apache.ignite.configuration.internal.DynamicProperty;
import org.apache.ignite.configuration.internal.Modifier;
import org.apache.ignite.configuration.internal.selector.Selector;
import org.apache.ignite.configuration.internal.validation.MemberKey;
import org.apache.ignite.configuration.storage.ConfigurationStorage;
import org.apache.ignite.configuration.validation.ConfigurationValidationException;
import org.apache.ignite.configuration.validation.FieldValidator;

public class Configurator<T extends DynamicConfiguration<?, ?, ?>> {
    private final ConfigurationStorage storage;
    private final T root;
    private final Map<MemberKey, List<FieldValidator<? extends Serializable, T>>> fieldValidators = new HashMap<MemberKey, List<FieldValidator<? extends Serializable, T>>>();

    public static <VIEW, INIT, CHANGE, CONF extends DynamicConfiguration<VIEW, INIT, CHANGE>> Configurator<CONF> create(ConfigurationStorage storage, Function<Configurator<CONF>, CONF> rootBuilder) {
        return new Configurator(storage, rootBuilder, null);
    }

    public static <VIEW, INIT, CHANGE, CONF extends DynamicConfiguration<VIEW, INIT, CHANGE>> Configurator<CONF> create(ConfigurationStorage storage, Function<Configurator<CONF>, CONF> rootBuilder, INIT init) {
        return new Configurator(storage, rootBuilder, init);
    }

    private <VIEW, INIT, CHANGE, CONF extends DynamicConfiguration<VIEW, INIT, CHANGE>> Configurator(ConfigurationStorage storage, Function<Configurator<CONF>, CONF> rootBuilder, INIT init) {
        this.storage = storage;
        DynamicConfiguration built = (DynamicConfiguration)rootBuilder.apply(this);
        if (init != null) {
            built.init(init);
        }
        this.root = built;
    }

    public <TARGET extends Modifier<VIEW, INIT, CHANGE>, VIEW, INIT, CHANGE> VIEW getPublic(Selector<T, TARGET, VIEW, INIT, CHANGE> selector) {
        return (VIEW)selector.select(this.root).value();
    }

    public <TARGET extends Modifier<VIEW, INIT, CHANGE>, VIEW, INIT, CHANGE> void set(Selector<T, TARGET, VIEW, INIT, CHANGE> selector, CHANGE newValue) throws ConfigurationValidationException {
        DynamicConfiguration copy = ((DynamicConfiguration)this.root).copy();
        TARGET select = selector.select(copy);
        select.changeWithoutValidation(newValue);
        copy.validate((DynamicConfiguration<?, ?, ?>)this.root);
        selector.select(this.root).changeWithoutValidation(newValue);
    }

    public <TARGET extends Modifier<VIEW, INIT, CHANGE>, VIEW, INIT, CHANGE> ConfigurationProperty<VIEW, CHANGE> getInternal(Selector<T, TARGET, VIEW, INIT, CHANGE> selector) {
        return selector.select(this.root);
    }

    public <PROP extends Serializable> void addValidations(Class<? extends ConfigurationTree<?, ?>> aClass, String key, List<FieldValidator<? super PROP, ? extends ConfigurationTree<?, ?>>> validators) {
        this.fieldValidators.put(new MemberKey(aClass, key), validators);
    }

    public List<FieldValidator<? extends Serializable, T>> validators(MemberKey key) {
        return this.fieldValidators.getOrDefault(key, Collections.emptyList());
    }

    public T getRoot() {
        return this.root;
    }

    public <PROP extends Serializable> void onAttached(DynamicProperty<PROP> property) {
        final String key = property.key();
        property.addListener(new PropertyListener<PROP, PROP>(){

            @Override
            public void update(PROP newValue, ConfigurationProperty<PROP, PROP> modifier) {
                Configurator.this.storage.save(key, newValue);
            }
        });
        this.storage.listen(key, property::setSilently);
    }
}

