/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management.raft;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.ignite.internal.cluster.management.raft.ClusterStateStorage;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.lang.ByteArray;
import org.apache.ignite.lang.IgniteInternalException;
import org.jetbrains.annotations.Nullable;

public class TestClusterStateStorage
implements ClusterStateStorage {
    private static final String SNAPSHOT_FILE = "snapshot.bin";
    private final Map<ByteArray, byte[]> map = new HashMap<ByteArray, byte[]>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private volatile boolean isStarted = false;

    public void start() {
        this.isStarted = true;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public byte @Nullable [] get(byte[] key) {
        this.lock.readLock().lock();
        try {
            byte[] byArray = this.map.get(new ByteArray(key));
            return byArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void put(byte[] key, byte[] value) {
        this.lock.writeLock().lock();
        try {
            this.map.put(new ByteArray(key), value);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceAll(byte[] prefix, byte[] key, byte[] value) {
        this.lock.writeLock().lock();
        try {
            this.map.entrySet().removeIf(e -> TestClusterStateStorage.startsWith(((ByteArray)e.getKey()).bytes(), prefix));
            this.map.put(new ByteArray(key), value);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void remove(byte[] key) {
        this.lock.writeLock().lock();
        try {
            this.map.remove(new ByteArray(key));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(Collection<byte[]> keys) {
        this.lock.writeLock().lock();
        try {
            for (byte[] key : keys) {
                this.remove(key);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Cursor<T> getWithPrefix(byte[] prefix, BiFunction<byte[], byte[], T> entryTransformer) {
        this.lock.readLock().lock();
        try {
            Cursor cursor = this.map.entrySet().stream().filter(e -> TestClusterStateStorage.startsWith(((ByteArray)e.getKey()).bytes(), prefix)).map(e -> entryTransformer.apply(((ByteArray)e.getKey()).bytes(), (byte[])e.getValue())).collect(Collectors.collectingAndThen(Collectors.toList(), data -> Cursor.fromIterator(data.iterator())));
            return cursor;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private static boolean startsWith(byte[] key, byte[] prefix) {
        return key.length >= prefix.length && Arrays.equals(key, 0, prefix.length, prefix, 0, prefix.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> snapshot(Path snapshotPath) {
        ArrayList values;
        ArrayList keys;
        this.lock.readLock().lock();
        try {
            keys = new ArrayList(this.map.size());
            values = new ArrayList(this.map.size());
            this.map.forEach((k, v) -> {
                keys.add(k.bytes());
                values.add(v);
            });
        }
        finally {
            this.lock.readLock().unlock();
        }
        return CompletableFuture.runAsync(() -> {
            try (ObjectOutputStream out = new ObjectOutputStream(Files.newOutputStream(snapshotPath.resolve(SNAPSHOT_FILE), new OpenOption[0]));){
                out.writeObject(keys);
                out.writeObject(values);
            }
            catch (Exception e) {
                throw new IgniteInternalException((Throwable)e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreSnapshot(Path snapshotPath) {
        try (ObjectInputStream in = new ObjectInputStream(Files.newInputStream(snapshotPath.resolve(SNAPSHOT_FILE), new OpenOption[0]));){
            List keys = (List)in.readObject();
            List values = (List)in.readObject();
            this.lock.writeLock().lock();
            try {
                this.map.clear();
                for (int i = 0; i < keys.size(); ++i) {
                    this.map.put(new ByteArray((byte[])keys.get(i)), (byte[])values.get(i));
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        catch (Exception e) {
            throw new IgniteInternalException((Throwable)e);
        }
    }

    public void destroy() {
        this.lock.writeLock().lock();
        try {
            this.map.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void close() throws Exception {
        this.isStarted = false;
    }
}

