/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.StringUtils;
import org.jetbrains.annotations.Nullable;

public class InitCommand {
    private final Collection<String> metaStorageNodes;
    private final Collection<String> cmgNodes;
    private final String clusterName;

    @JsonCreator
    public InitCommand(@JsonProperty(value="metaStorageNodes") Collection<String> metaStorageNodes, @JsonProperty(value="cmgNodes") @Nullable Collection<String> cmgNodes, @JsonProperty(value="clusterName") String clusterName) {
        Objects.requireNonNull(metaStorageNodes);
        Objects.requireNonNull(clusterName);
        if (metaStorageNodes.isEmpty()) {
            throw new IllegalArgumentException("Meta Storage node names list must not be empty");
        }
        if (metaStorageNodes.stream().anyMatch(StringUtils::nullOrBlank)) {
            throw new IllegalArgumentException("Meta Storage node names must not contain blank strings: " + metaStorageNodes);
        }
        if (!CollectionUtils.nullOrEmpty(cmgNodes) && cmgNodes.stream().anyMatch(StringUtils::nullOrBlank)) {
            throw new IllegalArgumentException("CMG node names must not contain blank strings: " + cmgNodes);
        }
        if (clusterName.isBlank()) {
            throw new IllegalArgumentException("Cluster name must not be empty");
        }
        this.metaStorageNodes = List.copyOf(metaStorageNodes);
        this.cmgNodes = cmgNodes == null ? List.of() : List.copyOf(cmgNodes);
        this.clusterName = clusterName;
    }

    @JsonProperty
    public Collection<String> metaStorageNodes() {
        return this.metaStorageNodes;
    }

    @JsonProperty
    public Collection<String> cmgNodes() {
        return this.cmgNodes;
    }

    @JsonProperty
    public String clusterName() {
        return this.clusterName;
    }

    public String toString() {
        return "InitCommand{metaStorageNodes=" + this.metaStorageNodes + ", cmgNodes=" + this.cmgNodes + ", clusterName='" + this.clusterName + "'}";
    }
}

