/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management.rest;

import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Post;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import org.apache.ignite.internal.cluster.management.ClusterInitializer;
import org.apache.ignite.internal.cluster.management.rest.InitCommand;
import org.apache.ignite.internal.cluster.management.rest.exception.InvalidArgumentClusterInitializationException;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.lang.IgniteInternalException;
import org.apache.ignite.lang.IgniteLogger;

@Controller(value="/management/v1/cluster/init")
@ApiResponses(value={@ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="500", description="Internal error")})
@Tag(name="clusterManagement")
public class ClusterManagementController {
    private static final IgniteLogger log = IgniteLogger.forClass(ClusterManagementController.class);
    private final ClusterInitializer clusterInitializer;

    public ClusterManagementController(ClusterInitializer clusterInitializer) {
        this.clusterInitializer = clusterInitializer;
    }

    @Post
    @Operation(operationId="init")
    @ApiResponse(responseCode="200", description="Cluster initialized")
    @Consumes(value={"application/json"})
    public CompletableFuture<Void> init(@Body InitCommand initCommand) throws ExecutionException, InterruptedException {
        if (log.isInfoEnabled()) {
            log.info("Received init command:\n\tMeta Storage nodes: {}\n\tCMG nodes: {}", new Object[]{initCommand.metaStorageNodes(), initCommand.cmgNodes()});
        }
        return this.clusterInitializer.initCluster(initCommand.metaStorageNodes(), initCommand.cmgNodes(), initCommand.clusterName()).exceptionally(ex -> {
            throw this.mapException((Throwable)ex);
        });
    }

    private RuntimeException mapException(Throwable ex) {
        Throwable cause;
        if (ex instanceof CompletionException && (cause = ex.getCause()) instanceof IgniteInternalException) {
            return (IgniteInternalException)cause;
        }
        if (ex instanceof IllegalArgumentException) {
            return new InvalidArgumentClusterInitializationException(ex);
        }
        return new IgniteException(ex);
    }
}

