/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management.raft;

import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.apache.ignite.internal.cluster.management.raft.ClusterStateStorage;
import org.apache.ignite.internal.rocksdb.ColumnFamily;
import org.apache.ignite.internal.rocksdb.RocksIteratorAdapter;
import org.apache.ignite.internal.rocksdb.snapshot.ColumnFamilyRange;
import org.apache.ignite.internal.rocksdb.snapshot.RocksSnapshotManager;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.IgniteInternalException;
import org.jetbrains.annotations.Nullable;
import org.rocksdb.AbstractSlice;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.Options;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.Slice;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;

public class RocksDbClusterStateStorage
implements ClusterStateStorage {
    private final ExecutorService snapshotExecutor = Executors.newFixedThreadPool(2);
    private final Path dbPath;
    @Nullable
    private volatile Options options;
    @Nullable
    private volatile RocksDB db;
    private volatile RocksSnapshotManager snapshotManager;
    private final Object snapshotRestoreLock = new Object();

    public RocksDbClusterStateStorage(Path dbPath) {
        this.dbPath = dbPath;
    }

    @Override
    public void start() {
        this.options = new Options().setCreateIfMissing(true);
        try {
            this.db = RocksDB.open((Options)this.options, (String)this.dbPath.toString());
            ColumnFamily defaultCf = ColumnFamily.wrap((RocksDB)this.db, (ColumnFamilyHandle)this.db.getDefaultColumnFamily());
            this.snapshotManager = new RocksSnapshotManager(this.db, List.of(ColumnFamilyRange.fullRange((ColumnFamily)defaultCf)), (Executor)this.snapshotExecutor);
        }
        catch (RocksDBException e) {
            throw new IgniteInternalException("Failed to start the storage", (Throwable)e);
        }
    }

    @Override
    public boolean isStarted() {
        return this.db != null;
    }

    @Override
    public byte @Nullable [] get(byte[] key) {
        try {
            return this.db.get(key);
        }
        catch (RocksDBException e) {
            throw new IgniteInternalException("Unable to get data from Rocks DB", (Throwable)e);
        }
    }

    @Override
    public void put(byte[] key, byte[] value) {
        try {
            this.db.put(key, value);
        }
        catch (RocksDBException e) {
            throw new IgniteInternalException("Unable to put data into Rocks DB", (Throwable)e);
        }
    }

    @Override
    public void remove(byte[] key) {
        try {
            this.db.delete(key);
        }
        catch (RocksDBException e) {
            throw new IgniteInternalException("Unable to remove data from Rocks DB", (Throwable)e);
        }
    }

    @Override
    public void removeAll(Collection<byte[]> keys) {
        try (WriteBatch batch = new WriteBatch();
             WriteOptions options = new WriteOptions();){
            for (byte[] key : keys) {
                batch.delete(key);
            }
            this.db.write(options, batch);
        }
        catch (RocksDBException e) {
            throw new IgniteInternalException("Unable to remove data from Rocks DB", (Throwable)e);
        }
    }

    @Override
    public <T> Cursor<T> getWithPrefix(byte[] prefix, final BiFunction<byte[], byte[], T> entryTransformer) {
        byte[] upperBound = (byte[])prefix.clone();
        assert (upperBound[upperBound.length - 1] != -1);
        int n = upperBound.length - 1;
        upperBound[n] = (byte)(upperBound[n] + 1);
        final Slice upperBoundSlice = new Slice(upperBound);
        final ReadOptions readOptions = new ReadOptions().setIterateUpperBound((AbstractSlice)upperBoundSlice);
        RocksIterator it = this.db.newIterator(readOptions);
        it.seek(prefix);
        return new RocksIteratorAdapter<T>(it){

            protected T decodeEntry(byte[] key, byte[] value) {
                return entryTransformer.apply(key, value);
            }

            public void close() throws Exception {
                super.close();
                IgniteUtils.closeAll((AutoCloseable[])new AutoCloseable[]{readOptions, upperBoundSlice});
            }
        };
    }

    @Override
    public CompletableFuture<Void> snapshot(Path snapshotPath) {
        return this.snapshotManager.createSnapshot(snapshotPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreSnapshot(Path snapshotPath) {
        Object object = this.snapshotRestoreLock;
        synchronized (object) {
            this.destroy();
            this.start();
            this.snapshotManager.restoreSnapshot(snapshotPath);
        }
    }

    @Override
    public void destroy() {
        try (Options options = new Options();){
            this.close();
            RocksDB.destroyDB((String)this.dbPath.toString(), (Options)options);
        }
        catch (Exception e) {
            throw new IgniteInternalException("Unable to clear RocksDB instance", (Throwable)e);
        }
    }

    @Override
    public void close() throws Exception {
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.snapshotExecutor, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        IgniteUtils.closeAll((AutoCloseable[])new AutoCloseable[]{this.options, this.db});
        this.db = null;
        this.options = null;
    }
}

