/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management.raft;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.ignite.internal.cluster.management.ClusterState;
import org.apache.ignite.internal.cluster.management.raft.ClusterStateStorage;
import org.apache.ignite.internal.util.ByteUtils;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.lang.IgniteInternalException;
import org.apache.ignite.network.ClusterNode;
import org.jetbrains.annotations.Nullable;

class RaftStorageManager {
    private static final byte[] CMG_STATE_KEY = "cmg_state".getBytes(StandardCharsets.UTF_8);
    private static final byte[] LOGICAL_TOPOLOGY_PREFIX = "logical_".getBytes(StandardCharsets.UTF_8);
    private static final byte[] VALIDATED_NODE_PREFIX = "validation_".getBytes(StandardCharsets.UTF_8);
    private static final byte[] EMPTY_VALUE = new byte[0];
    private final ClusterStateStorage storage;

    RaftStorageManager(ClusterStateStorage storage) {
        this.storage = storage;
    }

    @Nullable
    ClusterState getClusterState() {
        return this.get(CMG_STATE_KEY, ClusterState.class);
    }

    void putClusterState(ClusterState state) {
        this.storage.put(CMG_STATE_KEY, ByteUtils.toBytes((Object)state));
    }

    Collection<ClusterNode> getLogicalTopology() {
        Collection collection;
        block8: {
            Cursor<ClusterNode> cursor = this.storage.getWithPrefix(LOGICAL_TOPOLOGY_PREFIX, (k, v) -> (ClusterNode)ByteUtils.fromBytes((byte[])v));
            Cursor<ClusterNode> cursor2 = cursor;
            try {
                collection = cursor.stream().collect(Collectors.toList());
                if (cursor2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (cursor2 != null) {
                        try {
                            cursor2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IgniteInternalException("Unable to get data from storage", (Throwable)e);
                }
            }
            cursor2.close();
        }
        return collection;
    }

    void putLogicalTopologyNode(ClusterNode node) {
        this.storage.put(RaftStorageManager.logicalTopologyKey(node), ByteUtils.toBytes((Object)node));
    }

    void removeLogicalTopologyNodes(Set<ClusterNode> nodes) {
        Collection keys = nodes.stream().map(RaftStorageManager::logicalTopologyKey).collect(Collectors.toList());
        this.storage.removeAll(keys);
    }

    boolean isNodeInLogicalTopology(ClusterNode node) {
        byte[] value = this.storage.get(RaftStorageManager.logicalTopologyKey(node));
        return value != null;
    }

    private static byte[] logicalTopologyKey(ClusterNode node) {
        return RaftStorageManager.prefixedKey(LOGICAL_TOPOLOGY_PREFIX, node.id());
    }

    boolean isNodeValidated(String nodeId) {
        byte[] value = this.storage.get(RaftStorageManager.validatedNodeKey(nodeId));
        return value != null;
    }

    void putValidatedNode(String nodeId) {
        this.storage.put(RaftStorageManager.validatedNodeKey(nodeId), EMPTY_VALUE);
    }

    void removeValidatedNode(String nodeId) {
        this.storage.remove(RaftStorageManager.validatedNodeKey(nodeId));
    }

    private static byte[] validatedNodeKey(String nodeId) {
        return RaftStorageManager.prefixedKey(VALIDATED_NODE_PREFIX, nodeId);
    }

    Collection<String> getValidatedNodeIds() {
        Collection collection;
        block8: {
            Cursor<String> cursor = this.storage.getWithPrefix(VALIDATED_NODE_PREFIX, (k, v) -> new String((byte[])k, VALIDATED_NODE_PREFIX.length, ((byte[])k).length - VALIDATED_NODE_PREFIX.length, StandardCharsets.UTF_8));
            Cursor<String> cursor2 = cursor;
            try {
                collection = cursor.stream().collect(Collectors.toList());
                if (cursor2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (cursor2 != null) {
                        try {
                            cursor2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IgniteInternalException("Unable to get data from storage", (Throwable)e);
                }
            }
            cursor2.close();
        }
        return collection;
    }

    @Nullable
    private <T> T get(byte[] key, Class<T> cls) {
        byte[] value = this.storage.get(key);
        return value == null ? null : (T)cls.cast(ByteUtils.fromBytes((byte[])value));
    }

    private static byte[] prefixedKey(byte[] prefix, String nodeId) {
        byte[] nodeIdBytes = nodeId.getBytes(StandardCharsets.UTF_8);
        return ByteBuffer.allocate(prefix.length + nodeIdBytes.length).put(prefix).put(nodeIdBytes).array();
    }

    CompletableFuture<Void> snapshot(Path snapshotPath) {
        return this.storage.snapshot(snapshotPath);
    }

    void restoreSnapshot(Path snapshotPath) {
        this.storage.restoreSnapshot(snapshotPath);
    }
}

