/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management.network.messages;

import java.util.Collection;
import java.util.Objects;
import org.apache.ignite.internal.cluster.management.network.messages.CmgInitMessage;
import org.apache.ignite.internal.cluster.management.network.messages.CmgInitMessageBuilder;

public class CmgInitMessageImpl
implements CmgInitMessage {
    public static final short GROUP_TYPE = 7;
    public static final short TYPE = 1;
    private final String clusterName;
    private final Collection<String> cmgNodes;
    private final Collection<String> metaStorageNodes;

    private CmgInitMessageImpl(String clusterName, Collection<String> cmgNodes, Collection<String> metaStorageNodes) {
        this.clusterName = clusterName;
        this.cmgNodes = cmgNodes;
        this.metaStorageNodes = metaStorageNodes;
    }

    @Override
    public String clusterName() {
        return this.clusterName;
    }

    @Override
    public Collection<String> cmgNodes() {
        return this.cmgNodes;
    }

    @Override
    public Collection<String> metaStorageNodes() {
        return this.metaStorageNodes;
    }

    public short groupType() {
        return 7;
    }

    public short messageType() {
        return 1;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        CmgInitMessageImpl otherMessage = (CmgInitMessageImpl)other;
        return Objects.equals(this.clusterName, otherMessage.clusterName) && Objects.equals(this.cmgNodes, otherMessage.cmgNodes) && Objects.equals(this.metaStorageNodes, otherMessage.metaStorageNodes);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.clusterName, this.cmgNodes, this.metaStorageNodes);
        return result;
    }

    public static CmgInitMessageBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements CmgInitMessageBuilder {
        private String clusterName;
        private Collection<String> cmgNodes;
        private Collection<String> metaStorageNodes;

        private Builder() {
        }

        @Override
        public CmgInitMessageBuilder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        @Override
        public CmgInitMessageBuilder cmgNodes(Collection<String> cmgNodes) {
            this.cmgNodes = cmgNodes;
            return this;
        }

        @Override
        public CmgInitMessageBuilder metaStorageNodes(Collection<String> metaStorageNodes) {
            this.metaStorageNodes = metaStorageNodes;
            return this;
        }

        @Override
        public String clusterName() {
            return this.clusterName;
        }

        @Override
        public Collection<String> cmgNodes() {
            return this.cmgNodes;
        }

        @Override
        public Collection<String> metaStorageNodes() {
            return this.metaStorageNodes;
        }

        @Override
        public CmgInitMessage build() {
            return new CmgInitMessageImpl(this.clusterName, this.cmgNodes, this.metaStorageNodes);
        }
    }
}

