/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management.network;

import org.apache.ignite.internal.cluster.management.ClusterManagementGroupManager;
import org.apache.ignite.internal.cluster.management.network.messages.CmgMessagesFactory;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.lang.IgniteLogger;
import org.apache.ignite.lang.NodeStoppingException;
import org.apache.ignite.network.ClusterService;
import org.apache.ignite.network.NetworkMessage;
import org.apache.ignite.network.NetworkMessageHandler;

public class CmgMessageHandlerFactory {
    private static final IgniteLogger LOG = IgniteLogger.forClass(ClusterManagementGroupManager.class);
    private final IgniteSpinBusyLock busyLock;
    private final CmgMessagesFactory msgFactory;
    private final ClusterService clusterService;

    public CmgMessageHandlerFactory(IgniteSpinBusyLock busyLock, CmgMessagesFactory msgFactory, ClusterService clusterService) {
        this.busyLock = busyLock;
        this.msgFactory = msgFactory;
        this.clusterService = clusterService;
    }

    public NetworkMessageHandler wrapHandler(NetworkMessageHandler handler) {
        return (message, senderAddr, correlationId) -> {
            if (!this.busyLock.enterBusy()) {
                if (correlationId != null) {
                    this.clusterService.messagingService().respond(senderAddr, this.initFailed((Exception)((Object)new NodeStoppingException())), correlationId.longValue());
                }
                return;
            }
            try {
                handler.onReceived(message, senderAddr, correlationId);
            }
            catch (Exception e) {
                LOG.error("CMG message handling failed", (Throwable)e);
                if (correlationId != null) {
                    this.clusterService.messagingService().respond(senderAddr, this.initFailed(e), correlationId.longValue());
                }
            }
            finally {
                this.busyLock.leaveBusy();
            }
        };
    }

    private NetworkMessage initFailed(Exception e) {
        return this.msgFactory.initErrorMessage().cause(e.getMessage()).build();
    }
}

