/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management;

import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.apache.ignite.internal.cluster.management.ClusterTag;
import org.apache.ignite.internal.properties.IgniteProductVersion;

public final class ClusterState
implements Serializable {
    private final Set<String> cmgNodes;
    private final Set<String> msNodes;
    private final IgniteProductVersion igniteVersion;
    private final ClusterTag clusterTag;

    public ClusterState(Collection<String> cmgNodes, Collection<String> metaStorageNodes, IgniteProductVersion igniteVersion, ClusterTag clusterTag) {
        this.cmgNodes = Set.copyOf(cmgNodes);
        this.msNodes = Set.copyOf(metaStorageNodes);
        this.igniteVersion = igniteVersion;
        this.clusterTag = clusterTag;
    }

    public Set<String> cmgNodes() {
        return this.cmgNodes;
    }

    public Set<String> metaStorageNodes() {
        return this.msNodes;
    }

    public IgniteProductVersion igniteVersion() {
        return this.igniteVersion;
    }

    public ClusterTag clusterTag() {
        return this.clusterTag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterState state = (ClusterState)o;
        return this.cmgNodes.equals(state.cmgNodes) && this.msNodes.equals(state.msNodes) && this.igniteVersion.equals((Object)state.igniteVersion) && this.clusterTag.equals(state.clusterTag);
    }

    public int hashCode() {
        return Objects.hash(this.cmgNodes, this.msNodes, this.igniteVersion, this.clusterTag);
    }

    public String toString() {
        return "ClusterState{cmgNodes=" + this.cmgNodes + ", msNodes=" + this.msNodes + ", igniteVersion=" + this.igniteVersion + ", clusterTag=" + this.clusterTag + "}";
    }
}

