/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.internal.cluster.management.InternalInitException;
import org.apache.ignite.internal.cluster.management.network.messages.CancelInitMessage;
import org.apache.ignite.internal.cluster.management.network.messages.CmgInitMessage;
import org.apache.ignite.internal.cluster.management.network.messages.CmgMessagesFactory;
import org.apache.ignite.internal.cluster.management.network.messages.InitCompleteMessage;
import org.apache.ignite.internal.cluster.management.network.messages.InitErrorMessage;
import org.apache.ignite.internal.util.StringUtils;
import org.apache.ignite.lang.IgniteLogger;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.network.ClusterService;
import org.apache.ignite.network.NetworkMessage;
import org.apache.ignite.network.util.ClusterServiceUtils;

public class ClusterInitializer {
    private static final IgniteLogger LOG = IgniteLogger.forClass(ClusterInitializer.class);
    private final ClusterService clusterService;
    private final CmgMessagesFactory msgFactory = new CmgMessagesFactory();

    public ClusterInitializer(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    public CompletableFuture<Void> initCluster(Collection<String> metaStorageNodeNames, Collection<String> cmgNodeNames, String clusterName) {
        if (metaStorageNodeNames.isEmpty()) {
            throw new IllegalArgumentException("Meta Storage node names list must not be empty");
        }
        if (metaStorageNodeNames.stream().anyMatch(StringUtils::nullOrBlank)) {
            throw new IllegalArgumentException("Meta Storage node names must not contain blank strings: " + metaStorageNodeNames);
        }
        if (!cmgNodeNames.isEmpty() && cmgNodeNames.stream().anyMatch(StringUtils::nullOrBlank)) {
            throw new IllegalArgumentException("CMG node names must not contain blank strings: " + cmgNodeNames);
        }
        if (clusterName.isBlank()) {
            throw new IllegalArgumentException("Cluster name must not be empty");
        }
        try {
            metaStorageNodeNames = metaStorageNodeNames.stream().map(String::trim).collect(Collectors.toUnmodifiableList());
            cmgNodeNames = cmgNodeNames.isEmpty() ? metaStorageNodeNames : (Collection)cmgNodeNames.stream().map(String::trim).collect(Collectors.toUnmodifiableList());
            List msNodes = ClusterServiceUtils.resolveNodes((ClusterService)this.clusterService, (Collection)metaStorageNodeNames);
            LOG.info("Resolved MetaStorage nodes: {}", new Object[]{msNodes});
            List cmgNodes = ClusterServiceUtils.resolveNodes((ClusterService)this.clusterService, (Collection)cmgNodeNames);
            LOG.info("Resolved CMG nodes: {}", new Object[]{cmgNodes});
            CmgInitMessage initMessage = this.msgFactory.cmgInitMessage().metaStorageNodes(metaStorageNodeNames).cmgNodes(cmgNodeNames).clusterName(clusterName).build();
            return ((CompletableFuture)this.invokeMessage(cmgNodes, initMessage).handle((v, e) -> {
                if (e == null) {
                    LOG.info("Init message sent successfully:\n\tCMG nodes: {}\n\tMetaStorage nodes: {}\n\tCluster name: {}", new Object[]{initMessage.cmgNodes(), initMessage.metaStorageNodes(), initMessage.clusterName()});
                    return CompletableFuture.completedFuture(null);
                }
                if (e instanceof CompletionException) {
                    e = e.getCause();
                }
                LOG.error("Initialization failed: {}", e, new Object[]{e.getMessage()});
                if (e instanceof InternalInitException && !((InternalInitException)((Object)((Object)e))).shouldCancelInit()) {
                    return CompletableFuture.failedFuture(e);
                }
                LOG.error("Critical error encountered, rolling back the init procedure", new Object[0]);
                return this.cancelInit(cmgNodes, (Throwable)e);
            })).thenCompose(Function.identity());
        }
        catch (Exception e2) {
            return CompletableFuture.failedFuture(e2);
        }
    }

    private CompletableFuture<Void> cancelInit(Collection<ClusterNode> nodes, Throwable e) {
        CancelInitMessage cancelMessage = this.msgFactory.cancelInitMessage().reason(e.getMessage()).build();
        return ((CompletableFuture)this.sendMessage(nodes, cancelMessage).exceptionally(nestedEx -> {
            LOG.error("Error when canceling init", nestedEx);
            e.addSuppressed((Throwable)nestedEx);
            return null;
        })).thenCompose(v -> CompletableFuture.failedFuture(e));
    }

    private CompletableFuture<Void> invokeMessage(Collection<ClusterNode> nodes, NetworkMessage message) {
        return ClusterInitializer.allOf(nodes, node -> this.clusterService.messagingService().invoke(node, message, 10000L).thenAccept(response -> {
            if (response instanceof InitErrorMessage) {
                InitErrorMessage errorResponse = (InitErrorMessage)response;
                throw new InternalInitException(String.format("Got error response from node \"%s\": %s", node.name(), errorResponse.cause()), errorResponse.shouldCancel());
            }
            if (!(response instanceof InitCompleteMessage)) {
                throw new InternalInitException(String.format("Unexpected response from node \"%s\": %s", node.name(), response.getClass()), true);
            }
        }));
    }

    private CompletableFuture<Void> sendMessage(Collection<ClusterNode> nodes, NetworkMessage message) {
        return ClusterInitializer.allOf(nodes, node -> this.clusterService.messagingService().send(node, message));
    }

    private static CompletableFuture<Void> allOf(Collection<ClusterNode> nodes, Function<ClusterNode, CompletableFuture<?>> futureProducer) {
        CompletableFuture[] futures = (CompletableFuture[])nodes.stream().map(futureProducer).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(futures);
    }
}

