/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc.proto.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.jdbc.proto.event.Response;
import org.apache.ignite.internal.tostring.S;

public class QuerySingleResult
extends Response {
    private long cursorId;
    private List<List<Object>> items;
    private boolean last;
    private boolean isQuery;
    private long updateCnt;

    public QuerySingleResult() {
    }

    public QuerySingleResult(int status, String err) {
        super(status, err);
    }

    public QuerySingleResult(long cursorId, List<List<Object>> items, boolean last) {
        Objects.requireNonNull(items);
        this.cursorId = cursorId;
        this.items = items;
        this.last = last;
        this.isQuery = true;
        this.hasResults = true;
    }

    public QuerySingleResult(long cursorId, long updateCnt) {
        this.cursorId = cursorId;
        this.last = true;
        this.isQuery = false;
        this.updateCnt = updateCnt;
        this.items = Collections.emptyList();
        this.hasResults = true;
    }

    public long cursorId() {
        return this.cursorId;
    }

    public List<List<Object>> items() {
        return this.items;
    }

    public boolean last() {
        return this.last;
    }

    public boolean isQuery() {
        return this.isQuery;
    }

    public long updateCount() {
        return this.updateCnt;
    }

    @Override
    public void writeBinary(ClientMessagePacker packer) {
        super.writeBinary(packer);
        if (!this.hasResults) {
            return;
        }
        packer.packLong(this.cursorId);
        packer.packBoolean(this.isQuery);
        packer.packLong(this.updateCnt);
        packer.packBoolean(this.last);
        packer.packArrayHeader(this.items.size());
        for (List<Object> item : this.items) {
            packer.packObjectArray(item.toArray());
        }
    }

    @Override
    public void readBinary(ClientMessageUnpacker unpacker) {
        super.readBinary(unpacker);
        if (!this.hasResults) {
            return;
        }
        this.cursorId = unpacker.unpackLong();
        this.isQuery = unpacker.unpackBoolean();
        this.updateCnt = unpacker.unpackLong();
        this.last = unpacker.unpackBoolean();
        int size = unpacker.unpackArrayHeader();
        this.items = new ArrayList<List<Object>>(size);
        for (int i = 0; i < size; ++i) {
            this.items.add(Arrays.asList(unpacker.unpackObjectArray()));
        }
    }

    @Override
    public String toString() {
        return S.toString(QuerySingleResult.class, (Object)this);
    }
}

