/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc.proto.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.jdbc.proto.event.Response;
import org.apache.ignite.internal.tostring.S;

public class QueryFetchResult
extends Response {
    private List<List<Object>> items;
    private boolean last;

    public QueryFetchResult() {
    }

    public QueryFetchResult(int status, String err) {
        super(status, err);
    }

    public QueryFetchResult(List<List<Object>> items, boolean last) {
        Objects.requireNonNull(items);
        this.items = items;
        this.last = last;
        this.hasResults = true;
    }

    public List<List<Object>> items() {
        return this.items;
    }

    public boolean last() {
        return this.last;
    }

    @Override
    public void writeBinary(ClientMessagePacker packer) {
        super.writeBinary(packer);
        if (!this.hasResults) {
            return;
        }
        packer.packBoolean(this.last);
        packer.packArrayHeader(this.items.size());
        for (List<Object> item : this.items) {
            packer.packObjectArray(item.toArray());
        }
    }

    @Override
    public void readBinary(ClientMessageUnpacker unpacker) {
        super.readBinary(unpacker);
        if (!this.hasResults) {
            return;
        }
        this.last = unpacker.unpackBoolean();
        int size = unpacker.unpackArrayHeader();
        this.items = new ArrayList<List<Object>>(size);
        for (int i = 0; i < size; ++i) {
            this.items.add(Arrays.asList(unpacker.unpackObjectArray()));
        }
    }

    @Override
    public String toString() {
        return S.toString(QueryFetchResult.class, (Object)this);
    }
}

