/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc.proto.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.jdbc.proto.event.QuerySingleResult;
import org.apache.ignite.internal.jdbc.proto.event.Response;
import org.apache.ignite.internal.tostring.S;

public class QueryExecuteResult
extends Response {
    private List<QuerySingleResult> results;

    public QueryExecuteResult() {
    }

    public QueryExecuteResult(int status, String err) {
        super(status, err);
    }

    public QueryExecuteResult(List<QuerySingleResult> results) {
        Objects.requireNonNull(results);
        this.results = results;
        this.hasResults = true;
    }

    @Override
    public void writeBinary(ClientMessagePacker packer) {
        super.writeBinary(packer);
        if (!this.hasResults) {
            return;
        }
        packer.packArrayHeader(this.results.size());
        for (QuerySingleResult result : this.results) {
            result.writeBinary(packer);
        }
    }

    @Override
    public void readBinary(ClientMessageUnpacker unpacker) {
        super.readBinary(unpacker);
        if (!this.hasResults) {
            return;
        }
        int size = unpacker.unpackArrayHeader();
        if (size == 0) {
            this.results = Collections.emptyList();
            return;
        }
        this.results = new ArrayList<QuerySingleResult>(size);
        for (int i = 0; i < size; ++i) {
            QuerySingleResult res = new QuerySingleResult();
            res.readBinary(unpacker);
            this.results.add(res);
        }
    }

    public List<QuerySingleResult> results() {
        return this.results;
    }

    @Override
    public String toString() {
        return S.toString(QueryExecuteResult.class, (Object)this);
    }
}

