/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc.proto.event;

import io.netty.util.internal.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.jdbc.proto.ClientMessage;
import org.apache.ignite.internal.jdbc.proto.event.ClientMessageUtils;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.CollectionUtils;

public class BatchPreparedStmntRequest
implements ClientMessage {
    private String schemaName;
    private String query;
    private List<Object[]> args;

    public BatchPreparedStmntRequest() {
    }

    public BatchPreparedStmntRequest(String schemaName, String query, List<Object[]> args) {
        assert (!StringUtil.isNullOrEmpty((String)query));
        assert (!CollectionUtils.nullOrEmpty(args));
        this.query = query;
        this.args = args;
        this.schemaName = schemaName;
    }

    public String schemaName() {
        return this.schemaName;
    }

    public String getQuery() {
        return this.query;
    }

    public List<Object[]> getArgs() {
        return this.args;
    }

    @Override
    public void writeBinary(ClientMessagePacker packer) {
        ClientMessageUtils.writeStringNullable(packer, this.schemaName);
        packer.packString(this.query);
        packer.packArrayHeader(this.args.size());
        for (Object[] arg : this.args) {
            packer.packObjectArray(arg);
        }
    }

    @Override
    public void readBinary(ClientMessageUnpacker unpacker) {
        this.schemaName = ClientMessageUtils.readStringNullable(unpacker);
        this.query = unpacker.unpackString();
        int n = unpacker.unpackArrayHeader();
        this.args = new ArrayList<Object[]>(n);
        for (int i = 0; i < n; ++i) {
            this.args.add(unpacker.unpackObjectArray());
        }
    }

    public String toString() {
        return S.toString(BatchPreparedStmntRequest.class, (Object)this);
    }
}

