/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc.proto.event;

import java.util.Objects;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.jdbc.proto.event.Response;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.ArrayUtils;

public class BatchExecuteResult
extends Response {
    private int[] updateCnts;
    private int errorCode;

    public BatchExecuteResult() {
    }

    public BatchExecuteResult(int status, int errorCode, String errorMessage, int[] updateCnts) {
        super(status, errorMessage);
        this.errorCode = errorCode;
        this.updateCnts = updateCnts;
    }

    public BatchExecuteResult(int status, String err) {
        super(status, err);
    }

    public BatchExecuteResult(int[] updateCnts) {
        Objects.requireNonNull(updateCnts);
        this.updateCnts = updateCnts;
        this.hasResults = true;
    }

    public int[] updateCounts() {
        return this.updateCnts == null ? ArrayUtils.INT_EMPTY_ARRAY : this.updateCnts;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    @Override
    public void writeBinary(ClientMessagePacker packer) {
        super.writeBinary(packer);
        packer.packInt(this.errorCode);
        packer.packIntArray(this.updateCnts);
    }

    @Override
    public void readBinary(ClientMessageUnpacker unpacker) {
        super.readBinary(unpacker);
        this.errorCode = unpacker.unpackInt();
        this.updateCnts = unpacker.tryUnpackNil() ? ArrayUtils.INT_EMPTY_ARRAY : unpacker.unpackIntArray();
    }

    @Override
    public String toString() {
        return S.toString(BatchExecuteResult.class, (Object)this);
    }
}

