/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc.proto.event;

import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.jdbc.proto.ClientMessage;
import org.apache.ignite.internal.jdbc.proto.event.ClientMessageUtils;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.CollectionUtils;

public class BatchExecuteRequest
implements ClientMessage {
    private String schemaName;
    private List<String> queries;

    public BatchExecuteRequest() {
    }

    public BatchExecuteRequest(String schemaName, List<String> queries) {
        assert (!CollectionUtils.nullOrEmpty(queries));
        this.schemaName = schemaName;
        this.queries = queries;
    }

    public String schemaName() {
        return this.schemaName;
    }

    public List<String> queries() {
        return this.queries;
    }

    @Override
    public void writeBinary(ClientMessagePacker packer) {
        ClientMessageUtils.writeStringNullable(packer, this.schemaName);
        packer.packArrayHeader(this.queries.size());
        for (String q : this.queries) {
            packer.packString(q);
        }
    }

    @Override
    public void readBinary(ClientMessageUnpacker unpacker) {
        this.schemaName = ClientMessageUtils.readStringNullable(unpacker);
        int n = unpacker.unpackArrayHeader();
        this.queries = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            this.queries.add(unpacker.unpackString());
        }
    }

    public String toString() {
        return S.toString(BatchExecuteRequest.class, (Object)this);
    }
}

