/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.proto;

import io.netty.buffer.ByteBuf;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.BitSet;
import java.util.UUID;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.lang.IgniteException;
import org.msgpack.core.ExtensionTypeHeader;
import org.msgpack.core.MessageFormat;
import org.msgpack.core.MessageFormatException;
import org.msgpack.core.MessageNeverUsedFormatException;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePackException;
import org.msgpack.core.MessageSizeException;
import org.msgpack.core.MessageTypeException;

public class ClientMessageUnpacker
implements AutoCloseable {
    private final ByteBuf buf;
    private int refCnt = 1;

    public ClientMessageUnpacker(ByteBuf buf) {
        assert (buf != null);
        this.buf = buf;
    }

    private static MessageSizeException overflowU32Size(int u32) {
        long lv = (long)(u32 & Integer.MAX_VALUE) + 0x80000000L;
        return new MessageSizeException(lv);
    }

    private static MessagePackException unexpected(String expected, byte b) {
        MessageFormat format = MessageFormat.valueOf((byte)b);
        if (format == MessageFormat.NEVER_USED) {
            return new MessageNeverUsedFormatException(String.format("Expected %s, but encountered 0xC1 \"NEVER_USED\" byte", expected));
        }
        String name = format.getValueType().name();
        String typeName = name.charAt(0) + name.substring(1).toLowerCase();
        return new MessageTypeException(String.format("Expected %s, but got %s (%02x)", expected, typeName, b));
    }

    public int unpackInt() {
        assert (this.refCnt > 0) : "Unpacker is closed";
        byte code = this.buf.readByte();
        if (MessagePack.Code.isFixInt((byte)code)) {
            return code;
        }
        switch (code) {
            case -52: {
                return this.buf.readUnsignedByte();
            }
            case -48: {
                return this.buf.readByte();
            }
            case -51: {
                return this.buf.readUnsignedShort();
            }
            case -47: {
                return this.buf.readShort();
            }
            case -50: 
            case -46: {
                return this.buf.readInt();
            }
        }
        throw ClientMessageUnpacker.unexpected("Integer", code);
    }

    public String unpackString() {
        assert (this.refCnt > 0) : "Unpacker is closed";
        int len = this.unpackRawStringHeader();
        int pos = this.buf.readerIndex();
        String res = this.buf.toString(pos, len, StandardCharsets.UTF_8);
        this.buf.readerIndex(pos + len);
        return res;
    }

    public void unpackNil() {
        assert (this.refCnt > 0) : "Unpacker is closed";
        byte code = this.buf.readByte();
        if (code == -64) {
            return;
        }
        throw ClientMessageUnpacker.unexpected("Nil", code);
    }

    public boolean unpackBoolean() {
        assert (this.refCnt > 0) : "Unpacker is closed";
        byte code = this.buf.readByte();
        switch (code) {
            case -62: {
                return false;
            }
            case -61: {
                return true;
            }
        }
        throw ClientMessageUnpacker.unexpected("boolean", code);
    }

    public byte unpackByte() {
        assert (this.refCnt > 0) : "Unpacker is closed";
        byte code = this.buf.readByte();
        if (MessagePack.Code.isFixInt((byte)code)) {
            return code;
        }
        switch (code) {
            case -52: 
            case -48: {
                return this.buf.readByte();
            }
        }
        throw ClientMessageUnpacker.unexpected("Integer", code);
    }

    public short unpackShort() {
        assert (this.refCnt > 0) : "Unpacker is closed";
        byte code = this.buf.readByte();
        if (MessagePack.Code.isFixInt((byte)code)) {
            return code;
        }
        switch (code) {
            case -52: {
                return this.buf.readUnsignedByte();
            }
            case -48: {
                return this.buf.readByte();
            }
            case -51: 
            case -47: {
                return this.buf.readShort();
            }
        }
        throw ClientMessageUnpacker.unexpected("Integer", code);
    }

    public long unpackLong() {
        assert (this.refCnt > 0) : "Unpacker is closed";
        byte code = this.buf.readByte();
        if (MessagePack.Code.isFixInt((byte)code)) {
            return code;
        }
        switch (code) {
            case -52: {
                return this.buf.readUnsignedByte();
            }
            case -48: {
                return this.buf.readByte();
            }
            case -51: {
                return this.buf.readUnsignedShort();
            }
            case -47: {
                return this.buf.readShort();
            }
            case -50: {
                return this.buf.readUnsignedInt();
            }
            case -46: {
                return this.buf.readInt();
            }
            case -49: 
            case -45: {
                return this.buf.readLong();
            }
        }
        throw ClientMessageUnpacker.unexpected("Integer", code);
    }

    public BigInteger unpackBigInteger() {
        assert (this.refCnt > 0) : "Unpacker is closed";
        byte code = this.buf.readByte();
        if (MessagePack.Code.isFixInt((byte)code)) {
            return BigInteger.valueOf(code);
        }
        switch (code) {
            case -52: {
                return BigInteger.valueOf(this.buf.readUnsignedByte());
            }
            case -51: {
                return BigInteger.valueOf(this.buf.readUnsignedShort());
            }
            case -50: {
                return BigInteger.valueOf(this.buf.readUnsignedInt());
            }
            case -49: {
                long u64 = this.buf.readLong();
                if (u64 < 0L) {
                    return BigInteger.valueOf(u64 + Long.MAX_VALUE + 1L).setBit(63);
                }
                return BigInteger.valueOf(u64);
            }
            case -48: {
                return BigInteger.valueOf(this.buf.readByte());
            }
            case -47: {
                return BigInteger.valueOf(this.buf.readShort());
            }
            case -46: {
                return BigInteger.valueOf(this.buf.readInt());
            }
            case -45: {
                return BigInteger.valueOf(this.buf.readLong());
            }
        }
        throw ClientMessageUnpacker.unexpected("BigInteger", code);
    }

    public float unpackFloat() {
        assert (this.refCnt > 0) : "Unpacker is closed";
        byte code = this.buf.readByte();
        switch (code) {
            case -54: {
                return this.buf.readFloat();
            }
            case -53: {
                return (float)this.buf.readDouble();
            }
        }
        throw ClientMessageUnpacker.unexpected("Float", code);
    }

    public double unpackDouble() {
        assert (this.refCnt > 0) : "Unpacker is closed";
        byte code = this.buf.readByte();
        switch (code) {
            case -54: {
                return this.buf.readFloat();
            }
            case -53: {
                return this.buf.readDouble();
            }
        }
        throw ClientMessageUnpacker.unexpected("Float", code);
    }

    public int unpackArrayHeader() {
        assert (this.refCnt > 0) : "Unpacker is closed";
        byte code = this.buf.readByte();
        if (MessagePack.Code.isFixedArray((byte)code)) {
            return code & 0xF;
        }
        switch (code) {
            case -36: {
                return this.readLength16();
            }
            case -35: {
                return this.readLength32();
            }
        }
        throw ClientMessageUnpacker.unexpected("Array", code);
    }

    public int unpackMapHeader() {
        assert (this.refCnt > 0) : "Unpacker is closed";
        byte code = this.buf.readByte();
        if (MessagePack.Code.isFixedMap((byte)code)) {
            return code & 0xF;
        }
        switch (code) {
            case -34: {
                return this.readLength16();
            }
            case -33: {
                return this.readLength32();
            }
        }
        throw ClientMessageUnpacker.unexpected("Map", code);
    }

    public ExtensionTypeHeader unpackExtensionTypeHeader() {
        assert (this.refCnt > 0) : "Unpacker is closed";
        byte code = this.buf.readByte();
        switch (code) {
            case -44: {
                return new ExtensionTypeHeader(this.buf.readByte(), 1);
            }
            case -43: {
                return new ExtensionTypeHeader(this.buf.readByte(), 2);
            }
            case -42: {
                return new ExtensionTypeHeader(this.buf.readByte(), 4);
            }
            case -41: {
                return new ExtensionTypeHeader(this.buf.readByte(), 8);
            }
            case -40: {
                return new ExtensionTypeHeader(this.buf.readByte(), 16);
            }
            case -57: {
                int length = this.readLength8();
                byte type = this.buf.readByte();
                return new ExtensionTypeHeader(type, length);
            }
            case -56: {
                int length = this.readLength16();
                byte type = this.buf.readByte();
                return new ExtensionTypeHeader(type, length);
            }
            case -55: {
                int length = this.readLength32();
                byte type = this.buf.readByte();
                return new ExtensionTypeHeader(type, length);
            }
        }
        throw ClientMessageUnpacker.unexpected("Ext", code);
    }

    public int unpackBinaryHeader() {
        assert (this.refCnt > 0) : "Unpacker is closed";
        byte code = this.buf.readByte();
        if (MessagePack.Code.isFixedRaw((byte)code)) {
            return code & 0x1F;
        }
        switch (code) {
            case -60: {
                return this.readLength8();
            }
            case -59: {
                return this.readLength16();
            }
            case -58: {
                return this.readLength32();
            }
        }
        throw ClientMessageUnpacker.unexpected("Binary", code);
    }

    public boolean tryUnpackNil() {
        assert (this.refCnt > 0) : "Unpacker is closed";
        int idx = this.buf.readerIndex();
        byte code = this.buf.getByte(idx);
        if (code == -64) {
            this.buf.readerIndex(idx + 1);
            return true;
        }
        return false;
    }

    public boolean tryUnpackNoValue() {
        byte extCode;
        assert (this.refCnt > 0) : "Unpacker is closed";
        int idx = this.buf.readerIndex();
        byte code = this.buf.getByte(idx);
        if (code == -44 && (extCode = this.buf.getByte(idx + 1)) == 10) {
            this.buf.readerIndex(idx + 3);
            return true;
        }
        return false;
    }

    public byte[] readPayload(int length) {
        assert (this.refCnt > 0) : "Unpacker is closed";
        byte[] res = new byte[length];
        this.buf.readBytes(res);
        return res;
    }

    public void skipValues(int count) {
        assert (this.refCnt > 0) : "Unpacker is closed";
        while (count > 0) {
            byte code = this.buf.readByte();
            MessageFormat f = MessageFormat.valueOf((byte)code);
            switch (f) {
                case POSFIXINT: 
                case NEGFIXINT: 
                case BOOLEAN: 
                case NIL: {
                    break;
                }
                case FIXMAP: {
                    int mapLen = code & 0xF;
                    count += mapLen * 2;
                    break;
                }
                case FIXARRAY: {
                    int arrayLen = code & 0xF;
                    count += arrayLen;
                    break;
                }
                case FIXSTR: {
                    int strLen = code & 0x1F;
                    this.skipBytes(strLen);
                    break;
                }
                case INT8: 
                case UINT8: {
                    this.skipBytes(1);
                    break;
                }
                case INT16: 
                case UINT16: {
                    this.skipBytes(2);
                    break;
                }
                case INT32: 
                case UINT32: 
                case FLOAT32: {
                    this.skipBytes(4);
                    break;
                }
                case INT64: 
                case UINT64: 
                case FLOAT64: {
                    this.skipBytes(8);
                    break;
                }
                case BIN8: 
                case STR8: {
                    this.skipBytes(this.readLength8());
                    break;
                }
                case BIN16: 
                case STR16: {
                    this.skipBytes(this.readLength16());
                    break;
                }
                case BIN32: 
                case STR32: {
                    this.skipBytes(this.readLength32());
                    break;
                }
                case FIXEXT1: {
                    this.skipBytes(2);
                    break;
                }
                case FIXEXT2: {
                    this.skipBytes(3);
                    break;
                }
                case FIXEXT4: {
                    this.skipBytes(5);
                    break;
                }
                case FIXEXT8: {
                    this.skipBytes(9);
                    break;
                }
                case FIXEXT16: {
                    this.skipBytes(17);
                    break;
                }
                case EXT8: {
                    this.skipBytes(this.readLength8() + 1);
                    break;
                }
                case EXT16: {
                    this.skipBytes(this.readLength16() + 1);
                    break;
                }
                case EXT32: {
                    this.skipBytes(this.readLength32() + 1);
                    break;
                }
                case ARRAY16: {
                    count += this.readLength16();
                    break;
                }
                case ARRAY32: {
                    count += this.readLength32();
                    break;
                }
                case MAP16: {
                    count += this.readLength16() * 2;
                    break;
                }
                case MAP32: {
                    count += this.readLength32() * 2;
                    break;
                }
                default: {
                    throw new MessageFormatException("Unexpected format code: " + code);
                }
            }
            --count;
        }
    }

    public UUID unpackUuid() {
        assert (this.refCnt > 0) : "Unpacker is closed";
        ExtensionTypeHeader hdr = this.unpackExtensionTypeHeader();
        byte type = hdr.getType();
        int len = hdr.getLength();
        if (type != 3) {
            throw new MessageTypeException("Expected UUID extension (3), but got " + type);
        }
        if (len != 16) {
            throw new MessageSizeException("Expected 16 bytes for UUID extension, but got " + len, (long)len);
        }
        return new UUID(this.buf.readLong(), this.buf.readLong());
    }

    public BigDecimal unpackDecimal() {
        assert (this.refCnt > 0) : "Unpacker is closed";
        ExtensionTypeHeader hdr = this.unpackExtensionTypeHeader();
        byte type = hdr.getType();
        int len = hdr.getLength();
        if (type != 2) {
            throw new MessageTypeException("Expected DECIMAL extension (2), but got " + type);
        }
        int pos = this.buf.readerIndex();
        int scale = this.unpackInt();
        int scaleSize = this.buf.readerIndex() - pos;
        byte[] bytes = this.readPayload(len - scaleSize);
        return new BigDecimal(new BigInteger(bytes), scale);
    }

    public BitSet unpackBitSet() {
        assert (this.refCnt > 0) : "Unpacker is closed";
        ExtensionTypeHeader hdr = this.unpackExtensionTypeHeader();
        byte type = hdr.getType();
        int len = hdr.getLength();
        if (type != 8) {
            throw new MessageTypeException("Expected BITSET extension (7), but got " + type);
        }
        byte[] bytes = this.readPayload(len);
        return BitSet.valueOf(bytes);
    }

    public BigInteger unpackNumber() {
        assert (this.refCnt > 0) : "Unpacker is closed";
        ExtensionTypeHeader hdr = this.unpackExtensionTypeHeader();
        byte type = hdr.getType();
        int len = hdr.getLength();
        if (type != 1) {
            throw new MessageTypeException("Expected NUMBER extension (1), but got " + type);
        }
        byte[] bytes = this.readPayload(len);
        return new BigInteger(bytes);
    }

    public int[] unpackIntArray() {
        assert (this.refCnt > 0) : "Unpacker is closed";
        int size = this.unpackArrayHeader();
        if (size == 0) {
            return ArrayUtils.INT_EMPTY_ARRAY;
        }
        int[] res = new int[size];
        for (int i = 0; i < size; ++i) {
            res[i] = this.unpackInt();
        }
        return res;
    }

    public LocalDate unpackDate() {
        assert (this.refCnt > 0) : "Unpacker is closed";
        ExtensionTypeHeader hdr = this.unpackExtensionTypeHeader();
        byte type = hdr.getType();
        int len = hdr.getLength();
        if (type != 4) {
            throw new MessageTypeException("Expected DATE extension (4), but got " + type);
        }
        if (len != 6) {
            throw new MessageSizeException("Expected 6 bytes for DATE extension, but got " + len, (long)len);
        }
        return LocalDate.of(this.buf.readInt(), this.buf.readByte(), (int)this.buf.readByte());
    }

    public LocalTime unpackTime() {
        assert (this.refCnt > 0) : "Unpacker is closed";
        ExtensionTypeHeader hdr = this.unpackExtensionTypeHeader();
        byte type = hdr.getType();
        int len = hdr.getLength();
        if (type != 5) {
            throw new MessageTypeException("Expected TIME extension (5), but got " + type);
        }
        if (len != 7) {
            throw new MessageSizeException("Expected 7 bytes for TIME extension, but got " + len, (long)len);
        }
        return LocalTime.of(this.buf.readByte(), this.buf.readByte(), this.buf.readByte(), this.buf.readInt());
    }

    public LocalDateTime unpackDateTime() {
        assert (this.refCnt > 0) : "Unpacker is closed";
        ExtensionTypeHeader hdr = this.unpackExtensionTypeHeader();
        byte type = hdr.getType();
        int len = hdr.getLength();
        if (type != 6) {
            throw new MessageTypeException("Expected DATETIME extension (6), but got " + type);
        }
        if (len != 13) {
            throw new MessageSizeException("Expected 13 bytes for DATETIME extension, but got " + len, (long)len);
        }
        return LocalDateTime.of(LocalDate.of(this.buf.readInt(), this.buf.readByte(), (int)this.buf.readByte()), LocalTime.of(this.buf.readByte(), this.buf.readByte(), this.buf.readByte(), this.buf.readInt()));
    }

    public Instant unpackTimestamp() {
        assert (this.refCnt > 0) : "Unpacker is closed";
        ExtensionTypeHeader hdr = this.unpackExtensionTypeHeader();
        byte type = hdr.getType();
        int len = hdr.getLength();
        if (type != 7) {
            throw new MessageTypeException("Expected TIMESTAMP extension (6), but got " + type);
        }
        if (len != 12) {
            throw new MessageSizeException("Expected 12 bytes for TIMESTAMP extension, but got " + len, (long)len);
        }
        return Instant.ofEpochSecond(this.buf.readLong(), this.buf.readInt());
    }

    public Object unpackObjectWithType() {
        if (this.tryUnpackNil()) {
            return null;
        }
        return this.unpackObject(this.unpackInt());
    }

    public Object unpackObject(int dataType) {
        if (this.tryUnpackNil()) {
            return null;
        }
        switch (dataType) {
            case 17: {
                return this.unpackBoolean();
            }
            case 1: {
                return this.unpackByte();
            }
            case 2: {
                return this.unpackShort();
            }
            case 3: {
                return this.unpackInt();
            }
            case 4: {
                return this.unpackLong();
            }
            case 5: {
                return Float.valueOf(this.unpackFloat());
            }
            case 6: {
                return this.unpackDouble();
            }
            case 8: {
                return this.unpackUuid();
            }
            case 9: {
                return this.unpackString();
            }
            case 10: {
                int cnt = this.unpackBinaryHeader();
                return this.readPayload(cnt);
            }
            case 7: {
                return this.unpackDecimal();
            }
            case 18: {
                return this.unpackBigInteger();
            }
            case 11: {
                return this.unpackBitSet();
            }
            case 16: {
                return this.unpackNumber();
            }
            case 12: {
                return this.unpackDate();
            }
            case 13: {
                return this.unpackTime();
            }
            case 14: {
                return this.unpackDateTime();
            }
            case 15: {
                return this.unpackTimestamp();
            }
        }
        throw new IgniteException("Unknown client data type: " + dataType);
    }

    public Object[] unpackObjectArray() {
        assert (this.refCnt > 0) : "Unpacker is closed";
        if (this.tryUnpackNil()) {
            return null;
        }
        int size = this.unpackArrayHeader();
        if (size == 0) {
            return ArrayUtils.OBJECT_EMPTY_ARRAY;
        }
        Object[] args = new Object[size];
        for (int i = 0; i < size; ++i) {
            if (this.tryUnpackNil()) continue;
            args[i] = this.unpackObject(this.unpackInt());
        }
        return args;
    }

    public ClientMessageUnpacker retain() {
        ++this.refCnt;
        this.buf.retain();
        return this;
    }

    @Override
    public void close() {
        if (this.refCnt == 0) {
            return;
        }
        --this.refCnt;
        if (this.buf.refCnt() > 0) {
            this.buf.release();
        }
    }

    public int unpackRawStringHeader() {
        byte code = this.buf.readByte();
        if (MessagePack.Code.isFixedRaw((byte)code)) {
            return code & 0x1F;
        }
        switch (code) {
            case -39: {
                return this.readLength8();
            }
            case -38: {
                return this.readLength16();
            }
            case -37: {
                return this.readLength32();
            }
        }
        throw ClientMessageUnpacker.unexpected("String", code);
    }

    private int readLength8() {
        return this.buf.readUnsignedByte();
    }

    private int readLength16() {
        return this.buf.readUnsignedShort();
    }

    private int readLength32() {
        int u32 = this.buf.readInt();
        if (u32 < 0) {
            throw ClientMessageUnpacker.overflowU32Size(u32);
        }
        return u32;
    }

    private void skipBytes(int bytes) {
        this.buf.readerIndex(this.buf.readerIndex() + bytes);
    }
}

