/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.proto;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.BitSet;
import java.util.UUID;
import org.apache.ignite.internal.client.proto.ClientMessageCommon;

public class ClientMessagePacker
implements AutoCloseable {
    private final ByteBuf buf;
    private boolean closed;

    public ClientMessagePacker(ByteBuf buf) {
        this.buf = buf.writerIndex(4);
    }

    public ByteBuf getBuffer() {
        this.buf.setInt(0, this.buf.writerIndex() - 4);
        return this.buf;
    }

    public void packNil() {
        assert (!this.closed) : "Packer is closed";
        this.buf.writeByte(-64);
    }

    public void packNoValue() {
        assert (!this.closed) : "Packer is closed";
        this.buf.writeByte(-44);
        this.buf.writeByte(10);
        this.buf.writeByte(0);
    }

    public void packBoolean(boolean b) {
        assert (!this.closed) : "Packer is closed";
        this.buf.writeByte(b ? -61 : -62);
    }

    public void packByte(byte b) {
        assert (!this.closed) : "Packer is closed";
        if (b < -32) {
            this.buf.writeByte(-48);
        }
        this.buf.writeByte((int)b);
    }

    public void packShort(short v) {
        assert (!this.closed) : "Packer is closed";
        if (v < -32) {
            if (v < -128) {
                this.buf.writeByte(-47);
                this.buf.writeShort((int)v);
            } else {
                this.buf.writeByte(-48);
                this.buf.writeByte((int)v);
            }
        } else if (v < 128) {
            this.buf.writeByte((int)v);
        } else if (v < 256) {
            this.buf.writeByte(-52);
            this.buf.writeByte((int)v);
        } else {
            this.buf.writeByte(-51);
            this.buf.writeShort((int)v);
        }
    }

    public void packInt(int i) {
        assert (!this.closed) : "Packer is closed";
        if (i < -32) {
            if (i < Short.MIN_VALUE) {
                this.buf.writeByte(-46);
                this.buf.writeInt(i);
            } else if (i < -128) {
                this.buf.writeByte(-47);
                this.buf.writeShort(i);
            } else {
                this.buf.writeByte(-48);
                this.buf.writeByte(i);
            }
        } else if (i < 128) {
            this.buf.writeByte(i);
        } else if (i < 256) {
            this.buf.writeByte(-52);
            this.buf.writeByte(i);
        } else if (i < 65536) {
            this.buf.writeByte(-51);
            this.buf.writeShort(i);
        } else {
            this.buf.writeByte(-50);
            this.buf.writeInt(i);
        }
    }

    public void packLong(long v) {
        assert (!this.closed) : "Packer is closed";
        if (v < -32L) {
            if (v < -32768L) {
                if (v < Integer.MIN_VALUE) {
                    this.buf.writeByte(-45);
                    this.buf.writeLong(v);
                } else {
                    this.buf.writeByte(-46);
                    this.buf.writeInt((int)v);
                }
            } else if (v < -128L) {
                this.buf.writeByte(-47);
                this.buf.writeShort((int)((short)v));
            } else {
                this.buf.writeByte(-48);
                this.buf.writeByte((int)((byte)v));
            }
        } else if (v < 128L) {
            this.buf.writeByte((int)((byte)v));
        } else if (v < 65536L) {
            if (v < 256L) {
                this.buf.writeByte(-52);
                this.buf.writeByte((int)((byte)v));
            } else {
                this.buf.writeByte(-51);
                this.buf.writeShort((int)((short)v));
            }
        } else if (v < 0x100000000L) {
            this.buf.writeByte(-50);
            this.buf.writeInt((int)v);
        } else {
            this.buf.writeByte(-49);
            this.buf.writeLong(v);
        }
    }

    public void packBigInteger(BigInteger bi) {
        assert (!this.closed) : "Packer is closed";
        if (bi.bitLength() <= 63) {
            this.packLong(bi.longValue());
        } else if (bi.bitLength() == 64 && bi.signum() == 1) {
            this.buf.writeByte(-49);
            this.buf.writeLong(bi.longValue());
        } else {
            throw new IllegalArgumentException("MessagePack cannot serialize BigInteger larger than 2^64-1");
        }
    }

    public void packFloat(float v) {
        assert (!this.closed) : "Packer is closed";
        this.buf.writeByte(-54);
        this.buf.writeFloat(v);
    }

    public void packDouble(double v) {
        assert (!this.closed) : "Packer is closed";
        this.buf.writeByte(-53);
        this.buf.writeDouble(v);
    }

    public void packString(String s) {
        assert (!this.closed) : "Packer is closed";
        int maxBytes = ByteBufUtil.utf8MaxBytes((CharSequence)s);
        int headerSize = this.getStringHeaderSize(maxBytes);
        int headerPos = this.buf.writerIndex();
        this.buf.writerIndex(headerPos + headerSize);
        int bytesWritten = ByteBufUtil.writeUtf8((ByteBuf)this.buf, (CharSequence)s);
        int endPos = this.buf.writerIndex();
        this.buf.writerIndex(headerPos);
        if (headerSize == 1) {
            this.buf.writeByte((int)((byte)(0xFFFFFFA0 | bytesWritten)));
        } else if (headerSize == 2) {
            this.buf.writeByte(-39);
            this.buf.writeByte(bytesWritten);
        } else if (headerSize == 3) {
            this.buf.writeByte(-38);
            this.buf.writeShort(bytesWritten);
        } else {
            assert (headerSize == 5) : "headerSize == 5";
            this.buf.writeByte(-37);
            this.buf.writeInt(bytesWritten);
        }
        this.buf.writerIndex(endPos);
    }

    public void packArrayHeader(int arraySize) {
        assert (!this.closed) : "Packer is closed";
        if (arraySize < 0) {
            throw new IllegalArgumentException("array size must be >= 0");
        }
        if (arraySize < 16) {
            this.buf.writeByte((int)((byte)(0xFFFFFF90 | arraySize)));
        } else if (arraySize < 65536) {
            this.buf.writeByte(-36);
            this.buf.writeShort(arraySize);
        } else {
            this.buf.writeByte(-35);
            this.buf.writeInt(arraySize);
        }
    }

    public void packMapHeader(int mapSize) {
        assert (!this.closed) : "Packer is closed";
        if (mapSize < 0) {
            throw new IllegalArgumentException("map size must be >= 0");
        }
        if (mapSize < 16) {
            this.buf.writeByte((int)((byte)(0xFFFFFF80 | mapSize)));
        } else if (mapSize < 65536) {
            this.buf.writeByte(-34);
            this.buf.writeShort(mapSize);
        } else {
            this.buf.writeByte(-33);
            this.buf.writeInt(mapSize);
        }
    }

    public void packExtensionTypeHeader(byte extType, int payloadLen) {
        assert (!this.closed) : "Packer is closed";
        if (payloadLen < 256) {
            if (payloadLen > 0 && (payloadLen & payloadLen - 1) == 0) {
                if (payloadLen == 1) {
                    this.buf.writeByte(-44);
                    this.buf.writeByte((int)extType);
                } else if (payloadLen == 2) {
                    this.buf.writeByte(-43);
                    this.buf.writeByte((int)extType);
                } else if (payloadLen == 4) {
                    this.buf.writeByte(-42);
                    this.buf.writeByte((int)extType);
                } else if (payloadLen == 8) {
                    this.buf.writeByte(-41);
                    this.buf.writeByte((int)extType);
                } else if (payloadLen == 16) {
                    this.buf.writeByte(-40);
                    this.buf.writeByte((int)extType);
                } else {
                    this.buf.writeByte(-57);
                    this.buf.writeByte(payloadLen);
                    this.buf.writeByte((int)extType);
                }
            } else {
                this.buf.writeByte(-57);
                this.buf.writeByte(payloadLen);
                this.buf.writeByte((int)extType);
            }
        } else if (payloadLen < 65536) {
            this.buf.writeByte(-56);
            this.buf.writeShort(payloadLen);
            this.buf.writeByte((int)extType);
        } else {
            this.buf.writeByte(-55);
            this.buf.writeInt(payloadLen);
            this.buf.writeByte((int)extType);
        }
    }

    public void packBinaryHeader(int len) {
        assert (!this.closed) : "Packer is closed";
        if (len < 256) {
            this.buf.writeByte(-60);
            this.buf.writeByte(len);
        } else if (len < 65536) {
            this.buf.writeByte(-59);
            this.buf.writeShort(len);
        } else {
            this.buf.writeByte(-58);
            this.buf.writeInt(len);
        }
    }

    public void packRawStringHeader(int len) {
        assert (!this.closed) : "Packer is closed";
        if (len < 32) {
            this.buf.writeByte((int)((byte)(0xFFFFFFA0 | len)));
        } else if (len < 256) {
            this.buf.writeByte(-39);
            this.buf.writeByte(len);
        } else if (len < 65536) {
            this.buf.writeByte(-38);
            this.buf.writeShort(len);
        } else {
            this.buf.writeByte(-37);
            this.buf.writeInt(len);
        }
    }

    public void writePayload(byte[] src) {
        assert (!this.closed) : "Packer is closed";
        this.buf.writeBytes(src);
    }

    public void writePayload(byte[] src, int off, int len) {
        assert (!this.closed) : "Packer is closed";
        this.buf.writeBytes(src, off, len);
    }

    public void packUuid(UUID val) {
        assert (!this.closed) : "Packer is closed";
        this.packExtensionTypeHeader((byte)3, 16);
        this.buf.writeLong(val.getMostSignificantBits());
        this.buf.writeLong(val.getLeastSignificantBits());
    }

    public void packDecimal(BigDecimal val) {
        assert (!this.closed) : "Packer is closed";
        byte[] unscaledValue = val.unscaledValue().toByteArray();
        int scale = val.scale();
        int scaleBytes = 5;
        if (scale < 128) {
            scaleBytes = 1;
        } else if (scale < 256) {
            scaleBytes = 2;
        } else if (scale < 65536) {
            scaleBytes = 3;
        }
        int payloadLen = scaleBytes + unscaledValue.length;
        this.packExtensionTypeHeader((byte)2, payloadLen);
        switch (scaleBytes) {
            case 1: {
                this.buf.writeByte(scale);
                break;
            }
            case 2: {
                this.buf.writeByte(-52);
                this.buf.writeByte(scale);
                break;
            }
            case 3: {
                this.buf.writeByte(-51);
                this.buf.writeShort(scale);
                break;
            }
            default: {
                this.buf.writeByte(-50);
                this.buf.writeInt(scale);
            }
        }
        this.buf.writeBytes(unscaledValue);
    }

    public void packNumber(BigInteger val) {
        assert (!this.closed) : "Packer is closed";
        byte[] data = val.toByteArray();
        this.packExtensionTypeHeader((byte)1, data.length);
        this.buf.writeBytes(data);
    }

    public void packBitSet(BitSet val) {
        assert (!this.closed) : "Packer is closed";
        byte[] data = val.toByteArray();
        this.packExtensionTypeHeader((byte)8, data.length);
        this.buf.writeBytes(data);
    }

    public void packIntArray(int[] arr) {
        assert (!this.closed) : "Packer is closed";
        if (arr == null) {
            this.packNil();
            return;
        }
        this.packArrayHeader(arr.length);
        for (int i : arr) {
            this.packInt(i);
        }
    }

    public void packDate(LocalDate val) {
        assert (!this.closed) : "Packer is closed";
        this.packExtensionTypeHeader((byte)4, 6);
        this.buf.writeInt(val.getYear());
        this.buf.writeByte(val.getMonthValue());
        this.buf.writeByte(val.getDayOfMonth());
    }

    public void packTime(LocalTime val) {
        assert (!this.closed) : "Packer is closed";
        this.packExtensionTypeHeader((byte)5, 7);
        this.buf.writeByte(val.getHour());
        this.buf.writeByte(val.getMinute());
        this.buf.writeByte(val.getSecond());
        this.buf.writeInt(val.getNano());
    }

    public void packDateTime(LocalDateTime val) {
        assert (!this.closed) : "Packer is closed";
        this.packExtensionTypeHeader((byte)6, 13);
        this.buf.writeInt(val.getYear());
        this.buf.writeByte(val.getMonthValue());
        this.buf.writeByte(val.getDayOfMonth());
        this.buf.writeByte(val.getHour());
        this.buf.writeByte(val.getMinute());
        this.buf.writeByte(val.getSecond());
        this.buf.writeInt(val.getNano());
    }

    public void packTimestamp(Instant val) {
        assert (!this.closed) : "Packer is closed";
        this.packExtensionTypeHeader((byte)7, 12);
        this.buf.writeLong(val.getEpochSecond());
        this.buf.writeInt(val.getNano());
    }

    public void packObject(Object val) {
        if (val == null) {
            this.packNil();
            return;
        }
        if (val == ClientMessageCommon.NO_VALUE) {
            this.packNoValue();
            return;
        }
        if (val instanceof Byte) {
            this.packByte((Byte)val);
            return;
        }
        if (val instanceof Short) {
            this.packShort((Short)val);
            return;
        }
        if (val instanceof Integer) {
            this.packInt((Integer)val);
            return;
        }
        if (val instanceof Long) {
            this.packLong((Long)val);
            return;
        }
        if (val instanceof Float) {
            this.packFloat(((Float)val).floatValue());
            return;
        }
        if (val instanceof Double) {
            this.packDouble((Double)val);
            return;
        }
        if (val instanceof UUID) {
            this.packUuid((UUID)val);
            return;
        }
        if (val instanceof String) {
            this.packString((String)val);
            return;
        }
        if (val instanceof byte[]) {
            byte[] bytes = (byte[])val;
            this.packBinaryHeader(bytes.length);
            this.writePayload(bytes);
            return;
        }
        if (val instanceof BigDecimal) {
            this.packDecimal((BigDecimal)val);
            return;
        }
        if (val instanceof BigInteger) {
            this.packNumber((BigInteger)val);
            return;
        }
        if (val instanceof BitSet) {
            this.packBitSet((BitSet)val);
            return;
        }
        if (val instanceof LocalDate) {
            this.packDate((LocalDate)val);
            return;
        }
        if (val instanceof LocalTime) {
            this.packTime((LocalTime)val);
            return;
        }
        if (val instanceof LocalDateTime) {
            this.packDateTime((LocalDateTime)val);
            return;
        }
        if (val instanceof Instant) {
            this.packTimestamp((Instant)val);
            return;
        }
        throw new UnsupportedOperationException("Unsupported type, can't serialize: " + val.getClass());
    }

    public void packObjectWithType(Object obj) {
        if (obj == null) {
            this.packNil();
            return;
        }
        Class<?> cls = obj.getClass();
        if (cls == Boolean.class) {
            this.packInt(17);
            this.packBoolean((Boolean)obj);
        } else if (cls == Byte.class) {
            this.packInt(1);
            this.packByte((Byte)obj);
        } else if (cls == Short.class) {
            this.packInt(2);
            this.packShort((Short)obj);
        } else if (cls == Integer.class) {
            this.packInt(3);
            this.packInt((Integer)obj);
        } else if (cls == Long.class) {
            this.packInt(4);
            this.packLong((Long)obj);
        } else if (cls == Float.class) {
            this.packInt(5);
            this.packFloat(((Float)obj).floatValue());
        } else if (cls == Double.class) {
            this.packInt(6);
            this.packDouble((Double)obj);
        } else if (cls == String.class) {
            this.packInt(9);
            this.packString((String)obj);
        } else if (cls == UUID.class) {
            this.packInt(8);
            this.packUuid((UUID)obj);
        } else if (cls == LocalDate.class) {
            this.packInt(12);
            this.packDate((LocalDate)obj);
        } else if (cls == LocalTime.class) {
            this.packInt(13);
            this.packTime((LocalTime)obj);
        } else if (cls == LocalDateTime.class) {
            this.packInt(14);
            this.packDateTime((LocalDateTime)obj);
        } else if (cls == Instant.class) {
            this.packInt(15);
            this.packTimestamp((Instant)obj);
        } else if (cls == byte[].class) {
            this.packInt(10);
            this.packBinaryHeader(((byte[])obj).length);
            this.writePayload((byte[])obj);
        } else if (cls == Date.class) {
            this.packInt(12);
            this.packDate(((Date)obj).toLocalDate());
        } else if (cls == Time.class) {
            this.packInt(13);
            this.packTime(((Time)obj).toLocalTime());
        } else if (cls == Timestamp.class) {
            this.packInt(15);
            this.packTimestamp(((java.util.Date)obj).toInstant());
        } else if (cls == BigDecimal.class) {
            this.packInt(7);
            this.packDecimal((BigDecimal)obj);
        } else if (cls == BigInteger.class) {
            this.packInt(18);
            this.packBigInteger((BigInteger)obj);
        } else if (cls == BitSet.class) {
            this.packInt(11);
            this.packBitSet((BitSet)obj);
        } else {
            throw new UnsupportedOperationException("Custom objects are not supported");
        }
    }

    public void packObjectArray(Object[] args) {
        assert (!this.closed) : "Packer is closed";
        if (args == null) {
            this.packNil();
            return;
        }
        this.packArrayHeader(args.length);
        for (Object arg : args) {
            this.packObjectWithType(arg);
        }
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.buf.refCnt() > 0) {
            this.buf.release();
        }
    }

    private int getStringHeaderSize(int len) {
        assert (!this.closed) : "Packer is closed";
        if (len < 32) {
            return 1;
        }
        if (len < 256) {
            return 2;
        }
        if (len < 65536) {
            return 3;
        }
        return 5;
    }
}

