/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.store.cassandra.session.pool;

import com.datastax.driver.core.Session;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.ignite.cache.store.cassandra.session.CassandraSessionImpl;
import org.apache.ignite.cache.store.cassandra.session.pool.SessionWrapper;

public class SessionPool {
    private static final long SLEEP_TIMEOUT = 60000L;
    private static final Map<CassandraSessionImpl, SessionWrapper> sessions = new HashMap<CassandraSessionImpl, SessionWrapper>();
    private static SessionMonitor monitorSingleton;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void put(CassandraSessionImpl cassandraSessionImpl, Session session, long l) {
        SessionWrapper sessionWrapper;
        if (cassandraSessionImpl == null || session == null) {
            return;
        }
        Map<CassandraSessionImpl, SessionWrapper> map = sessions;
        synchronized (map) {
            sessionWrapper = sessions.put(cassandraSessionImpl, new SessionWrapper(session, l));
            if (monitorSingleton == null || Thread.State.TERMINATED.equals((Object)monitorSingleton.getState())) {
                monitorSingleton = new SessionMonitor();
                monitorSingleton.setDaemon(true);
                monitorSingleton.setName("Cassandra-sessions-pool");
                monitorSingleton.start();
            }
        }
        if (sessionWrapper != null) {
            sessionWrapper.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session get(CassandraSessionImpl cassandraSessionImpl) {
        SessionWrapper sessionWrapper;
        if (cassandraSessionImpl == null) {
            return null;
        }
        Map<CassandraSessionImpl, SessionWrapper> map = sessions;
        synchronized (map) {
            sessionWrapper = sessions.remove(cassandraSessionImpl);
        }
        return sessionWrapper == null ? null : sessionWrapper.driverSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void release() {
        LinkedList<SessionWrapper> linkedList;
        Object object = sessions;
        synchronized (object) {
            try {
                if (sessions.isEmpty()) {
                    return;
                }
                linkedList = new LinkedList<SessionWrapper>();
                for (SessionWrapper sessionWrapper : sessions.values()) {
                    linkedList.add(sessionWrapper);
                }
                sessions.clear();
            }
            finally {
                if (!(Thread.currentThread() instanceof SessionMonitor) && monitorSingleton != null) {
                    try {
                        monitorSingleton.interrupt();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        object = linkedList.iterator();
        while (object.hasNext()) {
            SessionWrapper sessionWrapper = (SessionWrapper)object.next();
            sessionWrapper.release();
        }
        return;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                SessionPool.release();
            }
        });
    }

    private static class SessionMonitor
    extends Thread {
        private SessionMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (true) {
                    int n;
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException interruptedException) {
                        SessionPool.release();
                        return;
                    }
                    LinkedList<Map.Entry> linkedList = new LinkedList<Map.Entry>();
                    Map map = sessions;
                    synchronized (map) {
                        n = sessions.size();
                        for (Map.Entry entry : sessions.entrySet()) {
                            if (!((SessionWrapper)entry.getValue()).expired()) continue;
                            linkedList.add(entry);
                        }
                        for (Map.Entry entry : linkedList) {
                            sessions.remove(entry.getKey());
                        }
                    }
                    for (Map.Entry entry : linkedList) {
                        ((SessionWrapper)entry.getValue()).release();
                    }
                    if (n != linkedList.size()) continue;
                    return;
                }
            }
            finally {
                SessionPool.release();
            }
        }
    }
}

