/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.store.cassandra.persistence;

import com.datastax.driver.core.DataType;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.cache.store.cassandra.common.CassandraHelper;
import org.apache.ignite.cache.store.cassandra.common.PropertyMappingHelper;
import org.apache.ignite.cache.store.cassandra.persistence.PersistenceStrategy;
import org.apache.ignite.cache.store.cassandra.persistence.PojoField;
import org.apache.ignite.cache.store.cassandra.persistence.PojoFieldAccessor;
import org.apache.ignite.cache.store.cassandra.serializer.JavaSerializer;
import org.apache.ignite.cache.store.cassandra.serializer.Serializer;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class PersistenceSettings
implements Serializable {
    private static final String STRATEGY_ATTR = "strategy";
    private static final String COLUMN_ATTR = "column";
    private static final String SERIALIZER_ATTR = "serializer";
    private static final String CLASS_ATTR = "class";
    private PersistenceStrategy stgy;
    private Class javaCls;
    private String col;
    private Serializer serializer = new JavaSerializer();
    private List<String> tableColumns;
    private List<PojoField> casUniqueFields;

    public static PropertyDescriptor findPropertyDescriptor(List<PropertyDescriptor> list, String string) {
        if (list == null || list.isEmpty() || string == null || string.trim().isEmpty()) {
            return null;
        }
        for (PropertyDescriptor propertyDescriptor : list) {
            if (!propertyDescriptor.getName().equals(string)) continue;
            return propertyDescriptor;
        }
        return null;
    }

    public PersistenceSettings(Element element) {
        if (element == null) {
            throw new IllegalArgumentException("DOM element representing key/value persistence object can't be null");
        }
        if (!element.hasAttribute(STRATEGY_ATTR)) {
            throw new IllegalArgumentException("DOM element representing key/value persistence object should have 'strategy' attribute");
        }
        try {
            this.stgy = PersistenceStrategy.valueOf(element.getAttribute(STRATEGY_ATTR).trim().toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Incorrect persistence strategy specified: " + element.getAttribute(STRATEGY_ATTR));
        }
        if (!element.hasAttribute(CLASS_ATTR) && PersistenceStrategy.BLOB != this.stgy) {
            throw new IllegalArgumentException("DOM element representing key/value persistence object should have 'class' attribute or have BLOB persistence strategy");
        }
        try {
            this.javaCls = element.hasAttribute(CLASS_ATTR) ? this.getClassInstance(element.getAttribute(CLASS_ATTR).trim()) : null;
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException("Incorrect java class specified '" + element.getAttribute(CLASS_ATTR) + "' " + "for Cassandra persistence", throwable);
        }
        if (PersistenceStrategy.BLOB != this.stgy && (ByteBuffer.class.equals((Object)this.javaCls) || byte[].class.equals((Object)this.javaCls))) {
            throw new IllegalArgumentException("Java class '" + element.getAttribute(CLASS_ATTR) + "' " + "specified could only be persisted using BLOB persistence strategy");
        }
        if (PersistenceStrategy.PRIMITIVE == this.stgy && PropertyMappingHelper.getCassandraType(this.javaCls) == null) {
            throw new IllegalArgumentException("Current implementation doesn't support persisting '" + this.javaCls.getName() + "' object using PRIMITIVE strategy");
        }
        if (PersistenceStrategy.POJO == this.stgy) {
            if (this.javaCls == null) {
                throw new IllegalStateException("Object java class should be specified for POJO persistence strategy");
            }
            try {
                this.javaCls.getConstructor(new Class[0]);
            }
            catch (Throwable throwable) {
                throw new IllegalArgumentException("Java class '" + this.javaCls.getName() + "' couldn't be used as POJO " + "cause it doesn't have no arguments constructor", throwable);
            }
        }
        if (element.hasAttribute(COLUMN_ATTR)) {
            if (PersistenceStrategy.BLOB != this.stgy && PersistenceStrategy.PRIMITIVE != this.stgy) {
                throw new IllegalArgumentException("Incorrect configuration of Cassandra key/value persistence settings, 'column' attribute is only applicable for PRIMITIVE or BLOB strategy");
            }
            this.col = element.getAttribute(COLUMN_ATTR).trim();
        }
        if (element.hasAttribute(SERIALIZER_ATTR)) {
            if (PersistenceStrategy.BLOB != this.stgy && PersistenceStrategy.POJO != this.stgy) {
                throw new IllegalArgumentException("Incorrect configuration of Cassandra key/value persistence settings, 'serializer' attribute is only applicable for BLOB and POJO strategies");
            }
            Object object = this.newObjectInstance(element.getAttribute(SERIALIZER_ATTR).trim());
            if (!(object instanceof Serializer)) {
                throw new IllegalArgumentException("Incorrect configuration of Cassandra key/value persistence settings, serializer class '" + element.getAttribute(SERIALIZER_ATTR) + "' doesn't implement '" + Serializer.class.getName() + "' interface");
            }
            this.serializer = (Serializer)object;
        }
        if ((PersistenceStrategy.BLOB == this.stgy || PersistenceStrategy.PRIMITIVE == this.stgy) && this.col == null) {
            this.col = this.defaultColumnName();
        }
    }

    public Class getJavaClass() {
        return this.javaCls;
    }

    public PersistenceStrategy getStrategy() {
        return this.stgy;
    }

    public String getColumn() {
        return this.col;
    }

    public Serializer getSerializer() {
        return this.serializer;
    }

    public abstract List<PojoField> getFields();

    public PojoField getFieldByColumn(String string) {
        List<PojoField> list = this.getFields();
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (PojoField pojoField : list) {
            if (!pojoField.getColumn().equals(string)) continue;
            return pojoField;
        }
        return null;
    }

    public List<PojoField> cassandraUniqueFields() {
        return this.casUniqueFields;
    }

    public List<String> getTableColumns() {
        return this.tableColumns;
    }

    public String getTableColumnsDDL() {
        return this.getTableColumnsDDL(null);
    }

    public String getTableColumnsDDL(Set<String> set) {
        if (PersistenceStrategy.BLOB == this.stgy) {
            return "  \"" + this.col + "\" " + DataType.Name.BLOB.toString();
        }
        if (PersistenceStrategy.PRIMITIVE == this.stgy) {
            return "  \"" + this.col + "\" " + PropertyMappingHelper.getCassandraType(this.javaCls);
        }
        List<PojoField> list = this.getFields();
        if (list == null || list.isEmpty()) {
            throw new IllegalStateException("There are no POJO fields found for '" + this.javaCls.toString() + "' class to be presented as a Cassandra primary key");
        }
        HashSet<String> hashSet = new HashSet<String>();
        StringBuilder stringBuilder = new StringBuilder();
        for (PojoField pojoField : list) {
            if (set != null && set.contains(pojoField.getColumn()) || hashSet.contains(pojoField.getColumn())) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",\n");
            }
            stringBuilder.append("  ").append(pojoField.getColumnDDL());
            hashSet.add(pojoField.getColumn());
        }
        return stringBuilder.toString();
    }

    protected abstract String defaultColumnName();

    protected abstract PojoField createPojoField(Element var1, Class var2);

    protected abstract PojoField createPojoField(PojoFieldAccessor var1);

    protected void init() {
        if (this.getColumn() != null && !this.getColumn().trim().isEmpty()) {
            this.tableColumns = new LinkedList<String>();
            this.tableColumns.add(this.getColumn());
            this.tableColumns = Collections.unmodifiableList(this.tableColumns);
            return;
        }
        List<PojoField> list = this.getFields();
        if (list == null || list.isEmpty()) {
            return;
        }
        this.tableColumns = new LinkedList<String>();
        this.casUniqueFields = new LinkedList<PojoField>();
        for (PojoField pojoField : list) {
            if (this.tableColumns.contains(pojoField.getColumn())) continue;
            this.tableColumns.add(pojoField.getColumn());
            this.casUniqueFields.add(pojoField);
        }
        this.tableColumns = Collections.unmodifiableList(this.tableColumns);
        this.casUniqueFields = Collections.unmodifiableList(this.casUniqueFields);
    }

    protected void checkDuplicates(List<PojoField> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (PojoField pojoField : list) {
            boolean bl = false;
            boolean bl2 = false;
            for (PojoField pojoField2 : list) {
                if (pojoField.getName().equals(pojoField2.getName())) {
                    if (bl) {
                        throw new IllegalArgumentException("Incorrect Cassandra persistence settings, two POJO fields with the same name '" + pojoField.getName() + "' specified");
                    }
                    bl = true;
                }
                if (!pojoField.getColumn().equals(pojoField2.getColumn())) continue;
                if (bl2 && !CassandraHelper.isCassandraCompatibleTypes(pojoField.getJavaClass(), pojoField2.getJavaClass())) {
                    throw new IllegalArgumentException("Field '" + pojoField.getName() + "' shares the same Cassandra table " + "column '" + pojoField.getColumn() + "' with field '" + pojoField2.getName() + "', but their Java " + "classes are different. Fields sharing the same column should have the same " + "Java class as their type or should be mapped to the same Cassandra primitive type.");
                }
                bl2 = true;
            }
        }
    }

    protected List<PojoField> detectPojoFields(NodeList nodeList) {
        Object[] objectArray;
        LinkedList<PojoField> linkedList = new LinkedList<PojoField>();
        if (nodeList != null && nodeList.getLength() != 0) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                PojoField pojoField = this.createPojoField((Element)nodeList.item(i), this.getJavaClass());
                PropertyMappingHelper.getPojoFieldAccessor(this.getJavaClass(), pojoField.getName());
                linkedList.add(pojoField);
            }
            return linkedList;
        }
        PropertyDescriptor[] propertyDescriptorArray = PropertyUtils.getPropertyDescriptors((Class)this.getJavaClass());
        if (propertyDescriptorArray != null) {
            objectArray = propertyDescriptorArray;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object object = objectArray[i];
                if (((PropertyDescriptor)object).getWriteMethod() == null) continue;
                Object object2 = null;
                try {
                    object2 = this.getJavaClass().getDeclaredField(((FeatureDescriptor)object).getName());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                linkedList.add(this.createPojoField(new PojoFieldAccessor((PropertyDescriptor)object, (Field)object2)));
            }
        }
        if ((objectArray = this.getJavaClass().getDeclaredFields()) != null) {
            for (Object object2 : objectArray) {
                if (((Field)object2).getAnnotation(QuerySqlField.class) == null || PojoField.containsField(linkedList, ((Field)object2).getName())) continue;
                linkedList.add(this.createPojoField(new PojoFieldAccessor((Field)object2)));
            }
        }
        return linkedList;
    }

    private Class getClassInstance(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                return Class.forName(string, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException2) {
                try {
                    return Class.forName(string, true, PersistenceSettings.class.getClassLoader());
                }
                catch (ClassNotFoundException classNotFoundException3) {
                    try {
                        return Class.forName(string, true, ClassLoader.getSystemClassLoader());
                    }
                    catch (ClassNotFoundException classNotFoundException4) {
                        throw new IgniteException("Failed to load class '" + string + "' using reflection");
                    }
                }
            }
        }
    }

    private Object newObjectInstance(String string) {
        try {
            return this.getClassInstance(string).newInstance();
        }
        catch (Throwable throwable) {
            throw new IgniteException("Failed to instantiate class '" + string + "' using default constructor", throwable);
        }
    }
}

