/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.store.cassandra.utils;

import java.io.File;
import java.util.List;
import org.apache.ignite.cache.store.cassandra.persistence.KeyValuePersistenceSettings;

public class DDLGenerator {
    public static void main(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        boolean bl = true;
        for (String string : stringArray) {
            File file = new File(string);
            if (!file.isFile()) {
                bl = false;
                System.out.println("-------------------------------------------------------------");
                System.out.println("Incorrect file specified: " + string);
                System.out.println("-------------------------------------------------------------");
                continue;
            }
            try {
                KeyValuePersistenceSettings keyValuePersistenceSettings = new KeyValuePersistenceSettings(file);
                String string2 = keyValuePersistenceSettings.getTable() != null ? keyValuePersistenceSettings.getTable() : "my_table";
                System.out.println("-------------------------------------------------------------");
                System.out.println("DDL for keyspace/table from file: " + string);
                System.out.println("-------------------------------------------------------------");
                System.out.println();
                System.out.println(keyValuePersistenceSettings.getKeyspaceDDLStatement());
                System.out.println();
                System.out.println(keyValuePersistenceSettings.getTableDDLStatement(string2));
                System.out.println();
                List<String> list = keyValuePersistenceSettings.getIndexDDLStatements(string2);
                if (list == null || list.isEmpty()) continue;
                for (String string3 : list) {
                    System.out.println(string3);
                    System.out.println();
                }
            }
            catch (Throwable throwable) {
                bl = false;
                System.out.println("-------------------------------------------------------------");
                System.out.println("Invalid file specified: " + string);
                System.out.println("-------------------------------------------------------------");
                throwable.printStackTrace();
            }
        }
        if (!bl) {
            throw new RuntimeException("Failed to process some of the specified files");
        }
    }
}

