/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.store.cassandra.persistence;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.ignite.cache.store.cassandra.persistence.PersistenceSettings;
import org.apache.ignite.cache.store.cassandra.persistence.PersistenceStrategy;
import org.apache.ignite.cache.store.cassandra.persistence.PojoFieldAccessor;
import org.apache.ignite.cache.store.cassandra.persistence.PojoValueField;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ValuePersistenceSettings
extends PersistenceSettings<PojoValueField> {
    private static final String FIELD_ELEMENT = "field";
    private List<PojoValueField> fields = new LinkedList<PojoValueField>();

    public ValuePersistenceSettings(Element element) {
        super(element);
        if (PersistenceStrategy.POJO != this.getStrategy()) {
            this.init();
            return;
        }
        NodeList nodeList = element.getElementsByTagName(FIELD_ELEMENT);
        this.fields = this.detectPojoFields(nodeList);
        if (this.fields.isEmpty()) {
            throw new IllegalStateException("Failed to initialize value fields for class '" + this.getJavaClass().getName() + "'");
        }
        this.checkDuplicates(this.fields);
        this.init();
    }

    @Override
    public List<PojoValueField> getFields() {
        return this.fields == null ? null : Collections.unmodifiableList(this.fields);
    }

    @Override
    protected String defaultColumnName() {
        return "value";
    }

    @Override
    protected PojoValueField createPojoField(Element element, Class clazz) {
        return new PojoValueField(element, clazz);
    }

    @Override
    protected PojoValueField createPojoField(PojoFieldAccessor pojoFieldAccessor) {
        return new PojoValueField(pojoFieldAccessor);
    }

    @Override
    protected PojoValueField createPojoField(PojoValueField pojoValueField, Class clazz) {
        return new PojoValueField(pojoValueField, clazz);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.fields = this.enrichFields(this.fields);
    }
}

